/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.intellij.util.SmartList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;
import org.jetbrains.k2js.translate.context.TemporaryConstVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;

public class CallArgumentTranslator
extends AbstractTranslator {
    @NotNull
    private final ResolvedCall<?> resolvedCall;
    @Nullable
    private final JsExpression receiver;
    private final boolean isNativeFunctionCall;

    @NotNull
    public static ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translate"));
        }
        CallArgumentTranslator argumentTranslator = new CallArgumentTranslator(resolvedCall, receiver, context);
        ArgumentsInfo argumentsInfo = argumentTranslator.translate();
        if (argumentsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translate"));
        }
        return argumentsInfo;
    }

    public static void translateSingleArgument(@NotNull ResolvedValueArgument actualArgument, @NotNull List<JsExpression> result2, @NotNull TranslationContext context, boolean shouldWrapVarargInArray) {
        if (actualArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualArgument", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        List<ValueArgument> valueArguments = actualArgument.getArguments();
        if (actualArgument instanceof VarargValueArgument) {
            CallArgumentTranslator.translateVarargArgument(valueArguments, result2, context, shouldWrapVarargInArray);
        } else if (actualArgument instanceof DefaultValueArgument) {
            result2.add(context.namer().getUndefinedExpression());
        } else {
            assert (actualArgument instanceof ExpressionValueArgument);
            assert (valueArguments.size() == 1);
            JetExpression argumentExpression = valueArguments.get(0).getArgumentExpression();
            assert (argumentExpression != null);
            result2.add(Translation.translateAsExpression(argumentExpression, context));
        }
    }

    private static void translateVarargArgument(@NotNull List<ValueArgument> arguments, @NotNull List<JsExpression> result2, @NotNull TranslationContext context, boolean shouldWrapVarargInArray) {
        List<JsExpression> list;
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        if (arguments.isEmpty()) {
            if (shouldWrapVarargInArray) {
                result2.add(new JsArrayLiteral(Collections.<JsExpression>emptyList()));
            }
            return;
        }
        if (shouldWrapVarargInArray) {
            list = arguments.size() == 1 ? new SmartList() : new ArrayList(arguments.size());
            result2.add(new JsArrayLiteral(list));
        } else {
            list = result2;
        }
        for (ValueArgument argument : arguments) {
            JetExpression argumentExpression = argument.getArgumentExpression();
            assert (argumentExpression != null);
            list.add(Translation.translateAsExpression(argumentExpression, context));
        }
    }

    private CallArgumentTranslator(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "<init>"));
        }
        super(context);
        this.resolvedCall = resolvedCall;
        this.receiver = receiver;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject(resolvedCall.getCandidateDescriptor());
    }

    private void removeLastUndefinedArguments(@NotNull List<JsExpression> result2) {
        int i;
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "removeLastUndefinedArguments"));
        }
        for (i = result2.size() - 1; i >= 0 && result2.get(i) == this.context().namer().getUndefinedExpression(); --i) {
        }
        result2.subList(i + 1, result2.size()).clear();
    }

    private ArgumentsInfo translate() {
        List<ValueParameterDescriptor> valueParameters = this.resolvedCall.getResultingDescriptor().getValueParameters();
        if (valueParameters.isEmpty()) {
            return new ArgumentsInfo(Collections.<JsExpression>emptyList(), false, null);
        }
        boolean hasSpreadOperator = false;
        TemporaryConstVariable cachedReceiver = null;
        AbstractList result2 = new ArrayList<JsExpression>(valueParameters.size());
        List<ResolvedValueArgument> valueArgumentsByIndex = this.resolvedCall.getValueArgumentsByIndex();
        if (valueArgumentsByIndex == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + this.resolvedCall.getResultingDescriptor());
        }
        AbstractList argsBeforeVararg = null;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters) {
            ResolvedValueArgument actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            if (actualArgument instanceof VarargValueArgument) {
                assert (!hasSpreadOperator);
                List<ValueArgument> arguments = actualArgument.getArguments();
                boolean bl = hasSpreadOperator = arguments.size() == 1 && arguments.get(0).getSpreadElement() != null;
                if (this.isNativeFunctionCall && hasSpreadOperator) {
                    argsBeforeVararg = result2;
                    result2 = new SmartList();
                }
            }
            CallArgumentTranslator.translateSingleArgument(actualArgument, result2, this.context(), !this.isNativeFunctionCall && !hasSpreadOperator);
        }
        if (this.isNativeFunctionCall && hasSpreadOperator) {
            if (!argsBeforeVararg.isEmpty()) {
                JsInvocation concatArguments = new JsInvocation((JsExpression)new JsNameRef("concat", (JsExpression)new JsArrayLiteral(argsBeforeVararg)), result2);
                result2 = new SmartList<JsInvocation>(concatArguments);
            }
            if (this.receiver != null) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                result2.add(0, cachedReceiver.reference());
            } else {
                result2.add(0, JsLiteral.NULL);
            }
        }
        this.removeLastUndefinedArguments(result2);
        return new ArgumentsInfo(result2, hasSpreadOperator, cachedReceiver);
    }

    public static class ArgumentsInfo {
        private final List<JsExpression> translateArguments;
        private final boolean hasSpreadOperator;
        private final TemporaryConstVariable cachedReceiver;

        public ArgumentsInfo(List<JsExpression> arguments, boolean operator, TemporaryConstVariable receiver) {
            this.translateArguments = arguments;
            this.hasSpreadOperator = operator;
            this.cachedReceiver = receiver;
        }

        @NotNull
        public List<JsExpression> getTranslateArguments() {
            List<JsExpression> list = this.translateArguments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator$ArgumentsInfo", "getTranslateArguments"));
            }
            return list;
        }

        public boolean isHasSpreadOperator() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public TemporaryConstVariable getCachedReceiver() {
            return this.cachedReceiver;
        }
    }
}

