/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.k2js.translate.callTranslator.CallTranslator;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.InlinedCallExpressionTranslator;

public final class CallExpressionTranslator
extends AbstractCallExpressionTranslator {
    @NotNull
    public static JsExpression translate(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
        }
        if (InlinedCallExpressionTranslator.shouldBeInlined(expression, context)) {
            JsExpression jsExpression = InlinedCallExpressionTranslator.translate(expression, receiver, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = new CallExpressionTranslator(expression, receiver, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    private CallExpressionTranslator(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        super(expression, receiver, context);
    }

    @NotNull
    private JsExpression translate() {
        JsExpression jsExpression = CallTranslator.INSTANCE$.translate(this.context(), this.resolvedCall, this.receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }
}

