/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsFunction
extends JsLiteral
implements HasName {
    @NotNull
    private JsBlock body;
    private List<JsParameter> params;
    @NotNull
    private final JsScope scope;
    private JsName name;

    public JsFunction(JsScope parentScope) {
        this(parentScope, (JsName)null);
    }

    public JsFunction(JsScope parentScope, @NotNull JsBlock body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/google/dart/compiler/backend/js/ast/JsFunction", "<init>"));
        }
        this(parentScope, (JsName)null);
        this.body = body;
    }

    private JsFunction(JsScope parentScope, @Nullable JsName name) {
        this.name = name;
        this.scope = new JsScope(parentScope, name == null ? null : name.getIdent());
    }

    @NotNull
    public JsBlock getBody() {
        JsBlock jsBlock = this.body;
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsFunction", "getBody"));
        }
        return jsBlock;
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    @NotNull
    public List<JsParameter> getParameters() {
        if (this.params == null) {
            this.params = new SmartList<JsParameter>();
        }
        List<JsParameter> list = this.params;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsFunction", "getParameters"));
        }
        return list;
    }

    @NotNull
    public JsScope getScope() {
        JsScope jsScope = this.scope;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsFunction", "getScope"));
        }
        return jsScope;
    }

    public void setBody(@NotNull JsBlock body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/google/dart/compiler/backend/js/ast/JsFunction", "setBody"));
        }
        this.body = body;
    }

    public void setName(@Nullable JsName name) {
        this.name = name;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitFunction(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        visitor.acceptWithInsertRemove(this.params);
        visitor.accept(this.body);
    }
}

