/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.annotations.NotNull;

public abstract class ProgressManager {
    private static ProgressManager ourInstance = new ProgressIndicatorProvider(){

        @Override
        public ProgressIndicator getProgressIndicator() {
            ProgressManager manager = ProgressManager.getInstance();
            return manager != null ? manager.getProgressIndicator() : null;
        }

        @Override
        protected void doCheckCanceled() throws ProcessCanceledException {
            ProgressManager manager = ProgressManager.getInstance();
            if (manager != null) {
                manager.doCheckCanceled();
            }
        }

        @Override
        public NonCancelableSection startNonCancelableSection() {
            ProgressManager manager = ProgressManager.getInstance();
            return manager != null ? manager.startNonCancelableSection() : NonCancelableSection.EMPTY;
        }
    };
    protected static volatile boolean ourNeedToCheckCancel = false;
    protected static final ThreadLocal<ProgressIndicator> myThreadIndicator = new ThreadLocal();

    public static ProgressManager getInstance() {
        if (ourInstance == null) {
            ourInstance = ServiceManager.getService(ProgressManager.class);
        }
        return ourInstance;
    }

    public ProgressIndicator getProgressIndicator() {
        return myThreadIndicator.get();
    }

    public static void checkCanceled() throws ProcessCanceledException {
        if (ourNeedToCheckCancel) {
            ProgressManager.getInstance().doCheckCanceled();
            ourNeedToCheckCancel = false;
        }
    }

    protected abstract void doCheckCanceled() throws ProcessCanceledException;

    @NotNull
    public abstract NonCancelableSection startNonCancelableSection();
}

