/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.MissingResourceException;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    private final List<RegistryValueListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private Boolean myBooleanCachedValue;

    RegistryValue(Registry registry, String key) {
        this.myRegistry = registry;
        this.myKey = key;
    }

    public String asString() {
        String value = this.get(this.myKey, null, true);
        assert (value != null) : this.myKey;
        return value;
    }

    public boolean asBoolean() {
        if (this.myBooleanCachedValue == null) {
            this.myBooleanCachedValue = Boolean.valueOf(this.get(this.myKey, "false", true));
        }
        return this.myBooleanCachedValue;
    }

    public int asInteger() {
        if (this.myIntCachedValue == null) {
            this.myIntCachedValue = Integer.valueOf(this.get(this.myKey, "0", true));
        }
        return this.myIntCachedValue;
    }

    private String get(String key, String defaultValue, boolean isValue) {
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue, isValue);
            }
            if (this.isBoolean()) {
                this.myStringCachedValue = Boolean.valueOf(this.myStringCachedValue).toString();
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue, isValue);
    }

    private String _get(String key, String defaultValue, boolean mustExistInBundle) {
        String userValue = this.myRegistry.getUserProperties().get(key);
        if (userValue == null) {
            String systemProperty = System.getProperty(key);
            if (systemProperty != null) {
                return systemProperty;
            }
            String bundleValue = this.getBundleValue(key, mustExistInBundle);
            if (bundleValue != null) {
                return bundleValue;
            }
            return defaultValue;
        }
        return userValue;
    }

    private String getBundleValue(String key, boolean mustExist) {
        try {
            return Registry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    public boolean isBoolean() {
        return "true".equals(this.myStringCachedValue) || "false".equals(this.myStringCachedValue);
    }
}

