/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NonClasspathClassFinder
extends PsiElementFinder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.NonClasspathClassFinder");
    private final AtomicLong myLastStamp = new AtomicLong();
    protected final Project myProject;
    private volatile List<VirtualFile> myCache;
    private final PsiManager myManager;
    private final String[] myFileExtensions;

    public NonClasspathClassFinder(Project project, String ... fileExtensions) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance(this.myProject);
        this.myFileExtensions = ArrayUtil.append(fileExtensions, "class");
    }

    protected List<VirtualFile> getClassRoots(@Nullable GlobalSearchScope scope) {
        return this.getClassRoots();
    }

    protected List<VirtualFile> getClassRoots() {
        List<VirtualFile> cache = this.myCache;
        long stamp = this.myManager.getModificationTracker().getModificationCount();
        if (this.myLastStamp.get() != stamp) {
            cache = null;
        }
        if (cache != null && !cache.isEmpty()) {
            for (VirtualFile file : cache) {
                if (file.isValid()) continue;
                cache = null;
                break;
            }
        }
        if (cache == null) {
            this.myCache = cache = this.calcClassRoots();
            this.myLastStamp.set(stamp);
        }
        return cache;
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "findClass"));
        }
        List<VirtualFile> classRoots = this.getClassRoots(scope);
        if (classRoots.isEmpty()) {
            return null;
        }
        String relPath = qualifiedName.replace('.', '/');
        for (VirtualFile classRoot : classRoots) {
            PsiClass[] classes2;
            VirtualFile virtualFile;
            if (!scope.contains(classRoot) || (virtualFile = NonClasspathClassFinder.findFileByRelativePath(classRoot, relPath, this.myFileExtensions)) == null) continue;
            if (!virtualFile.isValid()) {
                LOG.error("Invalid child of valid parent: " + virtualFile.getPath() + "; " + classRoot.isValid() + " path=" + classRoot.getPath());
                return null;
            }
            PsiFile file = this.myManager.findFile(virtualFile);
            if (!(file instanceof PsiClassOwner) || (classes2 = ((PsiClassOwner)file).getClasses()).length != 1) continue;
            return classes2[0];
        }
        return null;
    }

    protected abstract List<VirtualFile> calcClassRoots();

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        List<VirtualFile> classRoots = this.getClassRoots(scope);
        if (classRoots.isEmpty()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList();
        for (VirtualFile classRoot : classRoots) {
            String pkgName;
            VirtualFile dir;
            if (!scope.contains(classRoot) || (dir = classRoot.findFileByRelativePath((pkgName = psiPackage.getQualifiedName()).replace('.', '/'))) == null || !dir.isDirectory()) continue;
            for (VirtualFile file : dir.getChildren()) {
                PsiFile psi;
                if (file.isDirectory() || !((psi = this.myManager.findFile(file)) instanceof PsiClassOwner)) continue;
                ContainerUtil.addAll(result2, ((PsiClassOwner)psi).getClasses());
            }
        }
        PsiClass[] psiClassArray = result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        List<VirtualFile> classRoots = this.getClassRoots(scope);
        if (classRoots.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
            }
            return set;
        }
        HashSet<String> result2 = new HashSet<String>();
        for (VirtualFile classRoot : classRoots) {
            String pkgName;
            VirtualFile dir;
            if (!scope.contains(classRoot) || (dir = classRoot.findFileByRelativePath((pkgName = psiPackage.getQualifiedName()).replace('.', '/'))) == null || !dir.isDirectory()) continue;
            for (VirtualFile file : dir.getChildren()) {
                if (file.isDirectory() || !ArrayUtil.contains(file.getExtension(), this.myFileExtensions)) continue;
                result2.add(file.getNameWithoutExtension());
            }
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        return hashSet;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "findPackage"));
        }
        List<VirtualFile> classRoots = this.getClassRoots();
        if (classRoots.isEmpty()) {
            return null;
        }
        for (VirtualFile classRoot : classRoots) {
            VirtualFile dir = classRoot.findFileByRelativePath(qualifiedName.replace('.', '/'));
            if (dir == null || !dir.isDirectory()) continue;
            return this.createPackage(qualifiedName);
        }
        return null;
    }

    private PsiPackageImpl createPackage(String qualifiedName) {
        return new PsiPackageImpl(this.myManager, qualifiedName);
    }

    @Override
    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        List<VirtualFile> classRoots = this.getClassRoots(scope);
        if (classRoots.isEmpty()) {
            return true;
        }
        String qname = psiPackage.getQualifiedName();
        final PsiManager psiManager = psiPackage.getManager();
        for (VirtualFile classRoot : classRoots) {
            PsiDirectory psiDirectory;
            VirtualFile dir;
            if (!scope.contains(classRoot) || (dir = classRoot.findFileByRelativePath(qname.replace('.', '/'))) == null || !dir.isDirectory() || (psiDirectory = ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory>(){

                @Override
                @Nullable
                public PsiDirectory compute() {
                    return dir.isValid() ? psiManager.findDirectory(dir) : null;
                }
            })) == null || consumer.process(psiDirectory)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        List<VirtualFile> classRoots = this.getClassRoots(scope);
        if (classRoots.isEmpty()) {
            PsiPackage[] psiPackageArray = super.getSubPackages(psiPackage, scope);
            if (psiPackageArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
            }
            return psiPackageArray;
        }
        ArrayList<PsiPackageImpl> result2 = new ArrayList<PsiPackageImpl>();
        for (VirtualFile classRoot : classRoots) {
            String pkgName;
            VirtualFile dir;
            if (!scope.contains(classRoot) || (dir = classRoot.findFileByRelativePath((pkgName = psiPackage.getQualifiedName()).replace('.', '/'))) == null || !dir.isDirectory()) continue;
            for (VirtualFile file : dir.getChildren()) {
                if (!file.isDirectory()) continue;
                result2.add(this.createPackage(pkgName + "." + file.getName()));
            }
        }
        PsiPackage[] psiPackageArray = result2.toArray(new PsiPackage[result2.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        PsiClass psiClass = this.findClass(qualifiedName, scope);
        if (psiClass == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = psiClass;
        }
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public static GlobalSearchScope addNonClasspathScope(Project project, GlobalSearchScope base) {
        GlobalSearchScope scope = base;
        for (PsiElementFinder finder : (PsiElementFinder[])Extensions.getExtensions(EP_NAME, (AreaInstance)project)) {
            if (!(finder instanceof NonClasspathClassFinder)) continue;
            scope = scope.uniteWith(NonClasspathDirectoriesScope.compose(((NonClasspathClassFinder)finder).getClassRoots()));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "addNonClasspathScope"));
        }
        return globalSearchScope;
    }

    public PsiManager getPsiManager() {
        return this.myManager;
    }

    @Nullable
    private static VirtualFile findFileByRelativePath(@NotNull VirtualFile root, @NotNull String relPath, @NotNull String[] extensions) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/NonClasspathClassFinder", "findFileByRelativePath"));
        }
        if (relPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relPath", "com/intellij/psi/NonClasspathClassFinder", "findFileByRelativePath"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/psi/NonClasspathClassFinder", "findFileByRelativePath"));
        }
        VirtualFile file = null;
        for (String extension : extensions) {
            file = root.findFileByRelativePath(relPath + '.' + extension);
            if (file != null) break;
        }
        return file;
    }
}

