/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiInlineDocTagImpl
extends CompositePsiElement
implements Constants,
PsiInlineDocTag {
    private static final TokenSet TAG_VALUE_BIT_SET = TokenSet.create(DOC_TAG_VALUE_ELEMENT, DOC_METHOD_OR_FIELD_REF);
    private static final TokenSet VALUE_NO_WHITESPACE_BIT_SET = TokenSet.orSet(TAG_VALUE_BIT_SET, TokenSet.create(JAVA_CODE_REFERENCE, DOC_TAG_VALUE_TOKEN, DOC_COMMENT_DATA, DOC_INLINE_TAG, DOC_REFERENCE_HOLDER, DOC_COMMENT_BAD_CHARACTER));
    private static final TokenSet VALUE_BIT_SET = TokenSet.orSet(TAG_VALUE_BIT_SET, TokenSet.create(JAVA_CODE_REFERENCE, DOC_TAG_VALUE_TOKEN, WHITE_SPACE, DOC_COMMENT_DATA, DOC_INLINE_TAG, DOC_REFERENCE_HOLDER, DOC_COMMENT_BAD_CHARACTER));

    public PsiInlineDocTagImpl() {
        super(DOC_INLINE_TAG);
    }

    @Override
    public PsiDocComment getContainingComment() {
        ASTNode scope = this.getTreeParent();
        while (scope.getElementType() != JavaDocElementType.DOC_COMMENT) {
            scope = scope.getTreeParent();
        }
        return (PsiDocComment)SourceTreeToPsiMap.treeElementToPsi(scope);
    }

    @Override
    public PsiElement getNameElement() {
        return this.findPsiChildByType(DOC_TAG_NAME);
    }

    @Override
    public PsiElement[] getDataElements() {
        return this.getChildrenAsPsiElements(VALUE_BIT_SET, PsiElement.ARRAY_FACTORY);
    }

    public PsiElement[] getDataElementsIgnoreWhitespaces() {
        return this.getChildrenAsPsiElements(VALUE_NO_WHITESPACE_BIT_SET, PsiElement.ARRAY_FACTORY);
    }

    @Override
    public PsiDocTagValue getValueElement() {
        return (PsiDocTagValue)this.findPsiChildByType(TAG_VALUE_BIT_SET);
    }

    @Override
    public String getName() {
        PsiElement nameElement = this.getNameElement();
        if (nameElement == null) {
            return "";
        }
        return nameElement.getText().substring(1);
    }

    @Override
    public int getChildRole(ASTNode child) {
        assert (child.getTreeParent() == this) : child.getTreeParent();
        IElementType i = child.getElementType();
        if (i == DOC_TAG_NAME) {
            return 105;
        }
        if (i == JavaDocElementType.DOC_COMMENT || i == DOC_INLINE_TAG) {
            return 106;
        }
        if (i == DOC_INLINE_TAG_START) {
            return 108;
        }
        if (i == DOC_INLINE_TAG_END) {
            return 109;
        }
        if (TAG_VALUE_BIT_SET.contains(i)) {
            return 242;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/javadoc/PsiInlineDocTagImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitInlineDocTag(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        PsiElement nameElement = this.getNameElement();
        return "PsiInlineDocTag:" + (nameElement != null ? nameElement.getText() : null);
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/javadoc/PsiInlineDocTagImpl", "setName"));
        }
        PsiImplUtil.setName(this.getNameElement(), name);
        return this;
    }
}

