/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuperMethodsSearch
extends ExtensibleQueryFactory<MethodSignatureBackedByPsiMethod, SearchParameters> {
    public static ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create("com.intellij.superMethodsSearch");
    public static final SuperMethodsSearch SUPER_METHODS_SEARCH_INSTANCE = new SuperMethodsSearch();

    private SuperMethodsSearch() {
    }

    @NotNull
    public static Query<MethodSignatureBackedByPsiMethod> search(@NotNull PsiMethod derivedMethod, @Nullable PsiClass psiClass, boolean checkBases, boolean allowStaticMethod) {
        if (derivedMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedMethod", "com/intellij/psi/search/searches/SuperMethodsSearch", "search"));
        }
        SearchParameters parameters = new SearchParameters(derivedMethod, psiClass, checkBases, allowStaticMethod);
        Query<MethodSignatureBackedByPsiMethod> query = SUPER_METHODS_SEARCH_INSTANCE.createUniqueResultsQuery(parameters, MethodSignatureUtil.METHOD_BASED_HASHING_STRATEGY);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/SuperMethodsSearch", "search"));
        }
        return query;
    }

    public static class SearchParameters {
        private final PsiMethod myMethod;
        @Nullable
        private final PsiClass myClass;
        private final boolean myCheckBases;
        private final boolean myAllowStaticMethod;

        public SearchParameters(@NotNull PsiMethod method, @Nullable PsiClass aClass, boolean checkBases, boolean allowStaticMethod) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/search/searches/SuperMethodsSearch$SearchParameters", "<init>"));
            }
            this.myCheckBases = checkBases;
            this.myClass = aClass;
            this.myMethod = method;
            this.myAllowStaticMethod = allowStaticMethod;
        }

        public final boolean isCheckBases() {
            return this.myCheckBases;
        }

        @NotNull
        public final PsiMethod getMethod() {
            PsiMethod psiMethod = this.myMethod;
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/SuperMethodsSearch$SearchParameters", "getMethod"));
            }
            return psiMethod;
        }

        @Nullable
        public final PsiClass getPsiClass() {
            return this.myClass;
        }

        public final boolean isAllowStaticMethod() {
            return this.myAllowStaticMethod;
        }
    }
}

