/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.ConstructorAccessor;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");
    private static final Method acquireConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "acquireConstructorAccessor", new Class[0]);
    private static final Method getConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "getConstructorAccessor", new Class[0]);

    private ReflectionUtil() {
    }

    @NotNull
    public static Field findField(@NotNull Class clazz, final @Nullable Class type, final @NotNull String name) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "findField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "findField"));
        }
        Field result2 = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name.equals(field.getName()) && (type == null || field.getType().equals(type));
            }
        });
        if (result2 != null) {
            Field field = result2;
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "findField"));
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, final @Nullable(value="null means any type") Class<?> fieldType, final @NotNull String fieldName) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        Field result2 = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType()));
            }
        });
        if (result2 != null) {
            Field field = result2;
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "findAssignableField"));
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    private static Field processFields(@NotNull Class clazz, @NotNull Condition<Field> checker) {
        Class<?>[] interfaces;
        Field result2;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "processFields"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/intellij/util/ReflectionUtil", "processFields"));
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!checker.value(field)) continue;
            field.setAccessible(true);
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (result2 = ReflectionUtil.processFields(superClass, checker)) != null) {
            return result2;
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            Field result3 = ReflectionUtil.processFields(each, checker);
            if (result3 == null) continue;
            return result3;
        }
        return null;
    }

    public static void resetField(@NotNull Class clazz, @Nullable(value="null means of any type") Class type, @NotNull String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(@Nullable Object object2, @NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type.isPrimitive()) {
                if (Boolean.TYPE.equals(type)) {
                    field.set(object2, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type)) {
                    field.set(object2, 0);
                } else if (Double.TYPE.equals(type)) {
                    field.set(object2, 0.0);
                } else if (Float.TYPE.equals(type)) {
                    field.set(object2, Float.valueOf(0.0f));
                }
            } else {
                field.set(object2, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    @Nullable
    public static Method findMethod(@NotNull Collection<Method> methods, @NonNls @NotNull String name, Class ... parameters) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        for (Method method : methods) {
            if (!name.equals(method.getName()) || !Arrays.equals(parameters, method.getParameterTypes())) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NotNull Class aClass, @NonNls @NotNull String name, Class ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassPublicMethods(aClass, false), name, parameters);
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class aClass, @NonNls @NotNull String name, Class ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassDeclaredMethods(aClass, false), name, parameters);
    }

    @Nullable
    public static Field getDeclaredField(@NotNull Class aClass, final @NonNls @NotNull String name) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getDeclaredField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getDeclaredField"));
        }
        return ReflectionUtil.processFields(aClass, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name.equals(field.getName());
            }
        });
    }

    public static List<Method> getClassPublicMethods(@NotNull Class aClass, boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getClassPublicMethods"));
        }
        Method[] methods = aClass.getMethods();
        return includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class aClass, boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        Method[] methods = aClass.getDeclaredMethods();
        List<Method> list = includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        return list;
    }

    private static List<Method> filterRealMethods(Method[] methods) {
        ArrayList<Method> result2 = ContainerUtil.newArrayList();
        for (Method method : methods) {
            if (method.isSynthetic()) continue;
            result2.add(method);
        }
        return result2;
    }

    @Nullable
    public static Class getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String name, Class ... parameters) {
        if (instanceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceClass", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        Method method = ReflectionUtil.getMethod(instanceClass, name, parameters);
        return method == null ? null : method.getDeclaringClass();
    }

    public static <T> T getField(@NotNull Class objectClass, Object object2, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/util/ReflectionUtil", "getField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "getField"));
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            return (T)field.get(object2);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(@NotNull Class<T> aClass) {
        Constructor<T> constructor;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        try {
            Constructor<T> constructor2 = aClass.getConstructor(new Class[0]);
            constructor2.setAccessible(true);
            constructor = constructor2;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass, e);
        }
        if (constructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        return constructor;
    }

    @NotNull
    public static ConstructorAccessor getConstructorAccessor(@NotNull Constructor constructor) {
        ConstructorAccessor constructorAccessor;
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/util/ReflectionUtil", "getConstructorAccessor"));
        }
        constructor.setAccessible(true);
        try {
            acquireConstructorAccessorMethod.invoke((Object)constructor, new Object[0]);
            constructorAccessor = (ConstructorAccessor)getConstructorAccessorMethod.invoke((Object)constructor, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (constructorAccessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getConstructorAccessor"));
        }
        return constructorAccessor;
    }

    @NotNull
    public static <T> T createInstanceViaConstructorAccessor(@NotNull ConstructorAccessor constructorAccessor, Object ... arguments) {
        Object object2;
        if (constructorAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorAccessor", "com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        try {
            object2 = constructorAccessor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (object2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        return (T)object2;
    }

    @NotNull
    public static <T> T createInstanceViaConstructorAccessor(@NotNull ConstructorAccessor constructorAccessor) {
        Object object2;
        if (constructorAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorAccessor", "com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        try {
            object2 = constructorAccessor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (object2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        return (T)object2;
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass, Class ... parameterTypes) {
        Constructor<T> constructor;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "newInstance"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/intellij/util/ReflectionUtil", "newInstance"));
        }
        try {
            constructor = aClass.getDeclaredConstructor(parameterTypes);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException e) {
                T t = aClass.newInstance();
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "newInstance"));
                }
                return t;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        T t = constructor.newInstance(new Object[0]);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "newInstance"));
        }
        return t;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args) {
        T t;
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        try {
            t = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        return t;
    }

    @Nullable
    public static Class getGrandCallerClass() {
        int stackFrameCount = 3;
        Class callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(++stackFrameCount);
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(2);
        }
        return callerClass;
    }

    @Nullable
    public static Class findCallerClass(int framesToSkip) {
        try {
            Class[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/util/ReflectionUtil", "isAssignable"));
        }
        if (descendant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descendant", "com/intellij/util/ReflectionUtil", "isAssignable"));
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        public Class[] getStack() {
            return this.getClassContext();
        }
    }
}

