/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil
extends ContainerUtilRt {
    private static final int DEFAULT_CONCURRENCY_LEVEL = Math.min(16, Runtime.getRuntime().availableProcessors());
    private static final ConcurrentMapFactory V8_MAP_FACTORY = new ConcurrentMapFactory(){

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap() {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$13", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$13", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil$13", "createMap"));
            }
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$13", "createMap"));
            }
            return concurrentHashMap;
        }
    };
    private static final ConcurrentMapFactory PLATFORM_MAP_FACTORY = new ConcurrentMapFactory(){

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap() {
            ConcurrentMap<T, V> concurrentMap = this.createMap(16, 0.75f, DEFAULT_CONCURRENCY_LEVEL);
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$14", "createMap"));
            }
            return concurrentMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            java.util.concurrent.ConcurrentHashMap concurrentHashMap = new java.util.concurrent.ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$14", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil$14", "createMap"));
            }
            if (hashingStrategy != ContainerUtil.canonicalStrategy()) {
                throw new UnsupportedOperationException("Custom hashStrategy is not supported in java.util.concurrent.ConcurrentHashMap");
            }
            ConcurrentMap<T, V> concurrentMap = this.createMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$14", "createMap"));
            }
            return concurrentMap;
        }
    };
    private static final ConcurrentMapFactory CHM_FACTORY = SystemInfo.isOracleJvm || SystemInfo.isSunJvm || SystemInfo.isAppleJvm || ContainerUtil.isAtLeastJava7() ? V8_MAP_FACTORY : PLATFORM_MAP_FACTORY;

    @NotNull
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = ContainerUtilRt.newHashMap();
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        return hashMap;
    }

    @NotNull
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        TreeMap treeMap = ContainerUtilRt.newTreeMap();
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTreeMap"));
        }
        return treeMap;
    }

    @NotNull
    public static <K, V> THashMap<K, V> newTroveMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveMap"));
        }
        return tHashMap;
    }

    @NotNull
    public static <K, V> THashMap<K, V> newTroveMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ContainerUtil", "newTroveMap"));
        }
        THashMap tHashMap = new THashMap(strategy);
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveMap"));
        }
        return tHashMap;
    }

    @NotNull
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "canonicalStrategy"));
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "identityStrategy"));
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        ArrayList<E> arrayList = ContainerUtilRt.newArrayList(array);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = ContainerUtilRt.newArrayListWithCapacity(size);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayListWithCapacity"));
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        AbstractList abstractList = new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + this.size);
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return abstractList;
    }

    @NotNull
    public static <T> List<T> newSmartList(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newSmartList"));
        }
        SmartList<T> smartList = new SmartList<T>(elements);
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newSmartList"));
        }
        return smartList;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = ContainerUtilRt.newHashSet();
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(int initialCapacity) {
        HashSet hashSet = ContainerUtilRt.newHashSet(initialCapacity);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        HashSet<T> hashSet = ContainerUtilRt.newHashSet(elements);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(iterable);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean empty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        Set<Object> set = empty ? Collections.emptySet() : ContainerUtilRt.newHashSet(iterable);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashOrEmptySet"));
        }
        return set;
    }

    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        LinkedHashSet linkedHashSet = ContainerUtilRt.newLinkedHashSet();
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedHashSet"));
        }
        return linkedHashSet;
    }

    @NotNull
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet<T> tHashSet = new THashSet<T>(strategy);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet<T> tHashSet = ContainerUtil.newTroveSet(Arrays.asList(elements));
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    public static <T> THashSet<T> newTroveSet(@NotNull Collection<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet<T> tHashSet = new THashSet<T>(elements);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    public static <K> THashSet<K> newIdentityTroveSet() {
        THashSet tHashSet = new THashSet(ContainerUtil.identityStrategy());
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newIdentityTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        THashMap tHashMap = new THashMap(ContainerUtil.identityStrategy());
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newIdentityTroveMap"));
        }
        return tHashMap;
    }

    @NotNull
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        ConcurrentMap concurrentMap = CHM_FACTORY.createMap();
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newConcurrentMap"));
        }
        return concurrentMap;
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashStrategy) {
        if (hashStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashStrategy", "com/intellij/util/containers/ContainerUtil", "newConcurrentMap"));
        }
        return CHM_FACTORY.createMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return CHM_FACTORY.createMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    public static <E> List<E> reverse(final @NotNull List<E> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "reverse"));
        }
        if (elements.isEmpty()) {
            List list = ContainerUtilRt.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "reverse"));
            }
            return list;
        }
        AbstractList abstractList = new AbstractList<E>(){

            @Override
            public E get(int index) {
                return elements.get(elements.size() - 1 - index);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "reverse"));
        }
        return abstractList;
    }

    @NotNull
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "immutableSet"));
        }
        Set<E> set = Collections.unmodifiableSet(new THashSet<E>(Arrays.asList(elements)));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "immutableSet"));
        }
        return set;
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (appendix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appendix", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> iterator2) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        while (iterator2.hasNext()) {
            T o = iterator2.next();
            collection.add(o);
        }
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<T> iterator2) {
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "collect"));
        }
        if (!iterator2.hasNext()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "collect"));
            }
            return list;
        }
        ArrayList list = new ArrayList();
        ContainerUtil.addAll(list, iterator2);
        ArrayList arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "collect"));
        }
        return arrayList;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<T> processor) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/containers/ContainerUtil", "process"));
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterable<V> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<V> iterator2, @NotNull Condition<T> condition) {
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        while (iterator2.hasNext()) {
            V value = iterator2.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<? extends V> aClass, @NotNull Function<T, V> mapper) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        V[] VArray = ContainerUtil.map2Array(Arrays.asList(array), aClass, mapper);
        if (VArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        return VArray;
    }

    @NotNull
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<? extends V> aClass, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        List<V> list = ContainerUtil.map2List(collection, mapper);
        Object[] array = (Object[])Array.newInstance(aClass, list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        return objectArray;
    }

    @NotNull
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull V[] to, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        V[] VArray = ContainerUtil.map2List(collection, mapper).toArray(to);
        if (VArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        return VArray;
    }

    @NotNull
    public static <T> List<T> filter(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        return list;
    }

    @NotNull
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        return smartList;
    }

    @NotNull
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        return list;
    }

    @NotNull
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (collection.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAll"));
            }
            return list;
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        return smartList;
    }

    @NotNull
    public static <T> T[] findAllAsArray(@NotNull T[] collection, @NotNull Condition<? super T> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceOf", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        List<Object> list = ContainerUtil.findAll(collection, instanceOf);
        Object[] array = (Object[])Array.newInstance(collection.getClass().getComponentType(), list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        return objectArray;
    }

    public static <E> void swapElements(@NotNull List<E> list, int index1, int index2) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "swapElements"));
        }
        E e1 = list.get(index1);
        E e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        for (A element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        return c;
    }

    @NotNull
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list1", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list2", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < size1) {
                    return list1.get(index);
                }
                return list2.get(index - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return abstractList;
    }

    @NotNull
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterables", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i = 0; i < iterables.length; ++i) {
                    Iterable iterable = iterables[i];
                    iterators[i] = iterable.iterator();
                }
                Iterator i = ContainerUtil.concatIterators(iterators);
                return i;
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return iterable;
    }

    @NotNull
    public static <T> Iterator<T> concatIterators(Iterator<T> ... iterators) {
        if (iterators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterators", "com/intellij/util/containers/ContainerUtil", "concatIterators"));
        }
        SequenceIterator<T> sequenceIterator = new SequenceIterator<T>(iterators);
        if (sequenceIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concatIterators"));
        }
        return sequenceIterator;
    }

    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection1", "com/intellij/util/containers/ContainerUtil", "intersects"));
        }
        if (collection2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection2", "com/intellij/util/containers/ContainerUtil", "intersects"));
        }
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static <T> T[] toArray(@Nullable Collection<T> c, @NotNull ArrayFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        T[] TArray = c != null ? c.toArray(factory.create(c.size())) : factory.create(0);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        return TArray;
    }

    @NotNull
    public static <T, V> List<V> map(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (iterable.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
            }
            return list;
        }
        ArrayList<V> result2 = new ArrayList<V>(iterable.size());
        for (T t : iterable) {
            result2.add(mapping.fun(t));
        }
        ArrayList<V> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        return arrayList;
    }

    @NotNull
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, @NotNull Function<T, V> mapping) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        List<V> list = ContainerUtil.mapNotNull(Arrays.asList(array), mapping);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        return list;
    }

    @NotNull
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (iterable.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
            }
            return list;
        }
        ArrayList<T> result2 = new ArrayList<T>(iterable.size());
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        return list;
    }

    @NotNull
    public static <T, V> List<V> map(@NotNull T[] array, @NotNull Function<T, V> mapping) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            result2.add(mapping.fun(t));
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        return list;
    }

    @NotNull
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List<T> list = element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createMaybeSingletonList"));
        }
        return list;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result2, T key, @NotNull Factory<V> factory) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "getOrCreate"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/containers/ContainerUtil", "getOrCreate"));
        }
        V value = result2.get(key);
        if (value == null) {
            value = factory.create();
            result2.put(key, value);
        }
        return value;
    }

    public static <T> boolean exists(@NotNull Iterable<T> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "exists"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "exists"));
        }
        return ContainerUtil.or(iterable, condition);
    }

    public static <T> boolean or(@NotNull Iterable<T> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "or"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "or"));
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> void quickSort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(@NotNull List<T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<T> x, Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/intellij/util/containers/ContainerUtil", "med3"));
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<E>> collections) {
        if (collections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collections", "com/intellij/util/containers/ContainerUtil", "flatten"));
        }
        ArrayList result2 = new ArrayList();
        for (Collection<E> list : collections) {
            result2.addAll(list);
        }
        List list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "flatten"));
        }
        return list;
    }

    public static <T> int indexOfIdentity(@NotNull List<T> list, T element) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "indexOfIdentity"));
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static <T> Stack<T> newStack() {
        Stack stack = ContainerUtilRt.newStack();
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newStack"));
        }
        return stack;
    }

    @NotNull
    public static <T> List<T> emptyList() {
        List list = ContainerUtilRt.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "emptyList"));
        }
        return list;
    }

    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        ConcurrentList<T> concurrentList = ContainerUtil.createConcurrentList();
        if (concurrentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createLockFreeCopyOnWriteList"));
        }
        return concurrentList;
    }

    @NotNull
    public static <T> ConcurrentList<T> createConcurrentList() {
        LockFreeCopyOnWriteArrayList lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList();
        if (lockFreeCopyOnWriteArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentList"));
        }
        return lockFreeCopyOnWriteArrayList;
    }

    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<T> result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "addIfNotNull"));
        }
        ContainerUtilRt.addIfNotNull(element, result2);
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result2, @Nullable T element) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "addIfNotNull"));
        }
        ContainerUtilRt.addIfNotNull(result2, element);
    }

    @NotNull
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        List<V> list = ContainerUtilRt.map2List(collection, mapper);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        return list;
    }

    @NotNull
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        T[] TArray = ContainerUtilRt.toArray(collection, array);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        if (sample == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sample", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        T[] TArray = ContainerUtilRt.toArray(c, sample);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] copyAndClear(@NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory, boolean clear) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "copyAndClear"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/containers/ContainerUtil", "copyAndClear"));
        }
        int size = collection.size();
        T[] a = factory.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "copyAndClear"));
        }
        return a;
    }

    private static boolean isAtLeastJava7() {
        return StringUtil.compareVersionNumbers(SystemInfo.JAVA_VERSION, "1.7") >= 0;
    }

    public static <T extends Comparable<T>> int compareLexicographically(List<T> o1, List<T> o2) {
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result2 = ((Comparable)o1.get(i)).compareTo(o2.get(i));
            if (result2 == 0) continue;
            return result2;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    private static interface ConcurrentMapFactory {
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap();

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int var1, float var2, int var3);

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int var1, float var2, int var3, @NotNull TObjectHashingStrategy<T> var4);
    }
}

