/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.lang.reflect.Array;
import org.jetbrains.annotations.NotNull;

public abstract class StripedLockHolder<T> {
    protected final T[] ourLocks;
    private int ourLockAllocationCounter;

    protected StripedLockHolder(@NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/StripedLockHolder", "<init>"));
        }
        this.ourLockAllocationCounter = 0;
        this.ourLocks = (Object[])Array.newInstance(aClass, 256);
        for (int i = 0; i < this.ourLocks.length; ++i) {
            this.ourLocks[i] = this.create();
        }
    }

    @NotNull
    protected abstract T create();

    public int allocateLockIndex() {
        this.ourLockAllocationCounter = (this.ourLockAllocationCounter + 1) % 256;
        return this.ourLockAllocationCounter;
    }
}

