/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Pair;
import com.intellij.reference.SoftReference;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.ArrayBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.DateBinding;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.PrimitiveValueBinding;
import com.intellij.util.xmlb.XmlSerializationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XmlSerializerImpl {
    private static java.lang.ref.SoftReference<Map<Pair<Type, Accessor>, Binding>> ourBindings;

    static Binding getBinding(Type type) {
        return XmlSerializerImpl.getTypeBinding(type, null);
    }

    static Binding getBinding(Accessor accessor) {
        return XmlSerializerImpl.getTypeBinding(accessor.getGenericType(), accessor);
    }

    static Binding getTypeBinding(Type type, @Nullable Accessor accessor) {
        if (type instanceof Class) {
            return XmlSerializerImpl._getClassBinding((Class)type, type, accessor);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            assert (rawType instanceof Class);
            return XmlSerializerImpl._getClassBinding((Class)rawType, type, accessor);
        }
        throw new UnsupportedOperationException("Can't get binding for: " + type);
    }

    private static synchronized Binding _getClassBinding(Class<?> aClass, Type originalType, @Nullable Accessor accessor) {
        Pair<Type, Accessor> p = Pair.create(originalType, accessor);
        Map<Pair<Type, Accessor>, Binding> map2 = XmlSerializerImpl.getBindingCacheMap();
        Binding binding = map2.get(p);
        if (binding == null) {
            binding = XmlSerializerImpl._getNonCachedClassBinding(aClass, accessor, originalType);
            map2.put(p, binding);
            binding.init();
        }
        return binding;
    }

    private static Map<Pair<Type, Accessor>, Binding> getBindingCacheMap() {
        Map<Pair<Type, Accessor>, Binding> map2 = SoftReference.dereference(ourBindings);
        if (map2 == null) {
            map2 = new ConcurrentHashMap<Pair<Type, Accessor>, Binding>();
            ourBindings = new java.lang.ref.SoftReference<Map<Pair<Type, Accessor>, Binding>>(map2);
        }
        return map2;
    }

    private static Binding _getNonCachedClassBinding(Class<?> aClass, @Nullable Accessor accessor, Type originalType) {
        if (aClass.isPrimitive()) {
            return new PrimitiveValueBinding(aClass);
        }
        if (aClass.isArray()) {
            return Element.class.isAssignableFrom(aClass.getComponentType()) ? new JDOMElementBinding(accessor) : new ArrayBinding(aClass, accessor);
        }
        if (Number.class.isAssignableFrom(aClass)) {
            return new PrimitiveValueBinding(aClass);
        }
        if (Boolean.class.isAssignableFrom(aClass)) {
            return new PrimitiveValueBinding(aClass);
        }
        if (String.class.isAssignableFrom(aClass)) {
            return new PrimitiveValueBinding(aClass);
        }
        if (Collection.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
            return new CollectionBinding((ParameterizedType)originalType, accessor);
        }
        if (Map.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
            return new MapBinding((ParameterizedType)originalType, accessor);
        }
        if (Element.class.isAssignableFrom(aClass)) {
            return new JDOMElementBinding(accessor);
        }
        if (Date.class.isAssignableFrom(aClass)) {
            return new DateBinding();
        }
        if (aClass.isEnum()) {
            return new PrimitiveValueBinding(aClass);
        }
        return new BeanBinding(aClass, accessor);
    }

    @Nullable
    static <T> T findAnnotation(Annotation[] annotations, Class<T> aClass) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!aClass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    @Nullable
    static <T> T convert(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)String.valueOf(value);
        }
        if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
            return (T)Integer.valueOf(String.valueOf(value));
        }
        if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
            return (T)Double.valueOf(String.valueOf(value));
        }
        if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return (T)Float.valueOf(String.valueOf(value));
        }
        if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
            return (T)Long.valueOf(String.valueOf(value));
        }
        if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
            return (T)Boolean.valueOf(String.valueOf(value));
        }
        if (type.isEnum()) {
            T[] enumConstants;
            for (T enumConstant : enumConstants = type.getEnumConstants()) {
                if (!enumConstant.toString().equals(value.toString())) continue;
                return enumConstant;
            }
            return null;
        }
        throw new XmlSerializationException("Can't covert " + value.getClass() + " into " + type);
    }

    public static boolean isIgnoredNode(Object child) {
        Attribute attr;
        String namespaceURI;
        if (child instanceof Text && ((Text)child).getValue().trim().isEmpty()) {
            return true;
        }
        if (child instanceof Comment) {
            return true;
        }
        return child instanceof Attribute && (namespaceURI = (attr = (Attribute)child).getNamespaceURI()) != null && !namespaceURI.isEmpty();
    }

    public static Content[] getNotIgnoredContent(Element m) {
        ArrayList<Content> result2 = new ArrayList<Content>();
        List<Content> content = m.getContent();
        for (Content o : content) {
            if (XmlSerializerImpl.isIgnoredNode(o)) continue;
            result2.add(o);
        }
        return result2.toArray(new Content[result2.size()]);
    }

    static <T> T newInstance(@NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl", "newInstance"));
        }
        try {
            return ReflectionUtil.newInstance(aClass, new Class[0]);
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

