/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;

public abstract class ArgumentGenerator {
    public int generate(@NotNull List<ResolvedValueArgument> valueArguments) {
        if (valueArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/codegen/ArgumentGenerator", "generate"));
        }
        int mask = 0;
        int n = valueArguments.size();
        for (int i = 0; i < n; ++i) {
            ResolvedValueArgument argument = valueArguments.get(i);
            if (argument instanceof ExpressionValueArgument) {
                this.generateExpression(i, (ExpressionValueArgument)argument);
                continue;
            }
            if (argument instanceof DefaultValueArgument) {
                mask |= 1 << i;
                this.generateDefault(i, (DefaultValueArgument)argument);
                continue;
            }
            if (argument instanceof VarargValueArgument) {
                this.generateVararg(i, (VarargValueArgument)argument);
                continue;
            }
            this.generateOther(i, argument);
        }
        return mask;
    }

    protected void generateExpression(int i, @NotNull ExpressionValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/codegen/ArgumentGenerator", "generateExpression"));
        }
        throw new UnsupportedOperationException("Unsupported expression value argument #" + i + ": " + argument);
    }

    protected void generateDefault(int i, @NotNull DefaultValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/codegen/ArgumentGenerator", "generateDefault"));
        }
        throw new UnsupportedOperationException("Unsupported default value argument #" + i + ": " + argument);
    }

    protected void generateVararg(int i, @NotNull VarargValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/codegen/ArgumentGenerator", "generateVararg"));
        }
        throw new UnsupportedOperationException("Unsupported vararg value argument #" + i + ": " + argument);
    }

    protected void generateOther(int i, @NotNull ResolvedValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/codegen/ArgumentGenerator", "generateOther"));
        }
        throw new UnsupportedOperationException("Unsupported value argument #" + i + ": " + argument);
    }
}

