/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class InlineAdapter
extends InstructionAdapter {
    private int nextLocalIndex = 0;
    private boolean isInlining = false;
    private final List<CatchBlock> blocks = new ArrayList<CatchBlock>();
    private int nextLocalIndexBeforeInline = -1;

    public InlineAdapter(MethodVisitor mv, int localsSize) {
        super(327680, mv);
        this.nextLocalIndex = localsSize;
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.updateIndex(var, 1);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.updateIndex(var, opcode == 57 || opcode == 55 || opcode == 24 || opcode == 22 ? 2 : 1);
    }

    private void updateIndex(int var, int varSize) {
        int newIndex = var + varSize;
        if (newIndex > this.nextLocalIndex) {
            this.nextLocalIndex = newIndex;
        }
    }

    public int getNextLocalIndex() {
        return this.nextLocalIndex;
    }

    public void setLambdaInlining(boolean isInlining) {
        this.isInlining = isInlining;
        if (isInlining) {
            this.nextLocalIndexBeforeInline = this.nextLocalIndex;
        } else {
            this.nextLocalIndex = this.nextLocalIndexBeforeInline;
        }
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (!this.isInlining) {
            this.blocks.add(new CatchBlock(start, end, handler, type));
        } else {
            super.visitTryCatchBlock(start, end, handler, type);
        }
    }

    @Override
    public void visitMaxs(int stack, int locals) {
        for (CatchBlock b : this.blocks) {
            super.visitTryCatchBlock(b.start, b.end, b.handler, b.type);
        }
        super.visitMaxs(stack, locals);
    }

    private static class CatchBlock {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final String type;

        public CatchBlock(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

