/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.optimization.transformer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public abstract class MethodTransformer {
    private final MethodTransformer delegate;

    protected MethodTransformer(MethodTransformer delegate) {
        this.delegate = delegate;
    }

    protected static <V extends Value> Frame<V>[] runAnalyzer(@NotNull Analyzer<V> analyzer, @NotNull String internalClassName, @NotNull MethodNode node) {
        if (analyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "org/jetbrains/jet/codegen/optimization/transformer/MethodTransformer", "runAnalyzer"));
        }
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/jet/codegen/optimization/transformer/MethodTransformer", "runAnalyzer"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/optimization/transformer/MethodTransformer", "runAnalyzer"));
        }
        try {
            return analyzer.analyze(internalClassName, node);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <V extends Value> Frame<V>[] analyze(@NotNull String internalClassName, @NotNull MethodNode node, @NotNull Interpreter<V> interpreter) {
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/jet/codegen/optimization/transformer/MethodTransformer", "analyze"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/optimization/transformer/MethodTransformer", "analyze"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "org/jetbrains/jet/codegen/optimization/transformer/MethodTransformer", "analyze"));
        }
        return MethodTransformer.runAnalyzer(new Analyzer<V>(interpreter), internalClassName, node);
    }

    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/jet/codegen/optimization/transformer/MethodTransformer", "transform"));
        }
        if (methodNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/jet/codegen/optimization/transformer/MethodTransformer", "transform"));
        }
        if (this.delegate != null) {
            this.delegate.transform(internalClassName, methodNode);
        }
    }
}

