/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.TypeDeserializer;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.impl.AbstractLazyTypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.StorageManager;

public class DeserializedTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor {
    private final ProtoBuf.TypeParameter proto;
    private final TypeDeserializer typeDeserializer;

    public DeserializedTypeParameterDescriptor(@NotNull StorageManager storageManager, @NotNull TypeDeserializer typeDeserializer, @NotNull ProtoBuf.TypeParameter proto, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull Variance variance, boolean isReified, int index) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (typeDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDeserializer", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variance", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        super(storageManager, containingDeclaration, name, variance, isReified, index, SourceElement.NO_SOURCE);
        this.proto = proto;
        this.typeDeserializer = typeDeserializer;
    }

    @Override
    @NotNull
    protected Set<JetType> resolveUpperBounds() {
        LinkedHashSet<JetType> result2 = new LinkedHashSet<JetType>(this.proto.getUpperBoundCount());
        for (ProtoBuf.Type upperBound : this.proto.getUpperBoundList()) {
            result2.add(this.typeDeserializer.type(upperBound));
        }
        if (result2.isEmpty()) {
            result2.add(KotlinBuiltIns.getInstance().getDefaultBound());
        }
        LinkedHashSet<JetType> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "resolveUpperBounds"));
        }
        return linkedHashSet;
    }

    public int getProtoId() {
        return this.proto.getId();
    }
}

