/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.evaluate;

import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.suppress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.evaluate.BinaryOperationKey;
import org.jetbrains.jet.lang.evaluate.CompileTimeType;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage$parseLong$1;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage$parseLong$2;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage-ConstantExpressionEvaluator-a64b065f$WhenMappings;
import org.jetbrains.jet.lang.evaluate.EvaluatorContext;
import org.jetbrains.jet.lang.evaluate.UnaryOperationKey;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.constants.BooleanValue;
import org.jetbrains.jet.lang.resolve.constants.ByteValue;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.ConstantsPackage-ConstantUtils-8bc97fe2;
import org.jetbrains.jet.lang.resolve.constants.DoubleValue;
import org.jetbrains.jet.lang.resolve.constants.FloatValue;
import org.jetbrains.jet.lang.resolve.constants.IntValue;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.jet.lang.resolve.constants.LongValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.ShortValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetSingleValueToken;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

@KotlinSyntheticClass(abiVersion=17, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class EvaluatePackage-ConstantExpressionEvaluator-a64b065f {
    @NotNull
    static final CompileTimeType<Byte> BYTE = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Short> SHORT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Integer> INT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Long> LONG = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Double> DOUBLE = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Float> FLOAT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Character> CHAR = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Boolean> BOOLEAN = new CompileTimeType();
    @NotNull
    static final CompileTimeType<String> STRING = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Object> ANY = new CompileTimeType();

    @Nullable
    public static final CompileTimeConstant<? extends Object> createCompileTimeConstantWithType(@JetValueParameter(name="$receiver") IntegerValueTypeConstant $receiver, @JetValueParameter(name="expectedType") @NotNull JetType expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "createCompileTimeConstantWithType"));
        }
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        Number number = $receiver.getValue(expectedType);
        Intrinsics.checkReturnedValueIsNotNull(number, "IntegerValueTypeConstant", "getValue");
        return EvaluatePackage-ConstantExpressionEvaluator-a64b065f.createCompileTimeConstant$default(number, new EvaluatorContext($receiver.canBeUsedInAnnotations(), true, false, 4), null, 4);
    }

    public static final boolean hasLongSuffix(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "hasLongSuffix"));
        }
        Intrinsics.checkParameterIsNotNull(text, "text");
        return !KotlinPackage.endsWith(text, 'l') ? KotlinPackage.endsWith(text, 'L') : true;
    }

    @Nullable
    public static final Long parseLong(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "parseLong"));
        }
        Intrinsics.checkParameterIsNotNull(text, "text");
        try {
            EvaluatePackage$parseLong$1 evaluatePackage$parseLong$1 = new EvaluatePackage$parseLong$1(text);
            EvaluatePackage$parseLong$2 evaluatePackage$parseLong$2 = new EvaluatePackage$parseLong$2(evaluatePackage$parseLong$1);
            return (!KotlinPackage.startsWith(text, "0x") ? KotlinPackage.startsWith(text, "0X") : true) ? evaluatePackage$parseLong$2.invoke(KotlinPackage.substring(text, 2), 16) : ((!KotlinPackage.startsWith(text, "0b") ? KotlinPackage.startsWith(text, "0B") : true) ? evaluatePackage$parseLong$2.invoke(KotlinPackage.substring(text, 2), 2) : evaluatePackage$parseLong$2.invoke(text, 10));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Object parseFloatingLiteral(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "parseFloatingLiteral"));
        }
        Intrinsics.checkParameterIsNotNull(text, "text");
        if (KotlinPackage.endsWith(KotlinPackage.toLowerCase(text), 'f')) {
            return EvaluatePackage-ConstantExpressionEvaluator-a64b065f.parseFloat(text);
        }
        return EvaluatePackage-ConstantExpressionEvaluator-a64b065f.parseDouble(text);
    }

    @Nullable
    public static final Double parseDouble(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "parseDouble"));
        }
        Intrinsics.checkParameterIsNotNull(text, "text");
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Float parseFloat(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "parseFloat"));
        }
        Intrinsics.checkParameterIsNotNull(text, "text");
        try {
            return Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final boolean parseBoolean(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "parseBoolean"));
        }
        Intrinsics.checkParameterIsNotNull(text, "text");
        if ("true".equals(text)) {
            return true;
        }
        if ("false".equals(text)) {
            return false;
        }
        throw (Throwable)new IllegalStateException("Must not happen. A boolean literal has text: " + text);
    }

    @Nullable
    public static final CompileTimeConstant<? extends Object> createCompileTimeConstantForEquals(@JetValueParameter(name="result", type="?") @Nullable Object result2, @JetValueParameter(name="operationReference") @NotNull JetExpression operationReference, @JetValueParameter(name="c") @NotNull EvaluatorContext c) {
        if (operationReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationReference", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "createCompileTimeConstantForEquals"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "createCompileTimeConstantForEquals"));
        }
        Intrinsics.checkParameterIsNotNull(operationReference, "operationReference");
        Intrinsics.checkParameterIsNotNull(c, "c");
        if (result2 instanceof Boolean) {
            BooleanValue booleanValue;
            IElementType operationToken;
            KotlinPackage.assert(operationReference instanceof JetSimpleNameExpression, "This method should be called only for equals operations");
            JetExpression jetExpression = operationReference;
            if (jetExpression == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.psi.JetExpression cannot be cast to org.jetbrains.jet.lang.psi.JetSimpleNameExpression");
            }
            IElementType iElementType = operationToken = ((JetSimpleNameExpression)jetExpression).getReferencedNameElementType();
            JetSingleValueToken jetSingleValueToken = JetTokens.EQEQ;
            Intrinsics.checkFieldIsNotNull(jetSingleValueToken, "JetTokens", "EQEQ");
            if (Intrinsics.areEqual(iElementType, jetSingleValueToken)) {
                booleanValue = new BooleanValue((Boolean)result2, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else {
                JetSingleValueToken jetSingleValueToken2 = JetTokens.EXCLEQ;
                Intrinsics.checkFieldIsNotNull(jetSingleValueToken2, "JetTokens", "EXCLEQ");
                if (Intrinsics.areEqual(iElementType, jetSingleValueToken2)) {
                    booleanValue = new BooleanValue((Boolean)result2 == false, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
                } else {
                    JetToken jetToken = JetTokens.IDENTIFIER;
                    Intrinsics.checkFieldIsNotNull(jetToken, "JetTokens", "IDENTIFIER");
                    if (Intrinsics.areEqual(iElementType, jetToken)) {
                        JetExpression jetExpression2 = operationReference;
                        if (jetExpression2 == null) {
                            throw new TypeCastException("org.jetbrains.jet.lang.psi.JetExpression cannot be cast to org.jetbrains.jet.lang.psi.JetSimpleNameExpression");
                        }
                        Name name = ((JetSimpleNameExpression)jetExpression2).getReferencedNameAsName();
                        Name name2 = OperatorConventions.EQUALS;
                        Intrinsics.checkFieldIsNotNull(name2, "OperatorConventions", "EQUALS");
                        KotlinPackage.assert(Intrinsics.areEqual(name, name2), "This method should be called only for equals operations");
                        return new BooleanValue((Boolean)result2, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
                    }
                    throw (Throwable)new IllegalStateException("Unknown equals operation token: " + operationToken + " " + ((JetSimpleNameExpression)operationReference).getText());
                }
            }
            return booleanValue;
        }
        return null;
    }

    @Nullable
    public static final CompileTimeConstant<? extends Object> createCompileTimeConstantForCompareTo(@JetValueParameter(name="result", type="?") @Nullable Object result2, @JetValueParameter(name="operationReference") @NotNull JetExpression operationReference, @JetValueParameter(name="c") @NotNull EvaluatorContext c) {
        if (operationReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationReference", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "createCompileTimeConstantForCompareTo"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "createCompileTimeConstantForCompareTo"));
        }
        Intrinsics.checkParameterIsNotNull(operationReference, "operationReference");
        Intrinsics.checkParameterIsNotNull(c, "c");
        if (result2 instanceof Integer) {
            BooleanValue booleanValue;
            IElementType operationToken;
            KotlinPackage.assert(operationReference instanceof JetSimpleNameExpression, "This method should be called only for compareTo operations");
            JetExpression jetExpression = operationReference;
            if (jetExpression == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.psi.JetExpression cannot be cast to org.jetbrains.jet.lang.psi.JetSimpleNameExpression");
            }
            IElementType iElementType = operationToken = ((JetSimpleNameExpression)jetExpression).getReferencedNameElementType();
            JetSingleValueToken jetSingleValueToken = JetTokens.LT;
            Intrinsics.checkFieldIsNotNull(jetSingleValueToken, "JetTokens", "LT");
            if (Intrinsics.areEqual(iElementType, jetSingleValueToken)) {
                booleanValue = new BooleanValue(((Number)result2).intValue() < 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else {
                JetSingleValueToken jetSingleValueToken2 = JetTokens.LTEQ;
                Intrinsics.checkFieldIsNotNull(jetSingleValueToken2, "JetTokens", "LTEQ");
                if (Intrinsics.areEqual(iElementType, jetSingleValueToken2)) {
                    booleanValue = new BooleanValue(((Number)result2).intValue() <= 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
                } else {
                    JetSingleValueToken jetSingleValueToken3 = JetTokens.GT;
                    Intrinsics.checkFieldIsNotNull(jetSingleValueToken3, "JetTokens", "GT");
                    if (Intrinsics.areEqual(iElementType, jetSingleValueToken3)) {
                        booleanValue = new BooleanValue(((Number)result2).intValue() > 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
                    } else {
                        JetSingleValueToken jetSingleValueToken4 = JetTokens.GTEQ;
                        Intrinsics.checkFieldIsNotNull(jetSingleValueToken4, "JetTokens", "GTEQ");
                        if (Intrinsics.areEqual(iElementType, jetSingleValueToken4)) {
                            booleanValue = new BooleanValue(((Number)result2).intValue() >= 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
                        } else {
                            JetToken jetToken = JetTokens.IDENTIFIER;
                            Intrinsics.checkFieldIsNotNull(jetToken, "JetTokens", "IDENTIFIER");
                            if (Intrinsics.areEqual(iElementType, jetToken)) {
                                JetExpression jetExpression2 = operationReference;
                                if (jetExpression2 == null) {
                                    throw new TypeCastException("org.jetbrains.jet.lang.psi.JetExpression cannot be cast to org.jetbrains.jet.lang.psi.JetSimpleNameExpression");
                                }
                                Name name = ((JetSimpleNameExpression)jetExpression2).getReferencedNameAsName();
                                Name name2 = OperatorConventions.COMPARE_TO;
                                Intrinsics.checkFieldIsNotNull(name2, "OperatorConventions", "COMPARE_TO");
                                KotlinPackage.assert(Intrinsics.areEqual(name, name2), "This method should be called only for compareTo operations");
                                return new IntValue(((Number)result2).intValue(), c.getCanBeUsedInAnnotation(), c.getIsPure(), c.getUsesVariableAsConstant());
                            }
                            throw (Throwable)new IllegalStateException("Unknown compareTo operation token: " + operationToken);
                        }
                    }
                }
            }
            return booleanValue;
        }
        return null;
    }

    @Nullable
    public static final StringValue createStringConstant(@JetValueParameter(name="value", type="?") @Nullable CompileTimeConstant<? extends Object> value) {
        StringValue stringValue;
        CompileTimeConstant<? extends Object> compileTimeConstant = value;
        if (compileTimeConstant instanceof IntegerValueTypeConstant) {
            IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)value;
            JetType jetType = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkFieldIsNotNull(jetType, "TypeUtils", "NO_EXPECTED_TYPE");
            Number number = integerValueTypeConstant.getValue(jetType);
            Intrinsics.checkReturnedValueIsNotNull(number, "IntegerValueTypeConstant", "getValue");
            stringValue = new StringValue(number.toString(), ((IntegerValueTypeConstant)value).canBeUsedInAnnotations(), ((IntegerValueTypeConstant)value).usesVariableAsConstant());
        } else {
            stringValue = compileTimeConstant instanceof StringValue ? (StringValue)value : (compileTimeConstant instanceof IntValue || compileTimeConstant instanceof ByteValue || compileTimeConstant instanceof ShortValue || compileTimeConstant instanceof LongValue || compileTimeConstant instanceof CharValue || compileTimeConstant instanceof DoubleValue || compileTimeConstant instanceof FloatValue || compileTimeConstant instanceof BooleanValue || compileTimeConstant instanceof NullValue ? new StringValue(String.valueOf(value.getValue()), value.canBeUsedInAnnotations(), value.usesVariableAsConstant()) : (StringValue)null);
        }
        return stringValue;
    }

    @Nullable
    public static final CompileTimeConstant<? extends Object> createCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value, @JetValueParameter(name="c") @NotNull EvaluatorContext c, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "createCompileTimeConstant"));
        }
        Intrinsics.checkParameterIsNotNull(c, "c");
        return ConstantsPackage-ConstantUtils-8bc97fe2.createCompileTimeConstant(value, c.getCanBeUsedInAnnotation(), c.getIsPure(), c.getUsesVariableAsConstant(), expectedType);
    }

    public static CompileTimeConstant createCompileTimeConstant$default(Object object2, EvaluatorContext evaluatorContext, JetType jetType, int n) {
        if ((n & 4) != 0) {
            jetType = null;
        }
        return EvaluatePackage-ConstantExpressionEvaluator-a64b065f.createCompileTimeConstant(object2, evaluatorContext, jetType);
    }

    public static final boolean isIntegerType(@JetValueParameter(name="value", type="?") @Nullable Object value) {
        return !(!(!(value instanceof Byte) ? value instanceof Short : true) ? value instanceof Integer : true) ? value instanceof Long : true;
    }

    @Nullable
    public static final JetType getReceiverExpressionType(@JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall) {
        JetType jetType;
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getReceiverExpressionType"));
        }
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        ExplicitReceiverKind explicitReceiverKind = resolvedCall.getExplicitReceiverKind();
        Intrinsics.checkReturnedValueIsNotNull((Object)explicitReceiverKind, "ResolvedCall", "getExplicitReceiverKind");
        switch (EvaluatePackage-ConstantExpressionEvaluator-a64b065f$WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind.ordinal()]) {
            case 1: {
                ReceiverValue receiverValue = resolvedCall.getThisObject();
                Intrinsics.checkReturnedValueIsNotNull(receiverValue, "ResolvedCall", "getThisObject");
                JetType jetType2 = receiverValue.getType();
                jetType = jetType2;
                Intrinsics.checkReturnedValueIsNotNull(jetType2, "ReceiverValue", "getType");
                break;
            }
            case 2: {
                ReceiverValue receiverValue = resolvedCall.getReceiverArgument();
                Intrinsics.checkReturnedValueIsNotNull(receiverValue, "ResolvedCall", "getReceiverArgument");
                JetType jetType3 = receiverValue.getType();
                jetType = jetType3;
                Intrinsics.checkReturnedValueIsNotNull(jetType3, "ReceiverValue", "getType");
                break;
            }
            case 3: {
                jetType = null;
                break;
            }
            case 4: {
                jetType = null;
                break;
            }
            default: {
                jetType = null;
            }
        }
        return jetType;
    }

    @Nullable
    public static final CompileTimeType<? extends Object> getCompileTimeType(@JetValueParameter(name="c") @NotNull JetType c) {
        CompileTimeType<Object> compileTimeType;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getCompileTimeType"));
        }
        Intrinsics.checkParameterIsNotNull(c, "c");
        KotlinBuiltIns kotlinBuiltIns = KotlinBuiltIns.getInstance();
        Intrinsics.checkReturnedValueIsNotNull(kotlinBuiltIns, "KotlinBuiltIns", "getInstance");
        KotlinBuiltIns builtIns = kotlinBuiltIns;
        JetType jetType = TypeUtils.makeNotNullable(c);
        Intrinsics.checkReturnedValueIsNotNull(jetType, "TypeUtils", "makeNotNullable");
        JetType jetType2 = jetType;
        JetType jetType3 = builtIns.getIntType();
        Intrinsics.checkReturnedValueIsNotNull(jetType3, "KotlinBuiltIns", "getIntType");
        if (Intrinsics.areEqual(jetType2, jetType3)) {
            compileTimeType = INT;
        } else {
            JetType jetType4 = builtIns.getByteType();
            Intrinsics.checkReturnedValueIsNotNull(jetType4, "KotlinBuiltIns", "getByteType");
            if (Intrinsics.areEqual(jetType2, jetType4)) {
                compileTimeType = BYTE;
            } else {
                JetType jetType5 = builtIns.getShortType();
                Intrinsics.checkReturnedValueIsNotNull(jetType5, "KotlinBuiltIns", "getShortType");
                if (Intrinsics.areEqual(jetType2, jetType5)) {
                    compileTimeType = SHORT;
                } else {
                    JetType jetType6 = builtIns.getLongType();
                    Intrinsics.checkReturnedValueIsNotNull(jetType6, "KotlinBuiltIns", "getLongType");
                    if (Intrinsics.areEqual(jetType2, jetType6)) {
                        compileTimeType = LONG;
                    } else {
                        JetType jetType7 = builtIns.getDoubleType();
                        Intrinsics.checkReturnedValueIsNotNull(jetType7, "KotlinBuiltIns", "getDoubleType");
                        if (Intrinsics.areEqual(jetType2, jetType7)) {
                            compileTimeType = DOUBLE;
                        } else {
                            JetType jetType8 = builtIns.getFloatType();
                            Intrinsics.checkReturnedValueIsNotNull(jetType8, "KotlinBuiltIns", "getFloatType");
                            if (Intrinsics.areEqual(jetType2, jetType8)) {
                                compileTimeType = FLOAT;
                            } else {
                                JetType jetType9 = builtIns.getCharType();
                                Intrinsics.checkReturnedValueIsNotNull(jetType9, "KotlinBuiltIns", "getCharType");
                                if (Intrinsics.areEqual(jetType2, jetType9)) {
                                    compileTimeType = CHAR;
                                } else {
                                    JetType jetType10 = builtIns.getBooleanType();
                                    Intrinsics.checkReturnedValueIsNotNull(jetType10, "KotlinBuiltIns", "getBooleanType");
                                    if (Intrinsics.areEqual(jetType2, jetType10)) {
                                        compileTimeType = BOOLEAN;
                                    } else {
                                        JetType jetType11 = builtIns.getStringType();
                                        Intrinsics.checkReturnedValueIsNotNull(jetType11, "KotlinBuiltIns", "getStringType");
                                        if (Intrinsics.areEqual(jetType2, jetType11)) {
                                            compileTimeType = STRING;
                                        } else {
                                            JetType jetType12 = builtIns.getAnyType();
                                            Intrinsics.checkReturnedValueIsNotNull(jetType12, "KotlinBuiltIns", "getAnyType");
                                            compileTimeType = Intrinsics.areEqual(jetType2, jetType12) ? ANY : (CompileTimeType)null;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Byte> getBYTE() {
        CompileTimeType<Byte> compileTimeType = BYTE;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getBYTE"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Short> getSHORT() {
        CompileTimeType<Short> compileTimeType = SHORT;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getSHORT"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Integer> getINT() {
        CompileTimeType<Integer> compileTimeType = INT;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getINT"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Long> getLONG() {
        CompileTimeType<Long> compileTimeType = LONG;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getLONG"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Double> getDOUBLE() {
        CompileTimeType<Double> compileTimeType = DOUBLE;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getDOUBLE"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Float> getFLOAT() {
        CompileTimeType<Float> compileTimeType = FLOAT;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getFLOAT"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Character> getCHAR() {
        CompileTimeType<Character> compileTimeType = CHAR;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getCHAR"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Boolean> getBOOLEAN() {
        CompileTimeType<Boolean> compileTimeType = BOOLEAN;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getBOOLEAN"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<String> getSTRING() {
        CompileTimeType<String> compileTimeType = STRING;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getSTRING"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Object> getANY() {
        CompileTimeType<Object> compileTimeType = ANY;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "getANY"));
        }
        return compileTimeType;
    }

    @suppress(names={"UNCHECKED_CAST"})
    @NotNull
    public static final <A, B> Pair<BinaryOperationKey<A, B>, Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>> binaryOperation(@JetValueParameter(name="a") @NotNull CompileTimeType<A> a, @JetValueParameter(name="b") @NotNull CompileTimeType<B> b, @JetValueParameter(name="functionName") @NotNull String functionName, @JetValueParameter(name="operation") @NotNull Function2<? super A, ? super B, ? extends Object> operation, @JetValueParameter(name="checker") @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "binaryOperation"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "binaryOperation"));
        }
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "binaryOperation"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "binaryOperation"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "binaryOperation"));
        }
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Intrinsics.checkParameterIsNotNull(checker, "checker");
        Pair<Function2<? super A, ? super B, ? extends Object>, Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> pair = new Pair<Function2<? super A, ? super B, ? extends Object>, Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>(operation, checker);
        if (pair == null) {
            throw new TypeCastException("kotlin.Pair<(A, B) -> kotlin.Any, (java.math.BigInteger, java.math.BigInteger) -> java.math.BigInteger> cannot be cast to kotlin.Pair<(kotlin.Any?, kotlin.Any?) -> kotlin.Any, (java.math.BigInteger, java.math.BigInteger) -> java.math.BigInteger>");
        }
        Pair<BinaryOperationKey<A, B>, Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>> pair2 = KotlinPackage.to(new BinaryOperationKey<A, B>(a, b, functionName), pair);
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "binaryOperation"));
        }
        return pair2;
    }

    @suppress(names={"UNCHECKED_CAST"})
    @NotNull
    public static final <A> Pair<UnaryOperationKey<A>, Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>>> unaryOperation(@JetValueParameter(name="a") @NotNull CompileTimeType<A> a, @JetValueParameter(name="functionName") @NotNull String functionName, @JetValueParameter(name="operation") @NotNull Function1<? super A, ? extends Object> operation, @JetValueParameter(name="checker") @NotNull Function1<? super Long, ? extends Long> checker) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "unaryOperation"));
        }
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "unaryOperation"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "unaryOperation"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "unaryOperation"));
        }
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Intrinsics.checkParameterIsNotNull(checker, "checker");
        Pair<Function1<? super A, ? extends Object>, Function1<? super Long, ? extends Long>> pair = new Pair<Function1<? super A, ? extends Object>, Function1<? super Long, ? extends Long>>(operation, checker);
        if (pair == null) {
            throw new TypeCastException("kotlin.Pair<(A) -> kotlin.Any, (kotlin.Long) -> kotlin.Long> cannot be cast to kotlin.Pair<(kotlin.Any?) -> kotlin.Any, (kotlin.Long) -> kotlin.Long>");
        }
        Pair<UnaryOperationKey<A>, Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>>> pair2 = KotlinPackage.to(new UnaryOperationKey<A>(a, functionName), pair);
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-a64b065f", "unaryOperation"));
        }
        return pair2;
    }
}

