/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ScriptDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.data.DataPackage;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;

public class ScriptBodyResolver {
    @NotNull
    private ExpressionTypingServices expressionTypingServices;

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    public void resolveScriptBodies(@NotNull BodiesResolveContext c, @NotNull BindingTrace trace) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "resolveScriptBodies"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "resolveScriptBodies"));
        }
        for (Map.Entry<JetScript, ScriptDescriptor> e : c.getScripts().entrySet()) {
            JetScript declaration = e.getKey();
            ScriptDescriptor descriptor = e.getValue();
            if (c.getTopDownAnalysisParameters().isLazyTopDownAnalysis()) {
                ForceResolveUtil.forceResolveAllContents(descriptor);
                continue;
            }
            ScriptDescriptorImpl descriptorImpl = (ScriptDescriptorImpl)descriptor;
            descriptorImpl.getScopeForBodyResolution().changeLockLevel(WritableScope.LockLevel.READING);
            JetType returnType = this.resolveScriptReturnType(declaration, descriptor, trace);
            ArrayList<PropertyDescriptorImpl> properties = new ArrayList<PropertyDescriptorImpl>();
            ArrayList<SimpleFunctionDescriptor> functions2 = new ArrayList<SimpleFunctionDescriptor>();
            BindingContext bindingContext = trace.getBindingContext();
            for (JetDeclaration jetDeclaration : declaration.getDeclarations()) {
                if (jetDeclaration instanceof JetProperty) {
                    if (!DataPackage.shouldBeScriptClassMember(jetDeclaration)) continue;
                    PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)bindingContext.get(BindingContext.VARIABLE, jetDeclaration);
                    properties.add(propertyDescriptor);
                    continue;
                }
                if (!(jetDeclaration instanceof JetNamedFunction) || !DataPackage.shouldBeScriptClassMember(jetDeclaration)) continue;
                SimpleFunctionDescriptor function = bindingContext.get(BindingContext.FUNCTION, jetDeclaration);
                assert (function != null);
                functions2.add(function.copy(descriptor.getClassDescriptor(), function.getModality(), function.getVisibility(), CallableMemberDescriptor.Kind.DECLARATION, false));
            }
            descriptorImpl.initialize(returnType, properties, functions2);
        }
    }

    @NotNull
    public JetType resolveScriptReturnType(@NotNull JetScript script, @NotNull ScriptDescriptor scriptDescriptor, @NotNull BindingTrace trace) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        ExpressionTypingContext context = ExpressionTypingContext.newContext(this.expressionTypingServices, trace, scriptDescriptor.getScopeForBodyResolution(), DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE);
        JetType returnType = this.expressionTypingServices.getBlockReturnedType(script.getBlockExpression(), CoercionStrategy.NO_COERCION, context).getType();
        if (returnType == null) {
            returnType = ErrorUtils.createErrorType("getBlockReturnedType returned null");
        }
        JetType jetType = returnType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        return jetType;
    }
}

