/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$1;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$2;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$3;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$4;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeConstraintSystem$1;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeConstraintSystem$2;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeConstraintSystem$3;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$updateRecordedTypeForArgument$1;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.CandidateResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage-callUtil-bbaa9fe2;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMapping;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMatch;
import org.jetbrains.jet.lang.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

@KotlinClass(abiVersion=17, data={"\u0003\u0010)i1)\u00197m\u0007>l\u0007\u000f\\3uKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7OC\u0002kKRTA\u0001\\1oO*9!/Z:pYZ,'\"B2bY2\u001c(bA!os*11n\u001c;mS:Ta\u0001P5oSRt$\u0002F1sOVlWM\u001c;UsB,'+Z:pYZ,'O\u0003\u000bBe\u001e,X.\u001a8u)f\u0004XMU3t_24XM\u001d\u0006\u0012G\u0006tG-\u001b3bi\u0016\u0014Vm]8mm\u0016\u0014(\"E\"b]\u0012LG-\u0019;f%\u0016\u001cx\u000e\u001c<fe*9r-\u001a;Be\u001e,X.\u001a8u)f\u0004XMU3t_24XM\u001d\u0006\u0015O\u0016$8)\u00198eS\u0012\fG/\u001a*fg>dg/\u001a:\u000b\u0003\u0011S!cQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u0015U\u0019w.\u001c9mKR,\u0017\t\u001c7DC:$\u0017\u000eZ1uKNTqaY8oi\u0016DHO\u0003\u000eCCNL7mQ1mYJ+7o\u001c7vi&|gnQ8oi\u0016DHOC\u0004sKN,H\u000e^:\u000b;=3XM\u001d7pC\u0012\u0014Vm]8mkRLwN\u001c*fgVdGo]%na2TA!\u00168ji*\t2m\\7qY\u0016$X-\u0011:hk6,g\u000e^:\u000b\u0019\r|W\u000e\u001d7fi\u0016\u001c\u0015\r\u001c7\u000b\u000fQ\u0014\u0018mY5oO*yAK]1dS:<7\u000b\u001e:bi\u0016<\u0017PC\u0003uCN\\7OC\fd_6\u0004H.\u001a;f\u0007\u0006dGNR8s\u0003J<W/\\3oi*QQ\r\u001f9sKN\u001c\u0018n\u001c8\u000b\u001b)+G/\u0012=qe\u0016\u001c8/[8o\u0015\r\u00018/\u001b\u0006\u0014\u001bV$\u0018M\u00197f%\u0016\u001cx\u000e\u001c<fI\u000e\u000bG\u000e\u001c\u0006\u0006[>$W\r\u001c\u0006\u0019G>l\u0007\u000f\\3uK\u000e{gn\u001d;sC&tGoU=ti\u0016l'\u0002D3ya\u0016\u001cG/\u001a3UsB,'b\u0002&fiRK\b/\u001a\u0006\u0006if\u0004Xm\u001d\u0006\u0006iJ\f7-\u001a\u0006\r\u0005&tG-\u001b8h)J\f7-\u001a\u0006\u0014G>l\u0007\u000f\\3uK>sW-\u0011:hk6,g\u000e\u001e\u0006\u000em\u0006dW/Z!sOVlWM\u001c;\u000b\u001bY\u000bG.^3Be\u001e,X.\u001a8u\u0015\u0001\u001aw.\u001c9mKR,'+Z:pYZ,GmQ1mY\u0006sG-\u0011:hk6,g\u000e^:\u000b\u0019I,7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b%\u001d,GoQ1mY\u001a{'/\u0011:hk6,g\u000e\u001e\u0006\tCJ<W/\\3oi*q!-\u001b8eS:<7i\u001c8uKb$(B\u0004\"j]\u0012LgnZ\"p]R,\u0007\u0010\u001e\u0006\u0005\u0007\u0006dGN\u0003\u000biCNtUmY3tg\u0006\u0014\u0018pU1gK\u000e\u000bG\u000e\u001c\u0006\b\u0005>|G.Z1o\u0015u)\b\u000fZ1uKJ+7m\u001c:eK\u0012$\u0016\u0010]3G_J\f%oZ;nK:$(bC;qI\u0006$X\r\u001a+za\u0016TAB]3d_J$W\r\u001a+za\u0016T!#\u0019:hk6,g\u000e^#yaJ,7o]5p]*QS\u000f\u001d3bi\u0016\u0014Vm]8mkRLwN\\*uCR,8O\u0012:p[\u000e{gn\u001d;sC&tGoU=ti\u0016l\u0007U\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!!Qa\u0001C\u0004\u0011\u000fa\u0001!B\u0002\u0005\u0006!-A\u0002A\u0003\u0004\t\u000bAi\u0001\u0004\u0001\u0006\u0005\u0011\u0015\u00012B\u0003\u0003\t\u000bAi!\u0002\u0002\u0005\u0004!IQa\u0001C\u0007\u0011#a\u0001!\u0002\u0002\u0005\u0006!QQa\u0001C\b\u0011+a\u0001!\u0002\u0002\u0005\u0006!YQa\u0001C\t\u0011/a\u0001!B\u0002\u0005\b!aA\u0002A\u0003\u0003\t\u001fA)\"\u0002\u0002\u0005\u0012!]QA\u0001C\u0003\u0011;)1\u0001B\u0006\t\u001d1\u0001QA\u0001\u0003\f\u00119)!\u0001b\u0001\t\"\u0015\u0019A\u0011\u0004\u0005\u0011\u0019\u0001)!\u0001\"\u0007\t!\u0015\u0011AQ\u0001E\u0012\u000b\r!a\u0002C\t\r\u0001\u0015\u0011A1\u0001E\u0014\u000b\r!q\u0002C\n\r\u0001\u0015\u0019AA\u0001E\u0015\u0019\u0001)!\u0001\u0002\b\t#\u0015\u0011Aa\u0004\u0005\u0014\u000b\t!!\u0001#\u000b\u0006\u0007\u0011e\u0001B\u0006\u0007\u0001\u000b\t!I\u0002\u0003\f\u0006\u0007\u0011\u0011\u0001\"\u0007\u0007\u0001\u000b\r!I\u0002c\r\r\u0001\u0015\u0011A\u0011\u0004E\u001a\u000b\t!!\u0001C\r\u0006\u0007\u0011\u001d\u0001R\u0007\u0007\u0001\t\ra1!\u0007\u0002\u0006\u0003!!Qf\u0004\u0003a\ta)\u0011EA\u0003\u0002\u0011\u0013)6\u0001C\u0003\u0004\t\u0015I\u0011\u0001c\u0003\u000e\u0007\u00119\u0011\"\u0001E\u0006[=!\u0001\r\u0002\r\u0007C\t)\u0011\u0001C\u0003V\u0007!)1\u0001\u0002\u0004\n\u0003!1Qb\u0001C\b\u0013\u0005Aa!l\u0014\u0005\u0003E)A\u0001\u0001\u0005\t+\t)\u0011\u0001C\u0004\u0019\u0014u5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001\u0003\u0005Q\u0007\u0001i:\u0002\u0002\u0001\t\u001759Q!\u0001\u0005\n\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0001k!\u0001\"\u0005\u0015\t\u00012C)\u0004\u000f\u0011M\u0011\"\u0001\u0003\u0001\u001b\u0005A!\"D\u0001\t\u00165>C!A\t\u0006\t\u0001A\u0001\"\u0006\u0002\u0006\u0003!9\u0001\u0014DO\u0007\t\u0001A!\"\u0004\u0002\u0006\u0003!A\u0001k\u0001\u0001\u001e\u0018\u0011\u0001\u0001bC\u0007\b\u000b\u0005A\u0011\"\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0005\u0011EA\u0003\u0002\u0011'\t6a\u0002C\r\u0013\u0005!\u0001!D\u0001\t\u00155\t\u0001RC\u00177\t\u0001\tR\u0001\u0002\u0001\t\u0011U\u0011Q!\u0001\u0005\b15ij\u0001\u0002\u0001\t\u00155\u0011Q!\u0001\u0005\t!\u000e\u0001Qt\u0003\u0003\u0001\u0011-iq!B\u0001\t\u0013%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001UB\u0001;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0003\u0005:Q!\u0001\u0005\n\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011kA\u0005\u0005\u001b%\t\u0001RC\u0007\u0002\u0011)i\u0011\u0001#\u0006\u000e\u0003!aQv\t\u0003\u00021=ij\u0001\u0002\u0001\t 5\u0011Q!\u0001\u0005\u000e!\u000e\u0001QT\u0002\u0003\u0001\u0011)i!!B\u0001\t\u0011A\u001b\t!I\u0005\u0006\u0003!I\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001C\u0004\r\u00021\u0005\u0011kA\u0004\u0005\u001f%\t\u0001RC\u0007\u0002\u00117i\u0011\u0001\u0003\u0006.Z\u0011\t\u0011#\u0002\u0003\u0001\u0011!)\"!B\u0001\t\u000fU9Q!\u0001E\u000f\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0001DEO\u0007\t\u0001A)#\u0004\u0002\u0006\u0003!}\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001\u0002F\u0007\u0003\u000b\u0005A\u0001\u0003U\u0002\u0002C\t)\u0011\u0001c\u0005R\u0007%!!#C\u0001\u0005\u00015\t\u0001\u0012E\u0007\u0002\u0011Ei\u0011\u0001c\t.:\u0011\t\u0001$FO\u0007\t\u0001AY#\u0004\u0002\u0006\u0003!\u0011\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A\u0001\u0002UB\u0001C\t)\u0011\u0001c\u0005R\u0007\u001d!Q#C\u0001\u0005\u00015\t\u0001RE\u0007\u0002\u0011)i\u000b\u0019\u0001\u0003\u0002#\u0015!\u0001\u0001\u0003\u0005\u0016\u0005\u0015\t\u0001b\u0002M\u0017;3!\u0001\u0001C\f\u000e\u0011\u0015\t\u0001RD\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u00011\u0005\u0001k\u0001\u0001\u001e\u0018\u0011\u0001\u0001bC\u0007\b\u000b\u0005A\u0011\"\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0005QT\u0002\u0003\u0001\u0011)i!!B\u0001\t\u0011A\u001b\u0011!(\u0004\u0005\u0001!mQBA\u0003\u0002\u0011/\u000161A\u0011\u0003\u000b\u0005A\u0019\"U\u0002\f\t[I\u0011\u0001\u0002\u0001\u000e\u0003!\u0005R\"\u0001E\u000b\u001b\u0005A!\"D\u0001\t\u00195vB!\u0001M\u0018;\u001f!\u0001\u0001\u0003\r\u000e\u0007\u0015\t\u0001\"\u0004G\u0001!\u000e\u0001QT\u0002\u0003\u0001\u0011ci!!B\u0001\t'A\u001b\t!I\u0002\u0006\u0003!\u001dB\u0012A)\u0004\u000f\u0011=\u0012\"\u0001\u0005\u0015\u001b\u0005AY\"D\u0001\t*5fB!\u0001\r\u001b;\u001b!\u0001\u0001c\b\u000e\u0005\u0015\t\u0001\"\u0004)\u0004\u0001u5A\u0001\u0001\u0005\u0015\u001b\t)\u0011\u0001\u0003\tQ\u0007\u0003\t#!B\u0001\t+E\u001bq\u0001\u0002\u000e\n\u0003\u0011\u0005Q\"\u0001E\u000e\u001b\u0005A\u0019#l\u0019\u0005\u0003aYRt\u0002\u0003\u0001\u0011oi1!B\u0001\t 1\u0005\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002H\u0007\u0004\u000b\u0005Ay\u0002$\u0001Q\u0007\u0003ij\u0001\u0002\u0001\t:5\u0011Q!\u0001\u0005\u000e!\u000e\tQT\u0002\u0003\u0001\u0011Qi!!B\u0001\t!A\u001b\u0019!\t\u0002\u0006\u0003!M\u0011kA\u0006\u00057%\tA\u0001A\u0007\u0002\u0011Ei\u0011\u0001C\t\u000e\u0003!mQ\"\u0001E\u0012[3\"\u0011!E\u0003\u0005\u0001!AQCA\u0003\u0002\u0011\u001d)r!B\u0001\t\u001e%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001G\u000f\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A\u0001\u0002UB\u0001;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0003\u0005\u0012Q!\u0001E\n#\u000eIA!H\u0005\u0002\t\u0001i\u0011\u0001#\t\u000e\u0003!QQ\"\u0001\u0005\rky)Q\u0004Br\u00011\u0013ij\u0001\u0002\u0001\t\u000b5\u0011Q!\u0001E\u0005!\u000e\u0001QT\u0002\u0003\u0001\u0011\u0019i!!B\u0001\t\u000bA\u001b\t!\t\u0002\u0006\u0003!\u0019\u0011kA\u0004\u0005\n%\tA\u0001A\u0007\u0002\u0011\u0017i\u0011\u0001\u0003\u0004"})
public final class CallCompleter
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final CandidateResolver candidateResolver;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(CallCompleter.class);
    }

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@JetValueParameter(name="context") @NotNull BasicCallResolutionContext context, @JetValueParameter(name="results") @NotNull OverloadResolutionResultsImpl<D> results, @JetValueParameter(name="tracing") @NotNull TracingStrategy tracing) {
        boolean bl;
        Unit unit;
        ResolvedCall resolvedCall;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(results, "results");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall2 = results.getResultingCall();
            resolvedCall = resolvedCall2;
            Intrinsics.checkReturnedValueIsNotNull(resolvedCall2, "OverloadResolutionResultsImpl", "getResultingCall");
        } else {
            resolvedCall = null;
        }
        ResolvedCall resolvedCall3 = resolvedCall;
        Call call = ((CallResolutionContext)context).call;
        Intrinsics.checkFieldIsNotNull(call, "CallResolutionContext", "call");
        if (!CallResolverUtil.isInvokeCallOnVariable(call)) {
            BindingTrace bindingTrace = ((ResolutionContext)context).trace;
            Intrinsics.checkFieldIsNotNull(bindingTrace, "ResolutionContext", "trace");
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(bindingTrace, "Trace to complete a resulting call");
            Intrinsics.checkReturnedValueIsNotNull(temporaryBindingTrace, "TemporaryBindingTrace", "create");
            TemporaryBindingTrace temporaryTrace = temporaryBindingTrace;
            Object Context2 = context.replaceBindingTrace(temporaryTrace);
            Intrinsics.checkReturnedValueIsNotNull(Context2, "BasicCallResolutionContext", "replaceBindingTrace");
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall3, results, (BasicCallResolutionContext)Context2, tracing);
            this.completeAllCandidates(context, results);
            temporaryTrace.commit();
        }
        ResolvedCall resolvedCall4 = resolvedCall3;
        if (resolvedCall4 != null) {
            ResolvedCall resolvedCall5;
            ResolvedCall it = resolvedCall5 = resolvedCall4;
            CallResolverExtension callResolverExtension = ((ResolutionContext)context).callResolverExtension;
            Intrinsics.checkFieldIsNotNull(callResolverExtension, "ResolutionContext", "callResolverExtension");
            callResolverExtension.run(it, context);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall6 = results.getResultingCall();
            Intrinsics.checkReturnedValueIsNotNull(resolvedCall6, "OverloadResolutionResultsImpl", "getResultingCall");
            ResolutionStatus resolutionStatus = resolvedCall6.getStatus();
            Intrinsics.checkReturnedValueIsNotNull((Object)resolutionStatus, "MutableResolvedCall", "getStatus");
            bl = resolutionStatus.isSuccess();
        } else {
            bl = false;
        }
        if (bl) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results.changeStatusToSuccess();
            Intrinsics.checkReturnedValueIsNotNull(overloadResolutionResultsImpl, "OverloadResolutionResultsImpl", "changeStatusToSuccess");
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        return overloadResolutionResultsImpl;
    }

    private final <D extends CallableDescriptor> void completeAllCandidates(@JetValueParameter(name="context") BasicCallResolutionContext context, @JetValueParameter(name="results") OverloadResolutionResultsImpl<D> results) {
        Collection<ResolvedCall<D>> collection;
        if (((ResolutionContext)context).collectAllCandidates) {
            collection = results.getAllCandidates();
            if (collection == null) {
                Intrinsics.throwNpe();
            }
        } else {
            Collection<MutableResolvedCall<D>> collection2 = results.getResultingCalls();
            collection = collection2;
            Intrinsics.checkReturnedValueIsNotNull(collection2, "OverloadResolutionResultsImpl", "getResultingCalls");
        }
        if (collection == null) {
            throw new TypeCastException("kotlin.MutableCollection<out org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall<D>?> cannot be cast to kotlin.Collection<org.jetbrains.jet.lang.resolve.calls.model.MutableResolvedCall<D>>");
        }
        Collection<ResolvedCall<D>> candidates = collection;
        Iterable iterable = candidates;
        Iterable iterable2 = iterable;
        Collection collection32 = new ArrayList();
        Iterator iterator2 = iterable2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            MutableResolvedCall resolvedCall = (MutableResolvedCall)t;
            Object object2 = !resolvedCall.isCompleted() ? Boolean.valueOf(collection32.add(t)) : Unit.INSTANCE$;
        }
        iterable = (ArrayList)collection32;
        for (Collection collection32 : iterable) {
            TemporaryBindingTrace temporaryBindingTrace;
            MutableResolvedCall resolvedCall = (MutableResolvedCall)((Object)collection32);
            BindingTrace bindingTrace = ((ResolutionContext)context).trace;
            Intrinsics.checkFieldIsNotNull(bindingTrace, "ResolutionContext", "trace");
            Intrinsics.checkReturnedValueIsNotNull(TemporaryBindingTrace.create(bindingTrace, "Trace to complete a candidate that is not a resulting call"), "TemporaryBindingTrace", "create");
            Object Context2 = context.replaceBindingTrace(temporaryBindingTrace);
            Intrinsics.checkReturnedValueIsNotNull(Context2, "BasicCallResolutionContext", "replaceBindingTrace");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)Context2;
            TracingStrategy tracingStrategy = TracingStrategy.EMPTY;
            Intrinsics.checkFieldIsNotNull(tracingStrategy, "TracingStrategy", "EMPTY");
            CallCompleter.completeResolvedCallAndArguments$b$0(this, resolvedCall, results, basicCallResolutionContext, tracingStrategy);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(@JetValueParameter(name="resolvedCall", type="?") MutableResolvedCall<D> resolvedCall, @JetValueParameter(name="results") OverloadResolutionResultsImpl<D> results, @JetValueParameter(name="context") BasicCallResolutionContext context, @JetValueParameter(name="tracing") TracingStrategy tracing) {
        boolean bl = !(!(resolvedCall == null) ? resolvedCall.isCompleted() : true) ? resolvedCall.getConstraintSystem() == null : true;
        if (bl) {
            Unit unit;
            this.completeArguments(context, results);
            MutableResolvedCall<D> mutableResolvedCall = resolvedCall;
            if (mutableResolvedCall != null) {
                mutableResolvedCall.markCallAsCompleted();
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
            return;
        }
        JetType jetType = ((ResolutionContext)context).expectedType;
        Intrinsics.checkFieldIsNotNull(jetType, "ResolutionContext", "expectedType");
        BindingTrace bindingTrace = ((ResolutionContext)context).trace;
        Intrinsics.checkFieldIsNotNull(bindingTrace, "ResolutionContext", "trace");
        this.completeConstraintSystem(resolvedCall, jetType, bindingTrace);
        this.completeArguments(context, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall, context, tracing);
        resolvedCall.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(@JetValueParameter(name="$receiver") MutableResolvedCall<D> $receiver, @JetValueParameter(name="expectedType") JetType expectedType, @JetValueParameter(name="trace") BindingTrace trace) {
        CallCompleter$completeConstraintSystem$1 callCompleter$completeConstraintSystem$1 = new CallCompleter$completeConstraintSystem$1($receiver);
        Object d = $receiver.getCandidateDescriptor();
        Intrinsics.checkReturnedValueIsNotNull(d, "MutableResolvedCall", "getCandidateDescriptor");
        JetType returnType = d.getReturnType();
        if (returnType != null) {
            ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
            if (constraintSystem == null) {
                Intrinsics.throwNpe();
            }
            ConstraintPosition constraintPosition = ConstraintPosition.EXPECTED_TYPE_POSITION;
            Intrinsics.checkFieldIsNotNull(constraintPosition, "ConstraintPosition", "EXPECTED_TYPE_POSITION");
            constraintSystem.addSupertypeConstraint(expectedType, returnType, constraintPosition);
            JetType jetType = TypeUtils.UNIT_EXPECTED_TYPE;
            Intrinsics.checkFieldIsNotNull(jetType, "TypeUtils", "UNIT_EXPECTED_TYPE");
            if (expectedType == jetType) {
                callCompleter$completeConstraintSystem$1.invoke(new CallCompleter$completeConstraintSystem$2(returnType));
            }
        }
        WritableSlice<JetElement, ConstraintSystemCompleter> writableSlice = BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
        Intrinsics.checkFieldIsNotNull(writableSlice, "BindingContext", "CONSTRAINT_SYSTEM_COMPLETER");
        ReadOnlySlice readOnlySlice = writableSlice;
        Call call = $receiver.getCall();
        Intrinsics.checkReturnedValueIsNotNull(call, "MutableResolvedCall", "getCall");
        ConstraintSystemCompleter constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(readOnlySlice, call.getCalleeExpression());
        if (constraintSystemCompleter != null) {
            callCompleter$completeConstraintSystem$1.invoke(new CallCompleter$completeConstraintSystem$3($receiver, constraintSystemCompleter));
        }
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem? cannot be cast to org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl");
        }
        ((ConstraintSystemImpl)constraintSystem).processDeclaredBoundConstraints();
        ConstraintSystem constraintSystem2 = $receiver.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        TypeSubstitutor typeSubstitutor = constraintSystem2.getResultingSubstitutor();
        Intrinsics.checkReturnedValueIsNotNull(typeSubstitutor, "ConstraintSystem", "getResultingSubstitutor");
        $receiver.setResultingSubstitutor(typeSubstitutor);
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(@JetValueParameter(name="$receiver") MutableResolvedCall<D> $receiver, @JetValueParameter(name="context") BasicCallResolutionContext context, @JetValueParameter(name="tracing") TracingStrategy tracing) {
        JetType jetType;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed($receiver, context, tracing);
        Intrinsics.checkReturnedValueIsNotNull(callCandidateResolutionContext, "CallCandidateResolutionContext", "createForCallBeingAnalyzed");
        CallCandidateResolutionContext<D> contextWithResolvedCall = callCandidateResolutionContext;
        BindingTrace bindingTrace = ((ResolutionContext)context).trace;
        Intrinsics.checkFieldIsNotNull(bindingTrace, "ResolutionContext", "trace");
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(contextWithResolvedCall, bindingTrace, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        Intrinsics.checkReturnedValueIsNotNull(valueArgumentsCheckingResult, "CandidateResolver", "checkAllValueArguments");
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult2 = valueArgumentsCheckingResult;
        ResolutionStatus resolutionStatus = $receiver.getStatus();
        Intrinsics.checkReturnedValueIsNotNull((Object)resolutionStatus, "MutableResolvedCall", "getStatus");
        ResolutionStatus status = resolutionStatus;
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        ConstraintSystemStatus constraintSystemStatus = constraintSystem.getStatus();
        Intrinsics.checkReturnedValueIsNotNull(constraintSystemStatus, "ConstraintSystem", "getStatus");
        if (constraintSystemStatus.isSuccessful()) {
            if (!Intrinsics.areEqual((Object)status, (Object)ResolutionStatus.UNKNOWN_STATUS) ? Intrinsics.areEqual((Object)status, (Object)ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) : true) {
                $receiver.setStatusToSuccess();
            }
            return;
        }
        ReceiverValue receiverValue = $receiver.getReceiverArgument();
        Intrinsics.checkReturnedValueIsNotNull(receiverValue, "MutableResolvedCall", "getReceiverArgument");
        if (receiverValue.exists()) {
            ReceiverValue receiverValue2 = $receiver.getReceiverArgument();
            Intrinsics.checkReturnedValueIsNotNull(receiverValue2, "MutableResolvedCall", "getReceiverArgument");
            JetType jetType2 = receiverValue2.getType();
            jetType = jetType2;
            Intrinsics.checkReturnedValueIsNotNull(jetType2, "ReceiverValue", "getType");
        } else {
            jetType = null;
        }
        JetType receiverType = jetType;
        Object d = $receiver.getCandidateDescriptor();
        Intrinsics.checkReturnedValueIsNotNull(d, "MutableResolvedCall", "getCandidateDescriptor");
        ConstraintSystem constraintSystem2 = $receiver.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        List<JetType> list = valueArgumentsCheckingResult2.argumentTypes;
        Intrinsics.checkFieldIsNotNull(list, "ValueArgumentsCheckingResult", "argumentTypes");
        JetType jetType3 = ((ResolutionContext)context).expectedType;
        Intrinsics.checkFieldIsNotNull(jetType3, "ResolutionContext", "expectedType");
        InferenceErrorData inferenceErrorData = InferenceErrorData.create(d, constraintSystem2, list, receiverType, jetType3);
        Intrinsics.checkReturnedValueIsNotNull(inferenceErrorData, "InferenceErrorData", "create");
        InferenceErrorData errorData = inferenceErrorData;
        BindingTrace bindingTrace2 = ((ResolutionContext)context).trace;
        Intrinsics.checkFieldIsNotNull(bindingTrace2, "ResolutionContext", "trace");
        tracing.typeInferenceFailed(bindingTrace2, errorData);
        $receiver.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    private final <D extends CallableDescriptor> void completeArguments(@JetValueParameter(name="context") BasicCallResolutionContext context, @JetValueParameter(name="results") OverloadResolutionResultsImpl<D> results) {
        Function1 getDataFlowInfoForArgument;
        Function1 getArgumentMapping;
        CheckValueArgumentsMode checkValueArgumentsMode = ((CallResolutionContext)context).checkArguments;
        Intrinsics.checkFieldIsNotNull((Object)checkValueArgumentsMode, "CallResolutionContext", "checkArguments");
        if (Intrinsics.areEqual((Object)checkValueArgumentsMode, (Object)CheckValueArgumentsMode.DISABLED)) {
            return;
        }
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall = results.getResultingCall();
            Intrinsics.checkReturnedValueIsNotNull(resolvedCall, "OverloadResolutionResultsImpl", "getResultingCall");
            ResolvedCall resolvedCall2 = resolvedCall;
            getArgumentMapping = new CallCompleter$completeArguments$1((MutableResolvedCall)resolvedCall2);
            getDataFlowInfoForArgument = new CallCompleter$completeArguments$2((MutableResolvedCall)resolvedCall2);
        } else {
            getArgumentMapping = CallCompleter$completeArguments$3.INSTANCE$;
            getDataFlowInfoForArgument = new CallCompleter$completeArguments$4(context);
        }
        Call call = ((CallResolutionContext)context).call;
        Intrinsics.checkFieldIsNotNull(call, "CallResolutionContext", "call");
        List<? extends ValueArgument> list = call.getValueArguments();
        Intrinsics.checkReturnedValueIsNotNull(list, "Call", "getValueArguments");
        Iterator<? extends ValueArgument> iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            JetType jetType;
            ArgumentMapping argumentMapping;
            ArgumentMapping argumentMapping2;
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            if (valueArgument2 == null) {
                Intrinsics.throwNpe();
            }
            if ((argumentMapping2 = (argumentMapping = (ArgumentMapping)getArgumentMapping.invoke(valueArgument2))) instanceof ArgumentMatch) {
                JetType jetType2 = CandidateResolver.getEffectiveExpectedType(((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument);
                jetType = jetType2;
                Intrinsics.checkReturnedValueIsNotNull(jetType2, "CandidateResolver", "getEffectiveExpectedType");
            } else {
                JetType jetType3 = TypeUtils.NO_EXPECTED_TYPE;
                jetType = jetType3;
                Intrinsics.checkFieldIsNotNull(jetType3, "TypeUtils", "NO_EXPECTED_TYPE");
            }
            JetType expectedType = jetType;
            Object Context2 = context.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke(valueArgument));
            Intrinsics.checkReturnedValueIsNotNull(Context2, "BasicCallResolutionContext", "replaceDataFlowInfo");
            Object Context3 = ((BasicCallResolutionContext)Context2).replaceExpectedType(expectedType);
            Intrinsics.checkReturnedValueIsNotNull(Context3, "BasicCallResolutionContext", "replaceExpectedType");
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)Context3;
            this.completeOneArgument(valueArgument, newContext);
        }
    }

    private final void completeOneArgument(@JetValueParameter(name="valueArgument") ValueArgument valueArgument, @JetValueParameter(name="context") BasicCallResolutionContext context) {
        boolean bl;
        JetType recordedType;
        if (valueArgument.isExternal()) {
            return;
        }
        JetExpression expression = valueArgument.getArgumentExpression();
        if (expression == null) {
            return;
        }
        BindingTrace bindingTrace = ((ResolutionContext)context).trace;
        Intrinsics.checkFieldIsNotNull(bindingTrace, "ResolutionContext", "trace");
        WritableSlice<JetExpression, JetType> writableSlice = BindingContext.EXPRESSION_TYPE;
        Intrinsics.checkFieldIsNotNull(writableSlice, "BindingContext", "EXPRESSION_TYPE");
        JetType updatedType = recordedType = (JetType)bindingTrace.get(writableSlice, expression);
        OverloadResolutionResultsImpl<? extends CallableDescriptor> results = this.completeCallForArgument(expression, context);
        if (results != null ? results.isSingleResult() : false) {
            JetType jetType;
            ResolvedCall resolvedCall = results.getResultingCall();
            Intrinsics.checkReturnedValueIsNotNull(resolvedCall, "OverloadResolutionResultsImpl", "getResultingCall");
            ResolvedCall resolvedCall2 = resolvedCall;
            if (resolvedCall2.hasInferredReturnType()) {
                Object d = resolvedCall2.getResultingDescriptor();
                jetType = d != null ? d.getReturnType() : null;
            } else {
                jetType = updatedType = (JetType)null;
            }
        }
        if (recordedType != null) {
            TypeConstructor typeConstructor = recordedType.getConstructor();
            Intrinsics.checkReturnedValueIsNotNull(typeConstructor, "JetType", "getConstructor");
            bl = !typeConstructor.isDenotable();
        } else {
            bl = false;
        }
        if (bl) {
            BasicCallResolutionContext basicCallResolutionContext = context;
            if (basicCallResolutionContext == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext cannot be cast to org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<out org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<Context>?>");
            }
            updatedType = ArgumentTypeResolver.updateResultArgumentTypeIfNotDenotable(basicCallResolutionContext, expression);
        }
        BindingTrace bindingTrace2 = ((ResolutionContext)context).trace;
        Intrinsics.checkFieldIsNotNull(bindingTrace2, "ResolutionContext", "trace");
        this.updateRecordedTypeForArgument(updatedType, recordedType, expression, bindingTrace2);
        if (ArgumentTypeResolver.isFunctionLiteralArgument(expression)) {
            JetFunctionLiteralExpression jetFunctionLiteralExpression = ArgumentTypeResolver.getFunctionLiteralArgument(expression);
            Intrinsics.checkReturnedValueIsNotNull(jetFunctionLiteralExpression, "ArgumentTypeResolver", "getFunctionLiteralArgument");
            BasicCallResolutionContext basicCallResolutionContext = context;
            if (basicCallResolutionContext == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext cannot be cast to org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext<out org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext<Context>?>");
            }
            Intrinsics.checkReturnedValueIsNotNull(this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression, jetFunctionLiteralExpression, basicCallResolutionContext, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS), "ArgumentTypeResolver", "getFunctionLiteralTypeInfo");
        }
        BasicCallResolutionContext basicCallResolutionContext = context;
        if (basicCallResolutionContext == null) {
            throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext cannot be cast to org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<out org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<Context>?>");
        }
        DataFlowUtils.checkType(updatedType, expression, (ResolutionContext)basicCallResolutionContext);
    }

    private final OverloadResolutionResultsImpl<? extends CallableDescriptor> completeCallForArgument(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="context") BasicCallResolutionContext context) {
        BindingTrace bindingTrace = ((ResolutionContext)context).trace;
        Intrinsics.checkFieldIsNotNull(bindingTrace, "ResolutionContext", "trace");
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkReturnedValueIsNotNull(bindingContext, "BindingTrace", "getBindingContext");
        Call argumentCall = this.getCallForArgument(expression, bindingContext);
        if (argumentCall == null) {
            return null;
        }
        ResolutionResultsCache resolutionResultsCache = ((ResolutionContext)context).resolutionResultsCache;
        Intrinsics.checkFieldIsNotNull(resolutionResultsCache, "ResolutionContext", "resolutionResultsCache");
        ResolutionResultsCache.CachedData cachedDataForCall = resolutionResultsCache.get(argumentCall);
        if (cachedDataForCall == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData = cachedDataForCall;
        OverloadResolutionResultsImpl<? extends CallableDescriptor> cachedResolutionResults = cachedData.component1();
        BasicCallResolutionContext cachedContext = cachedData.component2();
        TracingStrategy tracing = cachedData.component3();
        OverloadResolutionResultsImpl<? extends CallableDescriptor> cachedResults = null;
        OverloadResolutionResultsImpl<? extends CallableDescriptor> overloadResolutionResultsImpl = cachedResolutionResults;
        if (overloadResolutionResultsImpl == null) {
            throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl<out org.jetbrains.jet.lang.descriptors.CallableDescriptor?> cannot be cast to org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl<org.jetbrains.jet.lang.descriptors.CallableDescriptor>");
        }
        cachedResults = overloadResolutionResultsImpl;
        BindingTrace bindingTrace2 = ((ResolutionContext)context).trace;
        Intrinsics.checkFieldIsNotNull(bindingTrace2, "ResolutionContext", "trace");
        Object Context2 = cachedContext.replaceBindingTrace(bindingTrace2);
        Intrinsics.checkReturnedValueIsNotNull(Context2, "BasicCallResolutionContext", "replaceBindingTrace");
        BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)Context2;
        JetType jetType = ((ResolutionContext)context).expectedType;
        Intrinsics.checkFieldIsNotNull(jetType, "ResolutionContext", "expectedType");
        Object Context3 = basicCallResolutionContext.replaceExpectedType(jetType);
        Intrinsics.checkReturnedValueIsNotNull(Context3, "BasicCallResolutionContext", "replaceExpectedType");
        Object Context4 = ((BasicCallResolutionContext)Context3).replaceCollectAllCandidates(false);
        Intrinsics.checkReturnedValueIsNotNull(Context4, "BasicCallResolutionContext", "replaceCollectAllCandidates");
        BasicCallResolutionContext contextForArgument = (BasicCallResolutionContext)Context4;
        return this.completeCall(contextForArgument, cachedResults, tracing);
    }

    private final Call getCallForArgument(@JetValueParameter(name="argument", type="?") JetExpression argument, @JetValueParameter(name="bindingContext") BindingContext bindingContext) {
        if (!ExpressionTypingUtils.dependsOnExpectedType(argument)) {
            return null;
        }
        if (argument instanceof JetBlockExpression) {
            JetElement lastStatement = JetPsiUtil.getLastStatementInABlock((JetBlockExpression)argument);
            JetElement jetElement = lastStatement;
            if (!(jetElement instanceof JetExpression)) {
                jetElement = null;
            }
            return this.getCallForArgument((JetExpression)jetElement, bindingContext);
        }
        JetExpression jetExpression = argument;
        return jetExpression != null ? CallUtilPackage-callUtil-bbaa9fe2.getCall(jetExpression, bindingContext) : null;
    }

    private final void updateRecordedTypeForArgument(@JetValueParameter(name="updatedType", type="?") JetType updatedType, @JetValueParameter(name="recordedType", type="?") JetType recordedType, @JetValueParameter(name="argumentExpression") JetExpression argumentExpression, @JetValueParameter(name="trace") BindingTrace trace) {
        if (Intrinsics.areEqual(recordedType, updatedType)) {
            return;
        }
        CallCompleter$updateRecordedTypeForArgument$1 callCompleter$updateRecordedTypeForArgument$1 = CallCompleter$updateRecordedTypeForArgument$1.INSTANCE$;
        ArrayList<JetExpression> expressions = new ArrayList<JetExpression>();
        JetExpression expression = argumentExpression;
        while (expression != null) {
            JetExpression jetExpression = expression;
            if (jetExpression == null) {
                Intrinsics.throwNpe();
            }
            expressions.add(jetExpression);
            expression = callCompleter$updateRecordedTypeForArgument$1.invoke(expression);
        }
        Iterable iterable = expressions;
        for (Object t : iterable) {
            JetExpression expression2 = (JetExpression)t;
            BindingContextUtils.updateRecordedType(updatedType, expression2, trace, CallCompleter.hasNecessarySafeCall$b$1(this, expression2, trace));
        }
    }

    private final boolean hasNecessarySafeCall(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="trace") BindingTrace trace) {
        if (!(expression instanceof JetSafeQualifiedExpression)) {
            return false;
        }
        WritableSlice<JetExpression, JetType> writableSlice = BindingContext.EXPRESSION_TYPE;
        Intrinsics.checkFieldIsNotNull(writableSlice, "BindingContext", "EXPRESSION_TYPE");
        ReadOnlySlice readOnlySlice = writableSlice;
        JetExpression jetExpression = ((JetSafeQualifiedExpression)expression).getReceiverExpression();
        Intrinsics.checkReturnedValueIsNotNull(jetExpression, "JetSafeQualifiedExpression", "getReceiverExpression");
        JetType expressionType = (JetType)trace.get(readOnlySlice, jetExpression);
        return expressionType != null ? expressionType.isNullable() : false;
    }

    @NotNull
    public final ArgumentTypeResolver getArgumentTypeResolver() {
        ArgumentTypeResolver argumentTypeResolver = this.argumentTypeResolver;
        if (argumentTypeResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "getArgumentTypeResolver"));
        }
        return argumentTypeResolver;
    }

    @NotNull
    public final CandidateResolver getCandidateResolver() {
        CandidateResolver candidateResolver = this.candidateResolver;
        if (candidateResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "getCandidateResolver"));
        }
        return candidateResolver;
    }

    public CallCompleter(@JetValueParameter(name="argumentTypeResolver") @NotNull ArgumentTypeResolver argumentTypeResolver, @JetValueParameter(name="candidateResolver") @NotNull CandidateResolver candidateResolver) {
        if (argumentTypeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypeResolver", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "<init>"));
        }
        if (candidateResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolver", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "<init>"));
        }
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(candidateResolver, "candidateResolver");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
    }

    public static final /* synthetic */ <D extends CallableDescriptor> void completeResolvedCallAndArguments$b$0(@JetValueParameter(name="$this", type="?") CallCompleter $this, @JetValueParameter(name="resolvedCall", type="?") @Nullable MutableResolvedCall<D> resolvedCall, @JetValueParameter(name="results") @NotNull OverloadResolutionResultsImpl<D> results, @JetValueParameter(name="context") @NotNull BasicCallResolutionContext context, @JetValueParameter(name="tracing") @NotNull TracingStrategy tracing) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeResolvedCallAndArguments$b$0"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeResolvedCallAndArguments$b$0"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeResolvedCallAndArguments$b$0"));
        }
        $this.completeResolvedCallAndArguments(resolvedCall, results, context, tracing);
    }

    public static final /* synthetic */ boolean hasNecessarySafeCall$b$1(@JetValueParameter(name="$this", type="?") CallCompleter $this, @JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "hasNecessarySafeCall$b$1"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "hasNecessarySafeCall$b$1"));
        }
        return $this.hasNecessarySafeCall(expression, trace);
    }
}

