/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CallResolverUtil {
    private CallResolverUtil() {
    }

    public static boolean hasUnknownFunctionParameter(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "hasUnknownFunctionParameter"));
        }
        assert (KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(type));
        List<TypeProjection> arguments = type.getArguments();
        List<TypeProjection> functionParameters = arguments.subList(0, arguments.size() - 1);
        for (TypeProjection functionParameter : functionParameters) {
            if (!TypeUtils.containsSpecialType(functionParameter.getType(), TypeUtils.DONT_CARE) && !ErrorUtils.containsUninferredParameter(functionParameter.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUnknownReturnType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "hasUnknownReturnType"));
        }
        assert (KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(type));
        JetType returnTypeFromFunctionType = KotlinBuiltIns.getInstance().getReturnTypeFromFunctionType(type);
        return ErrorUtils.containsErrorType(returnTypeFromFunctionType);
    }

    public static JetType replaceReturnTypeByUnknown(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "replaceReturnTypeByUnknown"));
        }
        assert (KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(type));
        List<TypeProjection> arguments = type.getArguments();
        ArrayList<TypeProjection> newArguments = Lists.newArrayList();
        newArguments.addAll(arguments.subList(0, arguments.size() - 1));
        newArguments.add(new TypeProjectionImpl(Variance.INVARIANT, TypeUtils.DONT_CARE));
        return new JetTypeImpl(type.getAnnotations(), type.getConstructor(), type.isNullable(), newArguments, type.getMemberScope());
    }

    private static boolean hasReturnTypeDependentOnUninferredParams(@NotNull CallableDescriptor candidateDescriptor, @NotNull ConstraintSystem constraintSystem) {
        if (candidateDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateDescriptor", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "hasReturnTypeDependentOnUninferredParams"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "hasReturnTypeDependentOnUninferredParams"));
        }
        JetType returnType = candidateDescriptor.getReturnType();
        if (returnType == null) {
            return false;
        }
        for (TypeParameterDescriptor typeVariable : constraintSystem.getTypeVariables()) {
            JetType inferredValueForTypeVariable = constraintSystem.getTypeBounds(typeVariable).getValue();
            if (inferredValueForTypeVariable != null || !TypeUtils.dependsOnTypeParameters(returnType, Collections.singleton(typeVariable))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInferredReturnType(@NotNull CallableDescriptor candidateDescriptor, @NotNull ConstraintSystem constraintSystem) {
        if (candidateDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateDescriptor", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "hasInferredReturnType"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "hasInferredReturnType"));
        }
        if (CallResolverUtil.hasReturnTypeDependentOnUninferredParams(candidateDescriptor, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsFromPosition(ConstraintPosition.EXPECTED_TYPE_POSITION);
    }

    @NotNull
    public static JetType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor) {
        if (receiverParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterDescriptor", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "getErasedReceiverType"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "getErasedReceiverType"));
        }
        JetType receiverType = receiverParameterDescriptor.getType();
        for (TypeParameterDescriptor typeParameter : descriptor.getTypeParameters()) {
            if (!typeParameter.getTypeConstructor().equals(receiverType.getConstructor())) continue;
            receiverType = typeParameter.getUpperBoundsAsType();
        }
        ArrayList<TypeProjectionImpl> fakeTypeArguments = Lists.newArrayList();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(receiverType.getAnnotations(), receiverType.getConstructor(), receiverType.isNullable(), fakeTypeArguments, ErrorUtils.createErrorScope("Error scope for erased receiver type", true));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "getErasedReceiverType"));
        }
        return jetTypeImpl;
    }

    public static boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "isOrOverridesSynthesized"));
        }
        if (descriptor.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return true;
        }
        if (descriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            for (CallableMemberDescriptor callableMemberDescriptor : descriptor.getOverriddenDescriptors()) {
                if (CallResolverUtil.isOrOverridesSynthesized(callableMemberDescriptor)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isInvokeCallOnVariable(@NotNull Call call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "isInvokeCallOnVariable"));
        }
        if (call.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue thisObject = call.getThisObject();
        JetExpression expression = ((ExpressionReceiver)thisObject).getExpression();
        return expression instanceof JetSimpleNameExpression;
    }

    public static boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "isInvokeCallOnExpressionWithBothReceivers"));
        }
        if (call.getCallType() != Call.CallType.INVOKE || CallResolverUtil.isInvokeCallOnVariable(call)) {
            return false;
        }
        return call.getExplicitReceiver().exists() && call.getThisObject().exists();
    }

    public static enum ResolveArgumentsMode {
        RESOLVE_FUNCTION_ARGUMENTS,
        SHAPE_FUNCTION_ARGUMENTS;

    }
}

