/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;

public class ResolutionCandidate<D extends CallableDescriptor> {
    private final Call call;
    private final D candidateDescriptor;
    private ReceiverValue thisObject;
    private ReceiverValue receiverArgument;
    private ExplicitReceiverKind explicitReceiverKind;
    private Boolean isSafeCall;

    private ResolutionCandidate(@NotNull Call call, @NotNull D descriptor, @NotNull ReceiverValue thisObject, @NotNull ReceiverValue receiverArgument2, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable Boolean isSafeCall) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        if (thisObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisObject", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        if (receiverArgument2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        this.call = call;
        this.candidateDescriptor = descriptor;
        this.thisObject = thisObject;
        this.receiverArgument = receiverArgument2;
        this.explicitReceiverKind = explicitReceiverKind;
        this.isSafeCall = isSafeCall;
    }

    static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call, @NotNull D descriptor) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        return new ResolutionCandidate<D>(call, descriptor, ReceiverValue.NO_RECEIVER, ReceiverValue.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call, @NotNull D descriptor, @Nullable Boolean isSafeCall) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        return new ResolutionCandidate<D>(call, descriptor, ReceiverValue.NO_RECEIVER, ReceiverValue.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, isSafeCall);
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call, @NotNull D descriptor, @NotNull ReceiverValue thisObject, @NotNull ReceiverValue receiverArgument2, @NotNull ExplicitReceiverKind explicitReceiverKind, boolean isSafeCall) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (thisObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisObject", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (receiverArgument2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        return new ResolutionCandidate<D>(call, descriptor, thisObject, receiverArgument2, explicitReceiverKind, isSafeCall);
    }

    public void setThisObject(@NotNull ReceiverValue thisObject) {
        if (thisObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisObject", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "setThisObject"));
        }
        this.thisObject = thisObject;
    }

    public void setReceiverArgument(@NotNull ReceiverValue receiverArgument2) {
        if (receiverArgument2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "setReceiverArgument"));
        }
        this.receiverArgument = receiverArgument2;
    }

    public void setExplicitReceiverKind(@NotNull ExplicitReceiverKind explicitReceiverKind) {
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "setExplicitReceiverKind"));
        }
        this.explicitReceiverKind = explicitReceiverKind;
    }

    @NotNull
    public Call getCall() {
        Call call = this.call;
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "getCall"));
        }
        return call;
    }

    @NotNull
    public D getDescriptor() {
        D d = this.candidateDescriptor;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "getDescriptor"));
        }
        return d;
    }

    @NotNull
    public ReceiverValue getThisObject() {
        ReceiverValue receiverValue = this.thisObject;
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "getThisObject"));
        }
        return receiverValue;
    }

    @NotNull
    public ReceiverValue getReceiverArgument() {
        ReceiverValue receiverValue = this.receiverArgument;
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "getReceiverArgument"));
        }
        return receiverValue;
    }

    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        ExplicitReceiverKind explicitReceiverKind = this.explicitReceiverKind;
        if (explicitReceiverKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "getExplicitReceiverKind"));
        }
        return explicitReceiverKind;
    }

    @NotNull
    public static <D extends CallableDescriptor> List<ResolutionCandidate<D>> convertCollection(@NotNull Call call, @NotNull Collection<? extends D> descriptors, boolean isSafeCall) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "convertCollection"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "convertCollection"));
        }
        ArrayList<ResolutionCandidate<D>> result2 = Lists.newArrayList();
        for (CallableDescriptor descriptor : descriptors) {
            result2.add(ResolutionCandidate.create(call, descriptor, isSafeCall));
        }
        ArrayList<ResolutionCandidate<D>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionCandidate", "convertCollection"));
        }
        return arrayList;
    }

    public void setSafeCall(boolean safeCall) {
        assert (this.isSafeCall == null);
        this.isSafeCall = safeCall;
    }

    public boolean isSafeCall() {
        assert (this.isSafeCall != null);
        return this.isSafeCall;
    }

    public String toString() {
        return this.candidateDescriptor.toString();
    }
}

