/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public enum JvmPrimitiveType {
    BOOLEAN(PrimitiveType.BOOLEAN, "boolean", "java.lang.Boolean"),
    CHAR(PrimitiveType.CHAR, "char", "java.lang.Character"),
    BYTE(PrimitiveType.BYTE, "byte", "java.lang.Byte"),
    SHORT(PrimitiveType.SHORT, "short", "java.lang.Short"),
    INT(PrimitiveType.INT, "int", "java.lang.Integer"),
    FLOAT(PrimitiveType.FLOAT, "float", "java.lang.Float"),
    LONG(PrimitiveType.LONG, "long", "java.lang.Long"),
    DOUBLE(PrimitiveType.DOUBLE, "double", "java.lang.Double");

    private static final Set<FqName> WRAPPERS_CLASS_NAMES;
    private final PrimitiveType primitiveType;
    private final String name;
    private final FqName wrapperFqName;

    public static boolean isWrapperClassName(@NotNull FqName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/java/JvmPrimitiveType", "isWrapperClassName"));
        }
        return WRAPPERS_CLASS_NAMES.contains(className);
    }

    private JvmPrimitiveType(@NotNull PrimitiveType primitiveType, @NotNull String name, @NotNull String wrapperClassName) {
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "org/jetbrains/jet/lang/resolve/java/JvmPrimitiveType", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/JvmPrimitiveType", "<init>"));
        }
        if (wrapperClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapperClassName", "org/jetbrains/jet/lang/resolve/java/JvmPrimitiveType", "<init>"));
        }
        this.primitiveType = primitiveType;
        this.name = name;
        this.wrapperFqName = new FqName(wrapperClassName);
    }

    @NotNull
    public PrimitiveType getPrimitiveType() {
        PrimitiveType primitiveType = this.primitiveType;
        if (primitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmPrimitiveType", "getPrimitiveType"));
        }
        return primitiveType;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmPrimitiveType", "getName"));
        }
        return string;
    }

    @NotNull
    public FqName getWrapperFqName() {
        FqName fqName = this.wrapperFqName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmPrimitiveType", "getWrapperFqName"));
        }
        return fqName;
    }

    static {
        WRAPPERS_CLASS_NAMES = new HashSet<FqName>();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            WRAPPERS_CLASS_NAMES.add(primitiveType.getWrapperFqName());
        }
    }
}

