/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaWildcardType;

public class JavaSignatureFormatter {
    private static JavaSignatureFormatter instance;

    private JavaSignatureFormatter() {
    }

    @NotNull
    public static JavaSignatureFormatter getInstance() {
        if (instance == null) {
            instance = new JavaSignatureFormatter();
        }
        JavaSignatureFormatter javaSignatureFormatter = instance;
        if (javaSignatureFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "getInstance"));
        }
        return javaSignatureFormatter;
    }

    @NotNull
    public String formatMethod(@NotNull JavaMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatMethod"));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(method.getName());
        buffer.append('(');
        boolean firstParameter = true;
        for (JavaValueParameter parameter : method.getValueParameters()) {
            if (!firstParameter) {
                buffer.append(", ");
            }
            firstParameter = false;
            buffer.append(this.formatType(parameter.getType()));
        }
        buffer.append(')');
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatMethod"));
        }
        return string;
    }

    @NotNull
    private String formatType(@NotNull JavaType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatType"));
        }
        if (type instanceof JavaPrimitiveType) {
            String string = ((JavaPrimitiveType)type).getCanonicalText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatType"));
            }
            return string;
        }
        if (type instanceof JavaArrayType) {
            String string = this.formatType(((JavaArrayType)type).getComponentType()) + "[]";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatType"));
            }
            return string;
        }
        if (type instanceof JavaClassifierType) {
            String string = this.formatClassifierType((JavaClassifierType)type);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatType"));
            }
            return string;
        }
        if (type instanceof JavaWildcardType) {
            JavaWildcardType wildcardType = (JavaWildcardType)type;
            if (wildcardType.isExtends()) {
                String string = "? extends " + this.formatType(wildcardType.getBound());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatType"));
                }
                return string;
            }
            if ("?" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatType"));
            }
            return "?";
        }
        throw new IllegalArgumentException("Wrong type: " + type);
    }

    @NotNull
    private String formatClassifierType(@NotNull JavaClassifierType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatClassifierType"));
        }
        JavaClassifier classifier2 = type.getClassifier();
        if (classifier2 == null) {
            String string = "[UNRESOLVED: " + type + "]";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatClassifierType"));
            }
            return string;
        }
        if (classifier2 instanceof JavaTypeParameter) {
            String string = classifier2.getName().asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatClassifierType"));
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder(((JavaClass)classifier2).getFqName().asString());
        List<JavaType> typeArguments = type.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            buffer.append("<");
            boolean firstArgument = true;
            for (JavaType typeArgument : typeArguments) {
                if (!firstArgument) {
                    buffer.append(",");
                }
                firstArgument = false;
                buffer.append(this.formatType(typeArgument));
            }
            buffer.append(">");
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaSignatureFormatter", "formatClassifierType"));
        }
        return string;
    }
}

