/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaAnnotationImpl
extends JavaElementImpl<PsiAnnotation>
implements JavaAnnotation {
    public JavaAnnotationImpl(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotation", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaAnnotationImpl", "<init>"));
        }
        super(psiAnnotation);
    }

    @Override
    @Nullable
    public JavaAnnotationArgument findArgument(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaAnnotationImpl", "findArgument"));
        }
        PsiAnnotationMemberValue attribute = ((PsiAnnotation)this.getPsi()).findAttributeValue(name.asString());
        return attribute == null ? null : JavaAnnotationArgumentImpl.create(attribute, name);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotationArgument> getArguments() {
        Collection<JavaAnnotationArgument> collection = JavaElementCollectionFromPsiArrayUtil.namedAnnotationArguments(((PsiAnnotation)this.getPsi()).getParameterList().getAttributes());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaAnnotationImpl", "getArguments"));
        }
        return collection;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        String qualifiedName = ((PsiAnnotation)this.getPsi()).getQualifiedName();
        return qualifiedName == null ? null : new FqName(qualifiedName);
    }

    @Override
    @Nullable
    public JavaClass resolve() {
        PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)this.getPsi()).getNameReferenceElement();
        if (referenceElement == null) {
            return null;
        }
        PsiElement resolved = referenceElement.resolve();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        return new JavaClassImpl((PsiClass)resolved);
    }
}

