/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaFieldImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaPackageImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeParameterImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaValueParameterImpl;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaElementCollectionFromPsiArrayUtil {
    private JavaElementCollectionFromPsiArrayUtil() {
    }

    @NotNull
    private static <Psi, Java> List<Java> convert(@NotNull Psi[] elements, @NotNull Factory<Psi, Java> factory) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        if (elements.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
            }
            return list;
        }
        ArrayList<Java> result2 = new ArrayList<Java>(elements.length);
        for (Psi element : elements) {
            result2.add(factory.create(element));
        }
        ArrayList<Java> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        return arrayList;
    }

    @NotNull
    private static <Psi, Java> List<Java> convert(@NotNull Iterable<Psi> elements, final @NotNull Factory<Psi, Java> factory) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        if (!elements.iterator().hasNext()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
            }
            return list;
        }
        List list = KotlinPackage.map(elements, new Function1<Psi, Java>(){

            @Override
            public Java invoke(Psi psi) {
                return factory.create(psi);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        return list;
    }

    @NotNull
    public static Collection<JavaClass> classes(@NotNull PsiClass[] classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classes"));
        }
        List<JavaClass> list = JavaElementCollectionFromPsiArrayUtil.convert(classes2, Factories.CLASSES);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classes"));
        }
        return list;
    }

    @NotNull
    public static Collection<JavaClass> classes(@NotNull Iterable<PsiClass> classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classes"));
        }
        List<JavaClass> list = JavaElementCollectionFromPsiArrayUtil.convert(classes2, Factories.CLASSES);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classes"));
        }
        return list;
    }

    @NotNull
    public static Collection<JavaPackage> packages(@NotNull PsiPackage[] packages) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "packages"));
        }
        List<JavaPackage> list = JavaElementCollectionFromPsiArrayUtil.convert(packages, Factories.PACKAGES);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "packages"));
        }
        return list;
    }

    @NotNull
    public static Collection<JavaMethod> methods(@NotNull PsiMethod[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "methods"));
        }
        List<JavaMethod> list = JavaElementCollectionFromPsiArrayUtil.convert(methods, Factories.METHODS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "methods"));
        }
        return list;
    }

    @NotNull
    public static Collection<JavaField> fields(@NotNull PsiField[] fields2) {
        if (fields2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "fields"));
        }
        List<JavaField> list = JavaElementCollectionFromPsiArrayUtil.convert(fields2, Factories.FIELDS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "fields"));
        }
        return list;
    }

    @NotNull
    public static List<JavaValueParameter> valueParameters(@NotNull PsiParameter[] parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "valueParameters"));
        }
        List<JavaValueParameter> list = JavaElementCollectionFromPsiArrayUtil.convert(parameters, Factories.VALUE_PARAMETERS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "valueParameters"));
        }
        return list;
    }

    @NotNull
    public static List<JavaTypeParameter> typeParameters(@NotNull PsiTypeParameter[] typeParameters) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "typeParameters"));
        }
        List<JavaTypeParameter> list = JavaElementCollectionFromPsiArrayUtil.convert(typeParameters, Factories.TYPE_PARAMETERS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "typeParameters"));
        }
        return list;
    }

    @NotNull
    public static List<JavaType> types(@NotNull PsiType[] types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "types"));
        }
        List<JavaType> list = JavaElementCollectionFromPsiArrayUtil.convert(types, Factories.TYPES);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "types"));
        }
        return list;
    }

    @NotNull
    public static Collection<JavaClassifierType> classifierTypes(@NotNull PsiClassType[] classTypes) {
        if (classTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classTypes", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classifierTypes"));
        }
        List<JavaClassifierType> list = JavaElementCollectionFromPsiArrayUtil.convert(classTypes, Factories.CLASSIFIER_TYPES);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classifierTypes"));
        }
        return list;
    }

    @NotNull
    public static Collection<JavaAnnotation> annotations(@NotNull PsiAnnotation[] annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "annotations"));
        }
        List<JavaAnnotation> list = JavaElementCollectionFromPsiArrayUtil.convert(annotations, Factories.ANNOTATIONS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "annotations"));
        }
        return list;
    }

    @NotNull
    public static List<JavaAnnotationArgument> namelessAnnotationArguments(@NotNull PsiAnnotationMemberValue[] memberValues) {
        if (memberValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberValues", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "namelessAnnotationArguments"));
        }
        List<JavaAnnotationArgument> list = JavaElementCollectionFromPsiArrayUtil.convert(memberValues, Factories.NAMELESS_ANNOTATION_ARGUMENTS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "namelessAnnotationArguments"));
        }
        return list;
    }

    @NotNull
    public static Collection<JavaAnnotationArgument> namedAnnotationArguments(@NotNull PsiNameValuePair[] nameValuePairs) {
        if (nameValuePairs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameValuePairs", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "namedAnnotationArguments"));
        }
        List<JavaAnnotationArgument> list = JavaElementCollectionFromPsiArrayUtil.convert(nameValuePairs, Factories.NAMED_ANNOTATION_ARGUMENTS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "namedAnnotationArguments"));
        }
        return list;
    }

    private static class Factories {
        private static final Factory<PsiClass, JavaClass> CLASSES = new Factory<PsiClass, JavaClass>(){

            @Override
            @NotNull
            public JavaClass create(@NotNull PsiClass psiClass) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$1", "create"));
                }
                JavaClassImpl javaClassImpl = new JavaClassImpl(psiClass);
                if (javaClassImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$1", "create"));
                }
                return javaClassImpl;
            }
        };
        private static final Factory<PsiPackage, JavaPackage> PACKAGES = new Factory<PsiPackage, JavaPackage>(){

            @Override
            @NotNull
            public JavaPackage create(@NotNull PsiPackage psiPackage) {
                if (psiPackage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$2", "create"));
                }
                JavaPackageImpl javaPackageImpl = new JavaPackageImpl(psiPackage);
                if (javaPackageImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$2", "create"));
                }
                return javaPackageImpl;
            }
        };
        private static final Factory<PsiMethod, JavaMethod> METHODS = new Factory<PsiMethod, JavaMethod>(){

            @Override
            @NotNull
            public JavaMethod create(@NotNull PsiMethod psiMethod) {
                if (psiMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$3", "create"));
                }
                JavaMethodImpl javaMethodImpl = new JavaMethodImpl(psiMethod);
                if (javaMethodImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$3", "create"));
                }
                return javaMethodImpl;
            }
        };
        private static final Factory<PsiField, JavaField> FIELDS = new Factory<PsiField, JavaField>(){

            @Override
            @NotNull
            public JavaField create(@NotNull PsiField psiField) {
                if (psiField == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$4", "create"));
                }
                JavaFieldImpl javaFieldImpl = new JavaFieldImpl(psiField);
                if (javaFieldImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$4", "create"));
                }
                return javaFieldImpl;
            }
        };
        private static final Factory<PsiParameter, JavaValueParameter> VALUE_PARAMETERS = new Factory<PsiParameter, JavaValueParameter>(){

            @Override
            @NotNull
            public JavaValueParameter create(@NotNull PsiParameter psiParameter) {
                if (psiParameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$5", "create"));
                }
                JavaValueParameterImpl javaValueParameterImpl = new JavaValueParameterImpl(psiParameter);
                if (javaValueParameterImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$5", "create"));
                }
                return javaValueParameterImpl;
            }
        };
        private static final Factory<PsiTypeParameter, JavaTypeParameter> TYPE_PARAMETERS = new Factory<PsiTypeParameter, JavaTypeParameter>(){

            @Override
            @NotNull
            public JavaTypeParameter create(@NotNull PsiTypeParameter psiTypeParameter) {
                if (psiTypeParameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTypeParameter", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$6", "create"));
                }
                JavaTypeParameterImpl javaTypeParameterImpl = new JavaTypeParameterImpl(psiTypeParameter);
                if (javaTypeParameterImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$6", "create"));
                }
                return javaTypeParameterImpl;
            }
        };
        private static final Factory<PsiType, JavaType> TYPES = new Factory<PsiType, JavaType>(){

            @Override
            @NotNull
            public JavaType create(@NotNull PsiType psiType) {
                if (psiType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$7", "create"));
                }
                JavaTypeImpl<?> javaTypeImpl = JavaTypeImpl.create(psiType);
                if (javaTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$7", "create"));
                }
                return javaTypeImpl;
            }
        };
        private static final Factory<PsiClassType, JavaClassifierType> CLASSIFIER_TYPES = new Factory<PsiClassType, JavaClassifierType>(){

            @Override
            @NotNull
            public JavaClassifierType create(@NotNull PsiClassType psiClassType) {
                if (psiClassType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassType", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$8", "create"));
                }
                JavaClassifierTypeImpl javaClassifierTypeImpl = new JavaClassifierTypeImpl(psiClassType);
                if (javaClassifierTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$8", "create"));
                }
                return javaClassifierTypeImpl;
            }
        };
        private static final Factory<PsiAnnotation, JavaAnnotation> ANNOTATIONS = new Factory<PsiAnnotation, JavaAnnotation>(){

            @Override
            @NotNull
            public JavaAnnotation create(@NotNull PsiAnnotation psiAnnotation) {
                if (psiAnnotation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotation", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$9", "create"));
                }
                JavaAnnotationImpl javaAnnotationImpl = new JavaAnnotationImpl(psiAnnotation);
                if (javaAnnotationImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$9", "create"));
                }
                return javaAnnotationImpl;
            }
        };
        private static final Factory<PsiAnnotationMemberValue, JavaAnnotationArgument> NAMELESS_ANNOTATION_ARGUMENTS = new Factory<PsiAnnotationMemberValue, JavaAnnotationArgument>(){

            @Override
            @NotNull
            public JavaAnnotationArgument create(@NotNull PsiAnnotationMemberValue psiAnnotationMemberValue) {
                if (psiAnnotationMemberValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotationMemberValue", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$10", "create"));
                }
                JavaAnnotationArgument javaAnnotationArgument = JavaAnnotationArgumentImpl.create(psiAnnotationMemberValue, null);
                if (javaAnnotationArgument == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$10", "create"));
                }
                return javaAnnotationArgument;
            }
        };
        private static final Factory<PsiNameValuePair, JavaAnnotationArgument> NAMED_ANNOTATION_ARGUMENTS = new Factory<PsiNameValuePair, JavaAnnotationArgument>(){

            @Override
            @NotNull
            public JavaAnnotationArgument create(@NotNull PsiNameValuePair psiNameValuePair) {
                if (psiNameValuePair == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiNameValuePair", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$11", "create"));
                }
                String name = psiNameValuePair.getName();
                PsiAnnotationMemberValue value = psiNameValuePair.getValue();
                assert (value != null) : "Annotation argument value cannot be null: " + name;
                JavaAnnotationArgument javaAnnotationArgument = JavaAnnotationArgumentImpl.create(value, name == null ? null : Name.identifier(name));
                if (javaAnnotationArgument == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$11", "create"));
                }
                return javaAnnotationArgument;
            }
        };

        private Factories() {
        }
    }

    private static interface Factory<Psi, Java> {
        @NotNull
        public Java create(@NotNull Psi var1);
    }
}

