/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.ConstantsPackage;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPropertyInitializerEvaluator;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaFieldImpl;

public class JavaPropertyInitializerEvaluatorImpl
implements JavaPropertyInitializerEvaluator {
    @Override
    @Nullable
    public CompileTimeConstant<?> getInitializerConstant(@NotNull JavaField field, @NotNull PropertyDescriptor descriptor) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaPropertyInitializerEvaluatorImpl", "getInitializerConstant"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaPropertyInitializerEvaluatorImpl", "getInitializerConstant"));
        }
        PsiExpression initializer = ((JavaFieldImpl)field).getInitializer();
        Object evaluatedExpression = JavaConstantExpressionEvaluator.computeConstantExpression(initializer, false);
        if (evaluatedExpression != null) {
            return ConstantsPackage.createCompileTimeConstant(evaluatedExpression, ConstantExpressionEvaluator.OBJECT$.isPropertyCompileTimeConstant(descriptor), false, true, descriptor.getType());
        }
        return null;
    }
}

