/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin.header;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.KotlinClassHeader;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class ReadKotlinClassHeaderAnnotationVisitor
implements KotlinJvmBinaryClass.AnnotationVisitor {
    private static final Map<JvmClassName, KotlinClassHeader.Kind> HEADER_KINDS = new HashMap<JvmClassName, KotlinClassHeader.Kind>();
    private int version = -1;
    private String[] annotationData = null;
    private KotlinClassHeader.Kind headerKind = null;
    private JvmAnnotationNames.KotlinSyntheticClass.Kind syntheticClassKind = null;

    @Nullable
    public KotlinClassHeader createHeader() {
        if (this.headerKind == null) {
            return null;
        }
        if (!AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            return new KotlinClassHeader(KotlinClassHeader.Kind.INCOMPATIBLE_ABI_VERSION, this.version, null, null);
        }
        if ((this.headerKind == KotlinClassHeader.Kind.CLASS || this.headerKind == KotlinClassHeader.Kind.PACKAGE_FACADE) && this.annotationData == null) {
            return null;
        }
        return new KotlinClassHeader(this.headerKind, this.version, this.annotationData, this.syntheticClassKind);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull JvmClassName annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitAnnotation"));
        }
        KotlinClassHeader.Kind newKind = HEADER_KINDS.get(annotation);
        if (newKind == null) {
            return null;
        }
        if (this.headerKind != null) {
            return null;
        }
        this.headerKind = newKind;
        if (newKind == KotlinClassHeader.Kind.CLASS || newKind == KotlinClassHeader.Kind.PACKAGE_FACADE) {
            return this.kotlinClassOrPackageVisitor(annotation);
        }
        if (newKind == KotlinClassHeader.Kind.SYNTHETIC_CLASS) {
            return this.syntheticClassAnnotationVisitor();
        }
        return null;
    }

    @Override
    public void visitEnd() {
    }

    @NotNull
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor kotlinClassOrPackageVisitor(final @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "kotlinClassOrPackageVisitor"));
        }
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                ReadKotlinClassHeaderAnnotationVisitor.this.visitIntValueForSupportedAnnotation(name, value, annotationClassName);
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitEnum"));
                }
                ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitArray"));
                }
                if (name.asString().equals("data")) {
                    return this.stringArrayVisitor();
                }
                if (AbiVersionUtil.isAbiVersionCompatible(ReadKotlinClassHeaderAnnotationVisitor.this.version)) {
                    throw new IllegalStateException("Unexpected array argument " + name + " for annotation " + annotationClassName);
                }
                return null;
            }

            @NotNull
            private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor stringArrayVisitor() {
                final ArrayList strings = new ArrayList(1);
                KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor(){

                    @Override
                    public void visit(@Nullable Object value) {
                        if (!(value instanceof String)) {
                            throw new IllegalStateException("Unexpected argument value: " + value);
                        }
                        strings.add((String)value);
                    }

                    @Override
                    public void visitEnum(@NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                        if (enumClassName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1$1", "visitEnum"));
                        }
                        if (enumEntryName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1$1", "visitEnum"));
                        }
                        ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(null, annotationClassName);
                    }

                    @Override
                    public void visitEnd() {
                        ReadKotlinClassHeaderAnnotationVisitor.access$302(ReadKotlinClassHeaderAnnotationVisitor.this, strings.toArray(new String[strings.size()]));
                    }
                };
                if (annotationArrayArgumentVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "stringArrayVisitor"));
                }
                return annotationArrayArgumentVisitor;
            }

            @Override
            public void visitEnd() {
            }
        };
        if (annotationArgumentVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "kotlinClassOrPackageVisitor"));
        }
        return annotationArgumentVisitor;
    }

    @NotNull
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor syntheticClassAnnotationVisitor() {
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                ReadKotlinClassHeaderAnnotationVisitor.this.visitIntValueForSupportedAnnotation(name, value, JvmAnnotationNames.KotlinSyntheticClass.CLASS_NAME);
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitEnum"));
                }
                if (enumClassName.getInternalName().equals("kotlin/jvm/internal/KotlinSyntheticClass$Kind") && name.equals(JvmAnnotationNames.KotlinSyntheticClass.KIND_FIELD_NAME)) {
                    ReadKotlinClassHeaderAnnotationVisitor.this.syntheticClassKind = JvmAnnotationNames.KotlinSyntheticClass.Kind.valueOfOrNull(enumEntryName.asString());
                    if (ReadKotlinClassHeaderAnnotationVisitor.this.syntheticClassKind != null) {
                        return;
                    }
                }
                if (AbiVersionUtil.isAbiVersionCompatible(ReadKotlinClassHeaderAnnotationVisitor.this.version)) {
                    throw new IllegalStateException("Unexpected enum entry for synthetic class annotation: " + name + "=" + enumClassName + "." + enumEntryName);
                }
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitArray"));
                }
                return ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, JvmAnnotationNames.KotlinSyntheticClass.CLASS_NAME);
            }

            @Override
            public void visitEnd() {
            }
        };
        if (annotationArgumentVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "syntheticClassAnnotationVisitor"));
        }
        return annotationArgumentVisitor;
    }

    private void visitIntValueForSupportedAnnotation(@Nullable Name name, @Nullable Object value, @NotNull JvmClassName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitIntValueForSupportedAnnotation"));
        }
        if (name != null && name.asString().equals("abiVersion")) {
            this.version = value == null ? -1 : (Integer)value;
        } else {
            this.unexpectedArgument(name, className);
        }
    }

    @Nullable
    private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor unexpectedArgument(@Nullable Name name, @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "unexpectedArgument"));
        }
        if (AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            throw new IllegalStateException("Unexpected argument " + name + " for annotation " + annotationClassName);
        }
        return null;
    }

    static /* synthetic */ String[] access$302(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.annotationData = x1;
        return x1;
    }

    static {
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_CLASS), KotlinClassHeader.Kind.CLASS);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE), KotlinClassHeader.Kind.PACKAGE_FACADE);
        HEADER_KINDS.put(JvmAnnotationNames.KotlinSyntheticClass.CLASS_NAME, KotlinClassHeader.Kind.SYNTHETIC_CLASS);
        List<FqName> incompatible = Arrays.asList(JvmAnnotationNames.OLD_JET_CLASS_ANNOTATION, JvmAnnotationNames.OLD_JET_PACKAGE_CLASS_ANNOTATION, JvmAnnotationNames.OLD_KOTLIN_CLASS, JvmAnnotationNames.OLD_KOTLIN_PACKAGE, JvmAnnotationNames.OLD_KOTLIN_PACKAGE_FRAGMENT, JvmAnnotationNames.OLD_KOTLIN_TRAIT_IMPL);
        for (FqName fqName : incompatible) {
            HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(fqName), KotlinClassHeader.Kind.INCOMPATIBLE_ABI_VERSION);
        }
    }
}

