/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.name;

import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.CharIterator;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import kotlin.tailRecursive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.NamePackage;
import org.jetbrains.jet.lang.resolve.name.NamePackage-FqNamesUtil-f4b71e84$WhenMappings;

@KotlinSyntheticClass(abiVersion=17, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class NamePackage-FqNamesUtil-f4b71e84 {
    public static final boolean isSubpackageOf(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="packageName") @NotNull FqName packageName) {
        int n;
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isSubpackageOf"));
        }
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        if (Intrinsics.areEqual($receiver, packageName)) {
            n = 1;
        } else if (packageName.isRoot()) {
            n = 1;
        } else {
            String string = $receiver.asString();
            Intrinsics.checkReturnedValueIsNotNull(string, "FqName", "asString");
            String string2 = packageName.asString();
            Intrinsics.checkReturnedValueIsNotNull(string2, "FqName", "asString");
            n = NamePackage-FqNamesUtil-f4b71e84.isSubpackageOf(string, string2) ? 1 : 0;
        }
        return n != 0;
    }

    public static final boolean isParent(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="child") @NotNull FqName child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isParent"));
        }
        Intrinsics.checkParameterIsNotNull(child, "child");
        return NamePackage-FqNamesUtil-f4b71e84.isSubpackageOf(child, $receiver);
    }

    public static final boolean isOneSegmentFQN(@JetValueParameter(name="$receiver") FqName $receiver) {
        boolean bl;
        if (!$receiver.isRoot()) {
            FqName fqName = $receiver.parent();
            Intrinsics.checkReturnedValueIsNotNull(fqName, "FqName", "parent");
            bl = fqName.isRoot();
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final FqName withoutFirstSegment(@JetValueParameter(name="$receiver") FqName $receiver) {
        boolean bl;
        if (!$receiver.isRoot()) {
            FqName fqName = $receiver.parent();
            Intrinsics.checkReturnedValueIsNotNull(fqName, "FqName", "parent");
            bl = fqName.isRoot();
        } else {
            bl = true;
        }
        if (bl) {
            FqName fqName = FqName.ROOT;
            Intrinsics.checkFieldIsNotNull(fqName, "FqName", "ROOT");
            if (fqName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "withoutFirstSegment"));
            }
            return fqName;
        }
        String string = $receiver.asString();
        Intrinsics.checkReturnedValueIsNotNull(string, "FqName", "asString");
        String fqNameStr = string;
        FqName fqName = new FqName(KotlinPackage.substring(fqNameStr, KotlinPackage.indexOf(fqNameStr, '.') + 1, KotlinPackage.length(fqNameStr)));
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "withoutFirstSegment"));
        }
        return fqName;
    }

    public static final int numberOfSegments(@JetValueParameter(name="$receiver") FqName $receiver) {
        int n;
        if ($receiver.isRoot()) {
            n = 0;
        } else {
            FqName fqName = $receiver.parent();
            Intrinsics.checkReturnedValueIsNotNull(fqName, "FqName", "parent");
            n = 1 + NamePackage-FqNamesUtil-f4b71e84.numberOfSegments(fqName);
        }
        return n;
    }

    @NotNull
    public static final FqName tail(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="headFQN") @NotNull FqName headFQN) {
        FqName fqName;
        if (headFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headFQN", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "tail"));
        }
        Intrinsics.checkParameterIsNotNull(headFQN, "headFQN");
        if (!(!NamePackage-FqNamesUtil-f4b71e84.isSubpackageOf($receiver, headFQN)) ? headFQN.isRoot() : true) {
            fqName = $receiver;
        } else if (Intrinsics.areEqual($receiver, headFQN)) {
            FqName fqName2 = FqName.ROOT;
            fqName = fqName2;
            Intrinsics.checkFieldIsNotNull(fqName2, "FqName", "ROOT");
        } else {
            String string = $receiver.asString();
            Intrinsics.checkReturnedValueIsNotNull(string, "FqName", "asString");
            String string2 = headFQN.asString();
            Intrinsics.checkReturnedValueIsNotNull(string2, "FqName", "asString");
            fqName = new FqName(KotlinPackage.substring(string, string2.length() + 1));
        }
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "tail"));
        }
        return fqName;
    }

    @Nullable
    public static final FqName plusOneSegment(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="fullFQN") @NotNull FqName fullFQN) {
        if (fullFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullFQN", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "plusOneSegment"));
        }
        Intrinsics.checkParameterIsNotNull(fullFQN, "fullFQN");
        if (!(!NamePackage-FqNamesUtil-f4b71e84.isParent($receiver, fullFQN)) ? Intrinsics.areEqual(fullFQN, $receiver) : true) {
            return null;
        }
        List<Name> list = NamePackage-FqNamesUtil-f4b71e84.tail(fullFQN, $receiver).pathSegments();
        Intrinsics.checkReturnedValueIsNotNull(list, "FqName", "pathSegments");
        Name name = KotlinPackage.getFirst(list);
        if (name == null) {
            Intrinsics.throwNpe();
        }
        FqName fqName = $receiver.child(name);
        Intrinsics.checkReturnedValueIsNotNull(fqName, "FqName", "child");
        return fqName;
    }

    public static final boolean isImported(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="importPath") @NotNull ImportPath importPath, @JetValueParameter(name="skipAliasedImports") boolean skipAliasedImports) {
        boolean bl;
        if (importPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPath", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isImported"));
        }
        Intrinsics.checkParameterIsNotNull(importPath, "importPath");
        if (skipAliasedImports ? importPath.hasAlias() : false) {
            bl = false;
        } else {
            boolean bl2 = importPath.isAllUnder() ? !$receiver.isRoot() : false;
            if (bl2) {
                FqName fqName = importPath.fqnPart();
                Intrinsics.checkReturnedValueIsNotNull(fqName, "ImportPath", "fqnPart");
                FqName fqName2 = $receiver.parent();
                Intrinsics.checkReturnedValueIsNotNull(fqName2, "FqName", "parent");
                bl = Intrinsics.areEqual(fqName, fqName2);
            } else {
                FqName fqName = importPath.fqnPart();
                Intrinsics.checkReturnedValueIsNotNull(fqName, "ImportPath", "fqnPart");
                bl = Intrinsics.areEqual(fqName, $receiver);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isImported$default(FqName fqName, ImportPath importPath, boolean bl, int n) {
        int n2;
        void var3_4;
        if ((var3_4 & 2) != 0) {
            n2 = 1;
        }
        return NamePackage-FqNamesUtil-f4b71e84.isImported(fqName, importPath, n2 != 0);
    }

    public static final boolean isImported(@JetValueParameter(name="$receiver") ImportPath $receiver, @JetValueParameter(name="alreadyImported") @NotNull ImportPath alreadyImported) {
        boolean bl;
        if (alreadyImported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alreadyImported", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isImported"));
        }
        Intrinsics.checkParameterIsNotNull(alreadyImported, "alreadyImported");
        if (!$receiver.isAllUnder() ? $receiver.hasAlias() : true) {
            bl = Intrinsics.areEqual($receiver, alreadyImported);
        } else {
            FqName fqName = $receiver.fqnPart();
            Intrinsics.checkReturnedValueIsNotNull(fqName, "ImportPath", "fqnPart");
            bl = NamePackage-FqNamesUtil-f4b71e84.isImported$default(fqName, alreadyImported, false, 2);
        }
        return bl;
    }

    public static final boolean isImported(@JetValueParameter(name="$receiver") ImportPath $receiver, @JetValueParameter(name="imports") @NotNull Iterable<? extends ImportPath> imports) {
        boolean bl;
        block2: {
            if (imports == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isImported"));
            }
            Intrinsics.checkParameterIsNotNull(imports, "imports");
            Iterable<? extends ImportPath> iterable = imports;
            for (ImportPath importPath : iterable) {
                ImportPath it = importPath;
                if (!NamePackage-FqNamesUtil-f4b71e84.isImported($receiver, it)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isValidJavaFqName(@JetValueParameter(name="qualifiedName", type="?") @Nullable String qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        @KotlinSyntheticClass(abiVersion=17, kind=KotlinSyntheticClass.Kind.LOCAL_CLASS)
        public final class State
        extends Enum<State>
        implements KObject {
            public static final /* synthetic */ KClassImpl $kotlinClass;
            public static final /* enum */ State BEGINNING;
            public static final /* enum */ State MIDDLE;
            public static final /* enum */ State AFTER_DOT;
            private static final /* synthetic */ State[] $VALUES;

            static {
                $kotlinClass = InternalPackage.kClassFromKotlin(State.class);
                State[] stateArray = new State[3];
                State[] stateArray2 = stateArray;
                stateArray[0] = BEGINNING = new State();
                stateArray[1] = MIDDLE = new State();
                stateArray[2] = AFTER_DOT = new State();
                $VALUES = stateArray;
            }

            protected State() {
                super($enum_name_or_ordinal$0, $enum_name_or_ordinal$1);
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }
        }
        State state = State.BEGINNING;
        CharIterator charIterator = KotlinPackage.iterator(qualifiedName);
        block4: while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            switch (NamePackage-FqNamesUtil-f4b71e84$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierPart(c)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    break;
                }
                case 3: {
                    if (c == '.') {
                        state = State.AFTER_DOT;
                        break;
                    }
                    if (!(!Character.isJavaIdentifierPart(c))) continue block4;
                    return false;
                }
            }
        }
        return Intrinsics.areEqual(state, State.AFTER_DOT) ^ true;
    }

    @NotNull
    public static final Name getFirstSegment(@JetValueParameter(name="$receiver") FqName $receiver) {
        List<Name> list = $receiver.pathSegments();
        Intrinsics.checkReturnedValueIsNotNull(list, "FqName", "pathSegments");
        Name name = KotlinPackage.first(list);
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "getFirstSegment"));
        }
        return name;
    }

    @tailRecursive
    public static final void each(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="operation") @NotNull Function1<? super FqName, ? extends Boolean> operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "each"));
        }
        while (true) {
            Intrinsics.checkParameterIsNotNull(operation, "operation");
            boolean bl = operation.invoke($receiver).booleanValue() ? !$receiver.isRoot() : false;
            if (!bl) break;
            Intrinsics.checkReturnedValueIsNotNull($receiver.parent(), "FqName", "parent");
        }
    }

    public static final boolean isSubpackageOf(@JetValueParameter(name="subpackageNameStr") @NotNull String subpackageNameStr, @JetValueParameter(name="packageNameStr") @NotNull String packageNameStr) {
        if (subpackageNameStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subpackageNameStr", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isSubpackageOf"));
        }
        if (packageNameStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNameStr", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isSubpackageOf"));
        }
        Intrinsics.checkParameterIsNotNull(subpackageNameStr, "subpackageNameStr");
        Intrinsics.checkParameterIsNotNull(packageNameStr, "packageNameStr");
        return !Intrinsics.areEqual(subpackageNameStr, packageNameStr) ? (KotlinPackage.startsWith(subpackageNameStr, packageNameStr) ? subpackageNameStr.charAt(KotlinPackage.length(packageNameStr)) == '.' : false) : true;
    }

    @NotNull
    public static final String getFirstSegment(@JetValueParameter(name="fqn") @NotNull String fqn) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "getFirstSegment"));
        }
        Intrinsics.checkParameterIsNotNull(fqn, "fqn");
        int dotIndex = KotlinPackage.indexOf(fqn, '.');
        String string = dotIndex != -1 ? KotlinPackage.substring(fqn, 0, dotIndex) : fqn;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "getFirstSegment"));
        }
        return string;
    }
}

