/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.ClassDataFinder;
import org.jetbrains.jet.descriptors.serialization.ClassDeserializer;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.NameSerializationUtil;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.context.DeserializationContext;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationLoader;
import org.jetbrains.jet.descriptors.serialization.descriptors.ConstantLoader;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.impl.PackageFragmentDescriptorImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.lang.BuiltInsSerializationUtil;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.StorageManager;

class BuiltinsPackageFragment
extends PackageFragmentDescriptorImpl {
    private final DeserializedPackageMemberScope members;
    private final NameResolver nameResolver;
    private final PackageFragmentProvider packageFragmentProvider;

    public BuiltinsPackageFragment(@NotNull StorageManager storageManager, @NotNull ModuleDescriptor module) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "<init>"));
        }
        super(module, KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME);
        this.nameResolver = NameSerializationUtil.deserializeNameResolver(BuiltinsPackageFragment.getStream(BuiltInsSerializationUtil.getNameTableFilePath(this.getFqName())));
        this.packageFragmentProvider = new BuiltinsPackageFragmentProvider();
        Function0<Collection<Name>> classNames = new Function0<Collection<Name>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            @NotNull
            public Collection<Name> invoke() {
                InputStream in = BuiltinsPackageFragment.getStream(BuiltInsSerializationUtil.getClassNamesFilePath(BuiltinsPackageFragment.this.getFqName()));
                DataInputStream data2 = new DataInputStream(in);
                int size = data2.readInt();
                ArrayList<Name> result2 = new ArrayList<Name>(size);
                for (int i = 0; i < size; ++i) {
                    result2.add(BuiltinsPackageFragment.this.nameResolver.getName(data2.readInt()));
                }
                ArrayList<Name> arrayList = result2;
                data2.close();
                ArrayList<Name> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$1", "invoke"));
                }
                return arrayList2;
                {
                    catch (Throwable throwable) {
                        try {
                            data2.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
            }
        };
        BuiltInsClassDataFinder builtInsClassDataFinder = new BuiltInsClassDataFinder();
        DeserializationContext deserializationContext = new DeserializationContext(storageManager, module, (ClassDataFinder)builtInsClassDataFinder, AnnotationLoader.UNSUPPORTED, ConstantLoader.UNSUPPORTED, this.packageFragmentProvider, new ClassDeserializer(storageManager, builtInsClassDataFinder), this.nameResolver);
        this.members = new DeserializedPackageMemberScope((PackageFragmentDescriptor)this, this.loadPackage(), deserializationContext, classNames);
    }

    @NotNull
    private ProtoBuf.Package loadPackage() {
        ProtoBuf.Package package_;
        String packageFilePath = BuiltInsSerializationUtil.getPackageFilePath(this.getFqName());
        InputStream stream2 = BuiltinsPackageFragment.getStream(packageFilePath);
        try {
            package_ = ProtoBuf.Package.parseFrom(stream2);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (package_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "loadPackage"));
        }
        return package_;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        DeserializedPackageMemberScope deserializedPackageMemberScope = this.members;
        if (deserializedPackageMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getMemberScope"));
        }
        return deserializedPackageMemberScope;
    }

    @NotNull
    public PackageFragmentProvider getProvider() {
        PackageFragmentProvider packageFragmentProvider = this.packageFragmentProvider;
        if (packageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getProvider"));
        }
        return packageFragmentProvider;
    }

    @NotNull
    private static InputStream getStream(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getStream"));
        }
        InputStream stream2 = BuiltinsPackageFragment.getStreamNullable(path);
        if (stream2 == null) {
            throw new IllegalStateException("Resource not found in classpath: " + path);
        }
        InputStream inputStream = stream2;
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getStream"));
        }
        return inputStream;
    }

    @Nullable
    private static InputStream getStreamNullable(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getStreamNullable"));
        }
        return KotlinBuiltIns.class.getClassLoader().getResourceAsStream(path);
    }

    private class BuiltInsClassDataFinder
    implements ClassDataFinder {
        private BuiltInsClassDataFinder() {
        }

        @Override
        @Nullable
        public ClassData findClassData(@NotNull ClassId classId) {
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltInsClassDataFinder", "findClassData"));
            }
            InputStream stream2 = BuiltinsPackageFragment.getStreamNullable(BuiltInsSerializationUtil.getClassMetadataPath(classId));
            if (stream2 == null) {
                return null;
            }
            try {
                ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(stream2);
                Name expectedShortName = classId.getRelativeClassName().shortName();
                Name actualShortName = BuiltinsPackageFragment.this.nameResolver.getClassId(classProto.getFqName()).getRelativeClassName().shortName();
                if (!actualShortName.isSpecial() && !actualShortName.equals(expectedShortName)) {
                    return null;
                }
                return new ClassData(BuiltinsPackageFragment.this.nameResolver, classProto);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private class BuiltinsPackageFragmentProvider
    implements PackageFragmentProvider {
        private BuiltinsPackageFragmentProvider() {
        }

        @Override
        @NotNull
        public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName) {
            if (fqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getPackageFragments"));
            }
            if (KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.equals(fqName)) {
                List<PackageFragmentDescriptor> list = Collections.singletonList(BuiltinsPackageFragment.this);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getPackageFragments"));
                }
                return list;
            }
            List<PackageFragmentDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getPackageFragments"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName) {
            if (fqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getSubPackagesOf"));
            }
            if (fqName.isRoot()) {
                Set<FqName> set = Collections.singleton(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getSubPackagesOf"));
                }
                return set;
            }
            List<FqName> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getSubPackagesOf"));
            }
            return list;
        }
    }
}

