/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.analyze;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.context.ContextPackage;
import org.jetbrains.jet.context.GlobalContextImpl;
import org.jetbrains.jet.di.InjectorForLazyResolve;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJs;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProviderFactoryService;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.k2js.config.Config;

public final class AnalyzerFacadeForJS {
    public static final List<ImportPath> DEFAULT_IMPORTS = ImmutableList.of(new ImportPath("js.*"), new ImportPath("java.lang.*"), new ImportPath("kotlin.*"));

    private AnalyzerFacadeForJS() {
    }

    @NotNull
    public static BindingContext analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        BindingContext bindingContext = AnalyzerFacadeForJS.analyzeFiles(files, Predicates.<PsiFile>alwaysTrue(), config).getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        return bindingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static AnalyzeExhaust analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        Project project = config.getProject();
        ModuleDescriptorImpl owner = AnalyzerFacadeForJS.createJsModule("<module>");
        Predicate<PsiFile> completely = Predicates.and(AnalyzerFacadeForJS.notLibFiles(config.getLibFiles()), filesToAnalyzeCompletely);
        GlobalContextImpl globalContext = ContextPackage.GlobalContext();
        TopDownAnalysisParameters topDownAnalysisParameters = TopDownAnalysisParameters.create(globalContext.getStorageManager(), globalContext.getExceptionTracker(), completely, false, false);
        owner.addDependencyOnModule(owner);
        owner.addDependencyOnModule(KotlinBuiltIns.getInstance().getBuiltInsModule());
        ModuleDescriptor libraryModule = config.getLibraryModule();
        if (libraryModule != null) {
            owner.addDependencyOnModule((ModuleDescriptorImpl)libraryModule);
        }
        owner.seal();
        BindingContext libraryContext = config.getLibraryContext();
        BindingTrace trace = libraryContext == null ? new BindingTraceContext() : new DelegatingBindingTrace(libraryContext, "trace with preanalyzed library");
        InjectorForTopDownAnalyzerForJs injector = new InjectorForTopDownAnalyzerForJs(project, topDownAnalysisParameters, trace, owner);
        Collection<JetFile> allFiles = libraryModule != null ? files : Config.withJsLibAdded(files, config);
        injector.getTopDownAnalyzer().analyzeFiles(topDownAnalysisParameters, allFiles, new PackageFragmentProvider[0]);
        AnalyzeExhaust analyzeExhaust = AnalyzeExhaust.success(trace.getBindingContext(), owner);
        AnalyzeExhaust analyzeExhaust2 = analyzeExhaust;
        if (analyzeExhaust2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        return analyzeExhaust2;
        finally {
            injector.destroy();
        }
    }

    public static void checkForErrors(@NotNull Collection<JetFile> allFiles, @NotNull BindingContext bindingContext) {
        if (allFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFiles", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "checkForErrors"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "checkForErrors"));
        }
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        for (JetFile file : allFiles) {
            AnalyzingUtils.checkForSyntacticErrors(file);
        }
    }

    @NotNull
    private static Predicate<PsiFile> notLibFiles(final @NotNull List<JetFile> jsLibFiles) {
        if (jsLibFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsLibFiles", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "notLibFiles"));
        }
        Predicate<PsiFile> predicate = new Predicate<PsiFile>(){

            @Override
            public boolean apply(@Nullable PsiFile file) {
                assert (file instanceof JetFile);
                boolean notLibFile = !jsLibFiles.contains(file);
                return notLibFile;
            }
        };
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "notLibFiles"));
        }
        return predicate;
    }

    @NotNull
    public static ResolveSession getLazyResolveSession(@NotNull Collection<JetFile> syntheticFiles, @NotNull GlobalSearchScope filesScope, @NotNull Config config) {
        if (syntheticFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticFiles", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "getLazyResolveSession"));
        }
        if (filesScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesScope", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "getLazyResolveSession"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "getLazyResolveSession"));
        }
        GlobalContextImpl globalContext = ContextPackage.GlobalContext();
        DeclarationProviderFactory declarationProviderFactory = DeclarationProviderFactoryService.OBJECT$.createDeclarationProviderFactory(config.getProject(), globalContext.getStorageManager(), Config.withJsLibAdded(syntheticFiles, config), filesScope);
        ModuleDescriptorImpl module = AnalyzerFacadeForJS.createJsModule("<lazy module>");
        module.addDependencyOnModule(module);
        module.addDependencyOnModule(KotlinBuiltIns.getInstance().getBuiltInsModule());
        module.seal();
        ResolveSession session = new InjectorForLazyResolve(config.getProject(), globalContext, module, declarationProviderFactory, new BindingTraceContext()).getResolveSession();
        module.initialize(session.getPackageFragmentProvider());
        ResolveSession resolveSession = session;
        if (resolveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "getLazyResolveSession"));
        }
        return resolveSession;
    }

    @NotNull
    private static ModuleDescriptorImpl createJsModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "createJsModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), DEFAULT_IMPORTS, PlatformToKotlinClassMap.EMPTY);
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "createJsModule"));
        }
        return moduleDescriptorImpl;
    }
}

