/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.callTranslator;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.test.TestPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.k2js.translate.callTranslator.CallTranslator;
import org.jetbrains.k2js.translate.callTranslator.CallTranslatorPackage$computeExplicitReceiversForInvoke$1;
import org.jetbrains.k2js.translate.callTranslator.CallTranslatorPackage-CallInfo-10069683;
import org.jetbrains.k2js.translate.callTranslator.CallTranslatorPackage-FunctionCallCases-db1352;
import org.jetbrains.k2js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.k2js.translate.context.TranslationContext;

@KotlinSyntheticClass(abiVersion=17, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class CallTranslatorPackage-CallTranslator-2b34ee17 {
    public static final boolean expectedReceivers(@JetValueParameter(name="$receiver") ResolvedCall<? extends CallableDescriptor> $receiver) {
        ExplicitReceiverKind explicitReceiverKind = $receiver.getExplicitReceiverKind();
        Intrinsics.checkReturnedValueIsNotNull((Object)explicitReceiverKind, "ResolvedCall", "getExplicitReceiverKind");
        return Intrinsics.areEqual((Object)explicitReceiverKind, (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) ^ true;
    }

    @NotNull
    public static final JsExpression translateCall(@JetValueParameter(name="context") @NotNull TranslationContext context, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateCall"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateCall"));
        }
        if (explicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceivers", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateCall"));
        }
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            KotlinPackage.assert(explicitReceivers.getReceiverObject() == null, "VariableAsFunctionResolvedCall must have one receiver");
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall();
            if (CallTranslatorPackage-CallTranslator-2b34ee17.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE$.translateGet(context, variableCall, explicitReceivers.getReceiverOrThisObject());
                JsExpression jsExpression = CallTranslatorPackage-CallTranslator-2b34ee17.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(newReceiver, null, 2));
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateCall"));
                }
                return jsExpression;
            }
            JsExpression thisObject = CallTranslator.INSTANCE$.translateGet(context, variableCall, null);
            if (explicitReceivers.getReceiverOrThisObject() == null) {
                JsExpression jsExpression = CallTranslatorPackage-CallTranslator-2b34ee17.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(thisObject, null, 2));
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateCall"));
                }
                return jsExpression;
            }
            JsExpression jsExpression = CallTranslatorPackage-CallTranslator-2b34ee17.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(thisObject, explicitReceivers.getReceiverOrThisObject()));
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateCall"));
            }
            return jsExpression;
        }
        Call call = resolvedCall.getCall();
        Intrinsics.checkReturnedValueIsNotNull(call, "ResolvedCall", "getCall");
        Call call2 = call;
        Call.CallType callType = call2.getCallType();
        Intrinsics.checkReturnedValueIsNotNull((Object)callType, "Call", "getCallType");
        boolean bl = Intrinsics.areEqual((Object)callType, (Object)Call.CallType.INVOKE) ? !CallResolverUtil.isInvokeCallOnVariable(call2) : false;
        if (bl) {
            ExplicitReceivers explicitReceiversForInvoke = CallTranslatorPackage-CallTranslator-2b34ee17.computeExplicitReceiversForInvoke(context, resolvedCall, explicitReceivers);
            JsExpression jsExpression = CallTranslatorPackage-CallTranslator-2b34ee17.translateFunctionCall(context, resolvedCall, explicitReceiversForInvoke);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateCall"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = CallTranslatorPackage-CallTranslator-2b34ee17.translateFunctionCall(context, resolvedCall, explicitReceivers);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateCall"));
        }
        return jsExpression;
    }

    @NotNull
    public static final JsExpression translateFunctionCall(@JetValueParameter(name="context") @NotNull TranslationContext context, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateFunctionCall"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateFunctionCall"));
        }
        if (explicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceivers", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateFunctionCall"));
        }
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        JsExpression jsExpression = CallTranslatorPackage-FunctionCallCases-db1352.translateFunctionCall(CallTranslatorPackage-CallInfo-10069683.getCallInfo(context, resolvedCall, explicitReceivers));
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "translateFunctionCall"));
        }
        return jsExpression;
    }

    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@JetValueParameter(name="context") @NotNull TranslationContext context, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "computeExplicitReceiversForInvoke"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "computeExplicitReceiversForInvoke"));
        }
        if (explicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceivers", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "computeExplicitReceiversForInvoke"));
        }
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        Call call = resolvedCall.getCall();
        Intrinsics.checkReturnedValueIsNotNull(call, "ResolvedCall", "getCall");
        JetElement jetElement = call.getCallElement();
        Intrinsics.checkReturnedValueIsNotNull(jetElement, "Call", "getCallElement");
        JetElement callElement = jetElement;
        KotlinPackage.assert(explicitReceivers.getReceiverObject() == null, "'Invoke' call must have one receiver: " + callElement);
        CallTranslatorPackage$computeExplicitReceiversForInvoke$1 callTranslatorPackage$computeExplicitReceiversForInvoke$1 = new CallTranslatorPackage$computeExplicitReceiversForInvoke$1(context);
        ReceiverValue receiverValue = resolvedCall.getThisObject();
        Intrinsics.checkReturnedValueIsNotNull(receiverValue, "ResolvedCall", "getThisObject");
        ReceiverValue thisObject = receiverValue;
        ReceiverValue receiverValue2 = resolvedCall.getReceiverArgument();
        Intrinsics.checkReturnedValueIsNotNull(receiverValue2, "ResolvedCall", "getReceiverArgument");
        ReceiverValue receiverArgument2 = receiverValue2;
        if (thisObject.exists() ? receiverArgument2.exists() : false) {
            TestPackage.assertNotNull(explicitReceivers.getReceiverOrThisObject(), "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement);
        } else {
            KotlinPackage.assert(explicitReceivers.getReceiverOrThisObject() == null, "Non trivial explicit receiver " + explicitReceivers.getReceiverOrThisObject() + "\n" + " for 'invoke' resolved call: " + callElement + "\n" + ("This object: " + thisObject + " Receiver argument: " + receiverArgument2));
        }
        JsExpression thisObjectExpression = callTranslatorPackage$computeExplicitReceiversForInvoke$1.invoke(thisObject);
        Pair<Boolean, Boolean> pair = new Pair<Boolean, Boolean>(thisObject.exists(), receiverArgument2.exists());
        if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, true))) {
            explicitReceivers2 = new ExplicitReceivers(thisObjectExpression, explicitReceivers.getReceiverOrThisObject());
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, false))) {
            explicitReceivers2 = new ExplicitReceivers(thisObjectExpression, null, 2);
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(false, true))) {
            explicitReceivers2 = new ExplicitReceivers(callTranslatorPackage$computeExplicitReceiversForInvoke$1.invoke(receiverArgument2), null, 2);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("'Invoke' resolved call without receivers: " + callElement)));
        }
        if (explicitReceivers2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-2b34ee17", "computeExplicitReceiversForInvoke"));
        }
        return explicitReceivers2;
    }
}

