/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.initializer;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.DelegationTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.initializer.InitializerVisitor;
import org.jetbrains.k2js.translate.reference.CallArgumentTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class ClassInitializerTranslator
extends AbstractTranslator {
    @NotNull
    private final JetClassOrObject classDeclaration;
    @NotNull
    private final List<JsStatement> initializerStatements;

    public ClassInitializerTranslator(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "<init>"));
        }
        super(context.newDeclaration(BindingUtils.getConstructor(context.bindingContext(), classDeclaration), null));
        this.initializerStatements = new SmartList<JsStatement>();
        this.classDeclaration = classDeclaration;
    }

    @NotNull
    public JsFunction generateInitializeMethod(DelegationTranslator delegationTranslator) {
        ConstructorDescriptor primaryConstructor = BindingUtils.getConstructor(this.bindingContext(), this.classDeclaration);
        JsFunction result2 = this.context().getFunctionObject(primaryConstructor);
        result2.getParameters().addAll(this.translatePrimaryConstructorParameters());
        this.mayBeAddCallToSuperMethod(result2);
        delegationTranslator.addInitCode(this.initializerStatements);
        new InitializerVisitor(this.initializerStatements).traverseContainer(this.classDeclaration, this.context());
        List<JsStatement> statements = result2.getBody().getStatements();
        statements.addAll(FunctionBodyTranslator.setDefaultValueForArguments(primaryConstructor, this.context()));
        for (JsStatement statement : this.initializerStatements) {
            if (statement instanceof JsBlock) {
                statements.addAll(((JsBlock)statement).getStatements());
                continue;
            }
            statements.add(statement);
        }
        JsFunction jsFunction = result2;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "generateInitializeMethod"));
        }
        return jsFunction;
    }

    @NotNull
    public JsExpression generateEnumEntryInstanceCreation(@NotNull JetType enumClassType) {
        if (enumClassType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassType", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
        }
        JetDelegatorToSuperCall superCall = this.getSuperCall();
        List<JsExpression> arguments = superCall != null ? this.translateArguments(superCall) : Collections.emptyList();
        JsNameRef reference = this.context().getQualifiedReference(DescriptorUtils.getClassDescriptorForType(enumClassType));
        JsNew jsNew = new JsNew(reference, arguments);
        if (jsNew == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
        }
        return jsNew;
    }

    private void mayBeAddCallToSuperMethod(JsFunction initializer) {
        if (this.classDeclaration.hasModifier(JetTokens.ENUM_KEYWORD)) {
            this.addCallToSuperMethod(Collections.<JsExpression>emptyList(), initializer);
            return;
        }
        if (BindingUtils.hasAncestorClass(this.bindingContext(), this.classDeclaration)) {
            JetDelegatorToSuperCall superCall = this.getSuperCall();
            if (superCall == null) {
                return;
            }
            this.addCallToSuperMethod(this.translateArguments(superCall), initializer);
        }
    }

    private void addCallToSuperMethod(@NotNull List<JsExpression> arguments, JsFunction initializer) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "addCallToSuperMethod"));
        }
        JsName ref = this.context().scope().declareName("$fun");
        initializer.setName(ref);
        JsInvocation call = new JsInvocation(Namer.getFunctionCallRef(Namer.superMethodNameRef(ref)));
        call.getArguments().add(JsLiteral.THIS);
        call.getArguments().addAll(arguments);
        this.initializerStatements.add(0, call.makeStmt());
    }

    @NotNull
    private List<JsExpression> translateArguments(@NotNull JetDelegatorToSuperCall superCall) {
        if (superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCall", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "translateArguments"));
        }
        ResolvedCall<? extends CallableDescriptor> call = CallUtilPackage.getResolvedCallWithAssert(superCall, this.context().bindingContext());
        List<JsExpression> list = CallArgumentTranslator.translate(call, null, this.context()).getTranslateArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "translateArguments"));
        }
        return list;
    }

    @Nullable
    private JetDelegatorToSuperCall getSuperCall() {
        JetDelegatorToSuperCall result2 = null;
        for (JetDelegationSpecifier specifier : this.classDeclaration.getDelegationSpecifiers()) {
            if (!(specifier instanceof JetDelegatorToSuperCall)) continue;
            result2 = (JetDelegatorToSuperCall)specifier;
        }
        return result2;
    }

    @NotNull
    List<JsParameter> translatePrimaryConstructorParameters() {
        List<JetParameter> parameterList = PsiUtils.getPrimaryConstructorParameters(this.classDeclaration);
        ArrayList<JsParameter> result2 = new ArrayList<JsParameter>();
        for (JetParameter jetParameter : parameterList) {
            result2.add(this.translateParameter(jetParameter));
        }
        ArrayList<JsParameter> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "translatePrimaryConstructorParameters"));
        }
        return arrayList;
    }

    @NotNull
    private JsParameter translateParameter(@NotNull JetParameter jetParameter) {
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "translateParameter"));
        }
        DeclarationDescriptor parameterDescriptor = BindingUtils.getDescriptorForElement(this.bindingContext(), jetParameter);
        JsName parameterName = this.context().getNameForDescriptor(parameterDescriptor);
        JsParameter jsParameter = new JsParameter(parameterName);
        this.mayBeAddInitializerStatementForProperty(jsParameter, jetParameter);
        JsParameter jsParameter2 = jsParameter;
        if (jsParameter2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "translateParameter"));
        }
        return jsParameter2;
    }

    private void mayBeAddInitializerStatementForProperty(@NotNull JsParameter jsParameter, @NotNull JetParameter jetParameter) {
        if (jsParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsParameter", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "mayBeAddInitializerStatementForProperty"));
        }
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "mayBeAddInitializerStatementForProperty"));
        }
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), jetParameter);
        if (propertyDescriptor == null) {
            return;
        }
        JsNameRef initialValueForProperty = jsParameter.getName().makeRef();
        this.addInitializerOrPropertyDefinition(initialValueForProperty, propertyDescriptor);
    }

    private void addInitializerOrPropertyDefinition(@NotNull JsNameRef initialValue, @NotNull PropertyDescriptor propertyDescriptor) {
        if (initialValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialValue", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "addInitializerOrPropertyDefinition"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/k2js/translate/initializer/ClassInitializerTranslator", "addInitializerOrPropertyDefinition"));
        }
        this.initializerStatements.add(InitializerUtils.generateInitializerForProperty(this.context(), propertyDescriptor, initialValue));
    }
}

