/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    @NonNls
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    @NonNls
    private static String ourHomePath;
    @NonNls
    private static String ourSystemPath;
    @NonNls
    private static String ourConfigPath;
    @NonNls
    private static String ourPluginsPath;

    @NotNull
    public static String getHomePath() {
        if (ourHomePath != null) {
            String string = ourHomePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getHomePath"));
            }
            return string;
        }
        String fromProperty = System.getProperty("idea.home.path");
        if (fromProperty != null) {
            ourHomePath = PathManager.getAbsolutePath(fromProperty);
            if (!new File(ourHomePath).isDirectory()) {
                throw new RuntimeException("Invalid home path '" + ourHomePath + "'");
            }
        } else {
            ourHomePath = PathManager.getHomePathFor(PathManager.class);
            if (ourHomePath == null) {
                String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
        }
        if (SystemInfo.isWindows) {
            try {
                ourHomePath = new File(ourHomePath).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = ourHomePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getHomePath"));
        }
        return string;
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class aClass) {
        String parent;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/application/PathManager", "getHomePathFor"));
        }
        String rootPath = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        if (rootPath == null) {
            return null;
        }
        File root = new File(rootPath).getAbsoluteFile();
        do {
            if ((parent = root.getParent()) != null) continue;
            return null;
        } while (!PathManager.isIdeaHome(root = new File(parent).getAbsoluteFile()));
        return root.getAbsolutePath();
    }

    private static boolean isIdeaHome(File root) {
        return new File(root, FileUtil.toSystemDependentName("bin/idea.properties")).exists() || new File(root, FileUtil.toSystemDependentName("community/bin/idea.properties")).exists();
    }

    @NotNull
    public static String getBinPath() {
        String string = PathManager.getHomePath() + File.separator + "bin";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getBinPath"));
        }
        return string;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getHomePath() + File.separatorChar + "plugins";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPreInstalledPluginsPath"));
        }
        return string;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string = ourConfigPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getConfigPath"));
            }
            return string;
        }
        ourConfigPath = System.getProperty("idea.config.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.config.path"))) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + "config");
        String string = ourConfigPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getConfigPath"));
        }
        return string;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/openapi/application/PathManager", "getDefaultConfigPathFor"));
        }
        String string = PathManager.platformPath(selector, "Library/Preferences", "config");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getDefaultConfigPathFor"));
        }
        return string;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string = ourPluginsPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPluginsPath"));
            }
            return string;
        }
        ourPluginsPath = System.getProperty("idea.plugins.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.plugins.path"))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? SystemProperties.getUserHome() + File.separator + "Library/Application Support" + File.separator + PATHS_SELECTOR : PathManager.getConfigPath() + File.separatorChar + "plugins");
        String string = ourPluginsPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPluginsPath"));
        }
        return string;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string = ourSystemPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getSystemPath"));
            }
            return string;
        }
        ourSystemPath = System.getProperty("idea.system.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.system.path"))) : (PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Caches", "system") : PathManager.getHomePath() + File.separator + "system");
        PathManager.checkAndCreate(ourSystemPath, true);
        String string = ourSystemPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getSystemPath"));
        }
        return string;
    }

    @NotNull
    public static File getIndexRoot() {
        String indexRoot = System.getProperty("index_root_path", PathManager.getSystemPath() + "/index");
        PathManager.checkAndCreate(indexRoot, true);
        File file = new File(indexRoot);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getIndexRoot"));
        }
        return file;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class context2, @NonNls String path) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/application/PathManager", "getResourceRoot"));
        }
        URL url = context2.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    @NonNls
    private static String extractRoot(URL resourceURL, String resourcePath) {
        Pair<String, String> paths;
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            System.err.println("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = resourceURL.getFile();
            String testPath = path.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol) && (paths = URLUtil.splitJarUrl(resourceURL.getFile())) != null) {
            resultPath = (String)paths.first;
        }
        if (resultPath == null) {
            System.err.println("cannot extract: " + resourcePath + " from " + resourceURL);
            return null;
        }
        resultPath = StringUtil.trimEnd(resultPath, File.separator);
        resultPath = URLUtil.unescapePercentSequences(resultPath);
        return resultPath;
    }

    private static String getAbsolutePath(String path) {
        path = FileUtil.expandUserHome(path);
        return FileUtil.toCanonicalPath(new File(path).getAbsolutePath());
    }

    private static String trimPathQuotes(String path) {
        if (path == null || path.length() < 3) {
            return path;
        }
        if (StringUtil.startsWithChar(path, '\"') && StringUtil.endsWithChar(path, '\"')) {
            return path.substring(1, path.length() - 1);
        }
        return path;
    }

    private static String platformPath(String selector, String macDir, String fallback) {
        if (SystemInfo.isMac) {
            return SystemProperties.getUserHome() + File.separator + macDir + File.separator + selector;
        }
        return SystemProperties.getUserHome() + File.separator + "." + selector + File.separator + fallback;
    }

    private static boolean checkAndCreate(String path, boolean createIfNotExists) {
        File file;
        if (createIfNotExists && !(file = new File(path)).exists()) {
            return file.mkdirs();
        }
        return false;
    }
}

