/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.PackageContext;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.codeFragmentUtil.CodeFragmentUtilPackage;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileKotlinClass;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.jet.lang.types.JetType;

public class JvmCodegenUtil {
    private JvmCodegenUtil() {
    }

    public static boolean isInterface(DeclarationDescriptor descriptor) {
        if (descriptor instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor).getKind();
            return kind == ClassKind.TRAIT || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isInterface(JetType type) {
        return JvmCodegenUtil.isInterface(type.getConstructor().getDeclarationDescriptor());
    }

    public static boolean isConst(@NotNull CalculatedClosure closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isConst"));
        }
        return closure.getCaptureThis() == null && closure.getCaptureReceiverType() == null && closure.getCaptureVariables().isEmpty();
    }

    private static boolean isCallInsideSameClassAsDeclared(@NotNull CallableMemberDescriptor descriptor, @NotNull CodegenContext context2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isCallInsideSameClassAsDeclared"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isCallInsideSameClassAsDeclared"));
        }
        boolean isFakeOverride = descriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean isDelegate = descriptor.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration().getOriginal();
        return !isFakeOverride && !isDelegate && (context2.hasThisDescriptor() && containingDeclaration == context2.getThisDescriptor() || context2.getParentContext() instanceof PackageContext && JvmCodegenUtil.isSamePackageInSameModule(context2.getParentContext().getContextDescriptor(), containingDeclaration)) && context2.getContextKind() != OwnerKind.TRAIT_IMPL;
    }

    private static boolean isSamePackageInSameModule(@NotNull DeclarationDescriptor callerOwner, @NotNull DeclarationDescriptor calleeOwner) {
        if (callerOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callerOwner", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isSamePackageInSameModule"));
        }
        if (calleeOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeOwner", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isSamePackageInSameModule"));
        }
        if (callerOwner instanceof PackageFragmentDescriptor && calleeOwner instanceof PackageFragmentDescriptor) {
            PackageFragmentDescriptor callerFragment = (PackageFragmentDescriptor)callerOwner;
            PackageFragmentDescriptor calleeFragment = (PackageFragmentDescriptor)calleeOwner;
            if (callerFragment == calleeFragment) {
                return true;
            }
            return callerFragment.getFqName().equals(calleeFragment.getFqName()) && calleeFragment instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment;
        }
        return false;
    }

    public static boolean isCallInsideSameModuleAsDeclared(@NotNull CallableMemberDescriptor declarationDescriptor, @NotNull CodegenContext context2, @Nullable File outDirectory) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isCallInsideSameModuleAsDeclared"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isCallInsideSameModuleAsDeclared"));
        }
        if (context2 == CodegenContext.STATIC) {
            return true;
        }
        Object contextDescriptor = context2.getContextDescriptor();
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(declarationDescriptor);
        if (directMember instanceof DeserializedCallableMemberDescriptor) {
            return JvmCodegenUtil.isContainedByCompiledPartOfOurModule((DeserializedCallableMemberDescriptor)directMember, outDirectory);
        }
        return DescriptorUtils.areInSameModule(directMember, contextDescriptor);
    }

    private static boolean isContainedByCompiledPartOfOurModule(@NotNull DeserializedCallableMemberDescriptor descriptor, @Nullable File outDirectory) {
        VirtualFile file;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isContainedByCompiledPartOfOurModule"));
        }
        DeclarationDescriptor packageFragment = descriptor.getContainingDeclaration();
        if (packageFragment instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment) {
            return true;
        }
        if (outDirectory == null) {
            return false;
        }
        if (!(packageFragment instanceof LazyJavaPackageFragment)) {
            return false;
        }
        KotlinJvmBinaryClass binaryClass = ((LazyJavaPackageFragment)packageFragment).getMemberScope().getKotlinBinaryClass();
        if (binaryClass instanceof VirtualFileKotlinClass && (file = ((VirtualFileKotlinClass)binaryClass).getFile()).getFileSystem().getProtocol() == "file") {
            File ioFile = VfsUtilCore.virtualToIoFile(file);
            return ioFile.getAbsolutePath().startsWith(outDirectory.getAbsolutePath() + File.separator);
        }
        return false;
    }

    public static boolean hasAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "hasAbstractMembers"));
        }
        return KotlinPackage.any(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors(), new Function1<DeclarationDescriptor, Boolean>(){

            @Override
            public Boolean invoke(DeclarationDescriptor descriptor) {
                return descriptor instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor).getModality() == Modality.ABSTRACT;
            }
        });
    }

    public static boolean couldUseDirectAccessToProperty(@NotNull PropertyDescriptor property2, boolean forGetter, boolean isDelegated, @NotNull MethodContext context2) {
        PropertyAccessorDescriptor accessor;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/codegen/JvmCodegenUtil", "couldUseDirectAccessToProperty"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/JvmCodegenUtil", "couldUseDirectAccessToProperty"));
        }
        if (JetTypeMapper.isAccessor(property2)) {
            return false;
        }
        if (context2.isInlineFunction()) {
            return false;
        }
        if (!JvmCodegenUtil.isCallInsideSameClassAsDeclared(property2, context2) && !JvmCodegenUtil.isDebuggerContext(context2)) {
            return false;
        }
        if (isDelegated || property2.getExtensionReceiverParameter() != null) {
            return false;
        }
        if (DescriptorUtils.isClassObject(property2.getContainingDeclaration())) {
            return false;
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = forGetter ? property2.getGetter() : property2.getSetter();
        if (accessor == null) {
            return true;
        }
        if (accessor.hasBody()) {
            return false;
        }
        return property2.getVisibility() == Visibilities.PRIVATE || accessor.getModality() == Modality.FINAL;
    }

    private static boolean isDebuggerContext(@NotNull MethodContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isDebuggerContext"));
        }
        JetFile file = DescriptorToSourceUtils.getContainingFile(context2.getContextDescriptor());
        return file != null && CodeFragmentUtilPackage.getSkipVisibilityCheck(file);
    }

    @NotNull
    public static ImplementationBodyCodegen getParentBodyCodegen(@Nullable MemberCodegen<?> classBodyCodegen) {
        assert (classBodyCodegen != null && classBodyCodegen.getParentCodegen() instanceof ImplementationBodyCodegen) : "Class object should have appropriate parent BodyCodegen";
        ImplementationBodyCodegen implementationBodyCodegen = (ImplementationBodyCodegen)classBodyCodegen.getParentCodegen();
        if (implementationBodyCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getParentBodyCodegen"));
        }
        return implementationBodyCodegen;
    }

    @Nullable
    public static ClassDescriptor getDispatchReceiverParameterForConstructorCall(@NotNull ConstructorDescriptor descriptor, @Nullable CalculatedClosure closure) {
        ClassDescriptor expectedThisClass;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDispatchReceiverParameterForConstructorCall"));
        }
        if (closure != null) {
            return closure.getCaptureThis();
        }
        ReceiverParameterDescriptor dispatchReceiver = descriptor.getDispatchReceiverParameter();
        if (dispatchReceiver != null && !(expectedThisClass = (ClassDescriptor)dispatchReceiver.getContainingDeclaration()).getKind().isSingleton()) {
            return expectedThisClass;
        }
        return null;
    }

    @NotNull
    public static CallableMemberDescriptor getDirectMember(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDirectMember"));
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty() : descriptor;
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDirectMember"));
        }
        return callableMemberDescriptor;
    }
}

