/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.binding;

import com.intellij.openapi.util.Pair;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.org.objectweb.asm.Type;

public final class MutableClosure
implements CalculatedClosure {
    private final ResolvedCall<ConstructorDescriptor> superCall;
    private final ClassDescriptor enclosingClass;
    private final CallableDescriptor enclosingFunWithReceiverDescriptor;
    private boolean captureThis;
    private boolean captureReceiver;
    private Map<DeclarationDescriptor, EnclosedValueDescriptor> captureVariables;
    private List<Pair<String, Type>> recordedFields;

    MutableClosure(@NotNull ClassDescriptor classDescriptor, @Nullable ResolvedCall<ConstructorDescriptor> superCall, @Nullable ClassDescriptor enclosingClass) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/binding/MutableClosure", "<init>"));
        }
        this.enclosingClass = enclosingClass;
        this.superCall = superCall;
        this.enclosingFunWithReceiverDescriptor = MutableClosure.enclosingExtensionMemberForClass(classDescriptor);
    }

    @Nullable
    private static CallableDescriptor enclosingExtensionMemberForClass(@NotNull ClassDescriptor classDescriptor) {
        CallableMemberDescriptor member;
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/binding/MutableClosure", "enclosingExtensionMemberForClass"));
        }
        DeclarationDescriptor classContainer = classDescriptor.getContainingDeclaration();
        if (classContainer instanceof CallableMemberDescriptor && (member = JvmCodegenUtil.getDirectMember((CallableMemberDescriptor)classContainer)).getExtensionReceiverParameter() != null) {
            return member;
        }
        return null;
    }

    @Nullable
    public ClassDescriptor getEnclosingClass() {
        return this.enclosingClass;
    }

    @Override
    public ResolvedCall<ConstructorDescriptor> getSuperCall() {
        return this.superCall;
    }

    @Override
    public ClassDescriptor getCaptureThis() {
        return this.captureThis ? this.enclosingClass : null;
    }

    public void setCaptureThis() {
        this.captureThis = true;
    }

    @Override
    public JetType getCaptureReceiverType() {
        if (this.captureReceiver) {
            ReceiverParameterDescriptor parameter = this.getEnclosingReceiverDescriptor();
            assert (parameter != null) : "Receiver parameter should exist in " + this.enclosingFunWithReceiverDescriptor;
            return parameter.getType();
        }
        return null;
    }

    public void setCaptureReceiver() {
        if (this.enclosingFunWithReceiverDescriptor == null) {
            throw new IllegalStateException("Extension receiver parameter should exist");
        }
        this.captureReceiver = true;
    }

    @Override
    @NotNull
    public Map<DeclarationDescriptor, EnclosedValueDescriptor> getCaptureVariables() {
        Map<DeclarationDescriptor, EnclosedValueDescriptor> map = this.captureVariables != null ? this.captureVariables : Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/MutableClosure", "getCaptureVariables"));
        }
        return map;
    }

    @Override
    @NotNull
    public List<Pair<String, Type>> getRecordedFields() {
        List<Pair<String, Type>> list = this.recordedFields != null ? this.recordedFields : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/MutableClosure", "getRecordedFields"));
        }
        return list;
    }

    public void recordField(String name, Type type) {
        if (this.recordedFields == null) {
            this.recordedFields = new LinkedList<Pair<String, Type>>();
        }
        this.recordedFields.add(new Pair<String, Type>(name, type));
    }

    public void captureVariable(EnclosedValueDescriptor value) {
        if (this.captureVariables == null) {
            this.captureVariables = new LinkedHashMap<DeclarationDescriptor, EnclosedValueDescriptor>();
        }
        this.captureVariables.put(value.getDescriptor(), value);
    }

    @Nullable
    public ReceiverParameterDescriptor getEnclosingReceiverDescriptor() {
        return this.enclosingFunWithReceiverDescriptor != null ? this.enclosingFunWithReceiverDescriptor.getExtensionReceiverParameter() : null;
    }
}

