/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.jet.codegen.inline.CapturedParamDesc;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.CapturedParamOwner;
import org.jetbrains.jet.codegen.inline.FieldRemapper;
import org.jetbrains.jet.codegen.inline.LabelOwner;
import org.jetbrains.jet.codegen.inline.Parameters;
import org.jetbrains.jet.codegen.inline.ParametersBuilder;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class LambdaInfo
implements CapturedParamOwner,
LabelOwner {
    public final JetFunctionLiteralExpression expression;
    @NotNull
    private final JetTypeMapper typeMapper;
    @Nullable
    public final String labelName;
    private final CalculatedClosure closure;
    private MethodNode node;
    private List<CapturedParamDesc> capturedVars;
    private final FunctionDescriptor functionDescriptor;
    private final ClassDescriptor classDescriptor;
    private final Type closureClassType;

    LambdaInfo(@NotNull JetFunctionLiteralExpression expression, @NotNull JetTypeMapper typeMapper, @Nullable String labelName) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/inline/LambdaInfo", "<init>"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/inline/LambdaInfo", "<init>"));
        }
        this.expression = expression;
        this.typeMapper = typeMapper;
        this.labelName = labelName;
        BindingContext bindingContext = typeMapper.getBindingContext();
        this.functionDescriptor = bindingContext.get(BindingContext.FUNCTION, expression.getFunctionLiteral());
        assert (this.functionDescriptor != null) : "Function is not resolved to descriptor: " + expression.getText();
        this.classDescriptor = CodegenBinding.anonymousClassForFunction(bindingContext, this.functionDescriptor);
        this.closureClassType = CodegenBinding.asmTypeForAnonymousClass(bindingContext, this.functionDescriptor);
        this.closure = bindingContext.get(CodegenBinding.CLOSURE, this.classDescriptor);
        assert (this.closure != null) : "Closure for lambda should be not null " + expression.getText();
    }

    public MethodNode getNode() {
        return this.node;
    }

    public void setNode(MethodNode node) {
        this.node = node;
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public JetFunctionLiteral getFunctionLiteral() {
        return this.expression.getFunctionLiteral();
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public Type getLambdaClassType() {
        return this.closureClassType;
    }

    public List<CapturedParamDesc> getCapturedVars() {
        if (this.capturedVars == null) {
            EnclosedValueDescriptor descriptor;
            this.capturedVars = new ArrayList<CapturedParamDesc>();
            if (this.closure.getCaptureThis() != null) {
                descriptor = new EnclosedValueDescriptor("this$0", null, null, this.typeMapper.mapType(this.closure.getCaptureThis()));
                this.capturedVars.add(this.getCapturedParamInfo(descriptor));
            }
            if (this.closure.getCaptureReceiverType() != null) {
                descriptor = new EnclosedValueDescriptor("receiver$0", null, null, this.typeMapper.mapType(this.closure.getCaptureReceiverType()));
                this.capturedVars.add(this.getCapturedParamInfo(descriptor));
            }
            for (EnclosedValueDescriptor descriptor2 : this.closure.getCaptureVariables().values()) {
                this.capturedVars.add(this.getCapturedParamInfo(descriptor2));
            }
        }
        return this.capturedVars;
    }

    @NotNull
    private CapturedParamDesc getCapturedParamInfo(@NotNull EnclosedValueDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/inline/LambdaInfo", "getCapturedParamInfo"));
        }
        CapturedParamDesc capturedParamDesc = CapturedParamDesc.createDesc(this, descriptor.getFieldName(), descriptor.getType());
        if (capturedParamDesc == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/LambdaInfo", "getCapturedParamInfo"));
        }
        return capturedParamDesc;
    }

    @NotNull
    public List<Type> getInvokeParamsWithoutCaptured() {
        Type[] types = this.typeMapper.mapSignature(this.functionDescriptor).getAsmMethod().getArgumentTypes();
        List<Type> list = Arrays.asList(types);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/LambdaInfo", "getInvokeParamsWithoutCaptured"));
        }
        return list;
    }

    @NotNull
    public Parameters addAllParameters(FieldRemapper remapper) {
        ParametersBuilder builder = ParametersBuilder.newBuilder();
        builder.addThis(AsmTypeConstants.OBJECT_TYPE, true).setLambda(this);
        List<ValueParameterDescriptor> valueParameters = this.getFunctionDescriptor().getValueParameters();
        for (ValueParameterDescriptor parameter : valueParameters) {
            Type type = this.typeMapper.mapType(parameter.getType());
            builder.addNextParameter(type, false, null);
        }
        for (CapturedParamDesc info : this.getCapturedVars()) {
            CapturedParamInfo field = remapper.findField(new FieldInsnNode(0, info.getContainingLambdaName(), info.getFieldName(), ""));
            builder.addCapturedParam(field, info.getFieldName());
        }
        Parameters parameters = builder.buildParameters();
        if (parameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/LambdaInfo", "addAllParameters"));
        }
        return parameters;
    }

    @Override
    public Type getType() {
        return this.closureClassType;
    }

    @Override
    public boolean isMyLabel(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/inline/LambdaInfo", "isMyLabel"));
        }
        return name.equals(this.labelName);
    }
}

