/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class Increment
extends IntrinsicMethod {
    private final int myDelta;

    public Increment(int delta) {
        this.myDelta = delta;
    }

    @Override
    @NotNull
    public Type generateImpl(@NotNull ExpressionCodegen codegen, @NotNull InstructionAdapter v, @NotNull Type returnType, PsiElement element, List<JetExpression> arguments, StackValue receiver) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/intrinsics/Increment", "generateImpl"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/intrinsics/Increment", "generateImpl"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/codegen/intrinsics/Increment", "generateImpl"));
        }
        assert (AsmUtil.isPrimitive(returnType)) : "Return type of Increment intrinsic should be of primitive type : " + returnType;
        if (arguments.size() > 0) {
            JetType operandType;
            int index;
            JetExpression operand = JetPsiUtil.deparenthesize(arguments.get(0));
            if (operand instanceof JetReferenceExpression && returnType == Type.INT_TYPE && (index = codegen.indexOfLocal((JetReferenceExpression)operand)) >= 0 && (operandType = codegen.getBindingContext().get(BindingContext.EXPRESSION_TYPE, operand)) != null && KotlinBuiltIns.getInstance().isPrimitiveType(operandType)) {
                StackValue.preIncrement(index, this.myDelta).put(returnType, v);
                Type type = returnType;
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/intrinsics/Increment", "generateImpl"));
                }
                return type;
            }
            StackValue value = codegen.genQualified(receiver, operand);
            value.dupReceiver(v);
            value.dupReceiver(v);
            value.put(returnType, v);
            AsmUtil.genIncrement(returnType, this.myDelta, v);
            value.store(returnType, v);
            value.put(returnType, v);
        } else {
            receiver.put(returnType, v);
            AsmUtil.genIncrement(returnType, this.myDelta, v);
        }
        Type type = returnType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/intrinsics/Increment", "generateImpl"));
        }
        return type;
    }
}

