/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.NameTable;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.utils.UtilsPackage;

public class NameSerializationUtil {
    private NameSerializationUtil() {
    }

    @NotNull
    public static NameResolver deserializeNameResolver(@NotNull InputStream in) {
        NameResolver nameResolver;
        block3: {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "deserializeNameResolver"));
            }
            try {
                ProtoBuf.StringTable simpleNames = ProtoBuf.StringTable.parseDelimitedFrom(in);
                ProtoBuf.QualifiedNameTable qualifiedNames = ProtoBuf.QualifiedNameTable.parseDelimitedFrom(in);
                nameResolver = new NameResolver(simpleNames, qualifiedNames);
                if (nameResolver != null) break block3;
            }
            catch (IOException e) {
                throw UtilsPackage.rethrow(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "deserializeNameResolver"));
        }
        return nameResolver;
    }

    public static void serializeNameResolver(@NotNull OutputStream out, @NotNull NameResolver nameResolver) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameResolver"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameResolver"));
        }
        NameSerializationUtil.serializeNameTable(out, nameResolver.getStringTable(), nameResolver.getQualifiedNameTable());
    }

    public static void serializeNameTable(@NotNull OutputStream out, @NotNull NameTable nameTable) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameTable"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameTable"));
        }
        NameSerializationUtil.serializeNameTable(out, NameSerializationUtil.toStringTable(nameTable), NameSerializationUtil.toQualifiedNameTable(nameTable));
    }

    private static void serializeNameTable(@NotNull OutputStream out, @NotNull ProtoBuf.StringTable stringTable, @NotNull ProtoBuf.QualifiedNameTable qualifiedNameTable) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameTable"));
        }
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameTable"));
        }
        if (qualifiedNameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameTable", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameTable"));
        }
        try {
            stringTable.writeDelimitedTo(out);
            qualifiedNameTable.writeDelimitedTo(out);
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
    }

    @NotNull
    public static ProtoBuf.StringTable toStringTable(@NotNull NameTable nameTable) {
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toStringTable"));
        }
        ProtoBuf.StringTable.Builder simpleNames = ProtoBuf.StringTable.newBuilder();
        for (String simpleName : nameTable.getStrings()) {
            simpleNames.addString(simpleName);
        }
        ProtoBuf.StringTable stringTable = simpleNames.build();
        if (stringTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toStringTable"));
        }
        return stringTable;
    }

    @NotNull
    public static ProtoBuf.QualifiedNameTable toQualifiedNameTable(@NotNull NameTable nameTable) {
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toQualifiedNameTable"));
        }
        ProtoBuf.QualifiedNameTable.Builder qualifiedNames = ProtoBuf.QualifiedNameTable.newBuilder();
        for (ProtoBuf.QualifiedNameTable.QualifiedName.Builder qName : nameTable.getFqNames()) {
            qualifiedNames.addQualifiedName(qName);
        }
        ProtoBuf.QualifiedNameTable qualifiedNameTable = qualifiedNames.build();
        if (qualifiedNameTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toQualifiedNameTable"));
        }
        return qualifiedNameTable;
    }

    @NotNull
    public static NameResolver createNameResolver(@NotNull NameTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "createNameResolver"));
        }
        NameResolver nameResolver = new NameResolver(NameSerializationUtil.toStringTable(table), NameSerializationUtil.toQualifiedNameTable(table));
        if (nameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "createNameResolver"));
        }
        return nameResolver;
    }
}

