/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics.rendering;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.rendering.RenderingPackage;
import org.jetbrains.jet.lang.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeBounds;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.renderer.Renderer;

public class Renderers {
    private static final Logger LOG = Logger.getInstance(Renderers.class);
    public static final Renderer<Object> TO_STRING = new Renderer<Object>(){

        @Override
        @NotNull
        public String render(@NotNull Object element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$1", "render"));
            }
            if (element instanceof DeclarationDescriptor) {
                LOG.warn("Diagnostic renderer TO_STRING was used to render an instance of DeclarationDescriptor.\nThis is usually a bad idea, because descriptors' toString() includes some debug information, which should not be seen by the user.\nDescriptor: " + element);
            }
            String string = element.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$1", "render"));
            }
            return string;
        }

        public String toString() {
            return "TO_STRING";
        }
    };
    public static final Renderer<String> STRING = new Renderer<String>(){

        @Override
        @NotNull
        public String render(@NotNull String element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$2", "render"));
            }
            String string = element;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$2", "render"));
            }
            return string;
        }
    };
    public static final Renderer<Named> NAME = new Renderer<Named>(){

        @Override
        @NotNull
        public String render(@NotNull Named element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$3", "render"));
            }
            String string = element.getName().asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$3", "render"));
            }
            return string;
        }
    };
    public static final Renderer<PsiElement> ELEMENT_TEXT = new Renderer<PsiElement>(){

        @Override
        @NotNull
        public String render(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$4", "render"));
            }
            String string = element.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$4", "render"));
            }
            return string;
        }
    };
    public static final Renderer<JetNamedDeclaration> DECLARATION_NAME = new Renderer<JetNamedDeclaration>(){

        @Override
        @NotNull
        public String render(@NotNull JetNamedDeclaration element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$5", "render"));
            }
            String string = element.getNameAsSafeName().asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$5", "render"));
            }
            return string;
        }
    };
    public static final Renderer<JetClassOrObject> RENDER_CLASS_OR_OBJECT = new Renderer<JetClassOrObject>(){

        @Override
        @NotNull
        public String render(@NotNull JetClassOrObject classOrObject) {
            String name;
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$6", "render"));
            }
            String string = name = classOrObject.getName() != null ? " '" + classOrObject.getName() + "'" : "";
            if (classOrObject instanceof JetClass) {
                String string2 = "Class" + name;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$6", "render"));
                }
                return string2;
            }
            String string3 = "Object" + name;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$6", "render"));
            }
            return string3;
        }
    };
    public static final Renderer<ClassDescriptor> RENDER_CLASS_OR_OBJECT_NAME = new Renderer<ClassDescriptor>(){

        @Override
        @NotNull
        public String render(@NotNull ClassDescriptor classifier2) {
            if (classifier2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifier", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$7", "render"));
            }
            String string = RenderingPackage.renderKindWithName(classifier2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$7", "render"));
            }
            return string;
        }
    };
    public static final Renderer<JetType> RENDER_TYPE = new Renderer<JetType>(){

        @Override
        @NotNull
        public String render(@NotNull JetType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$8", "render"));
            }
            String string = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$8", "render"));
            }
            return string;
        }
    };
    public static final Renderer<Collection<? extends ResolvedCall<?>>> AMBIGUOUS_CALLS = new Renderer<Collection<? extends ResolvedCall<?>>>(){

        @Override
        @NotNull
        public String render(@NotNull Collection<? extends ResolvedCall<?>> argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$9", "render"));
            }
            StringBuilder stringBuilder = new StringBuilder("\n");
            for (ResolvedCall<?> call : argument) {
                stringBuilder.append(DescriptorRenderer.FQ_NAMES_IN_TYPES.render((DeclarationDescriptor)call.getResultingDescriptor())).append("\n");
            }
            String string = stringBuilder.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$9", "render"));
            }
            return string;
        }
    };
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER = new Renderer<InferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData inferenceErrorData) {
            if (inferenceErrorData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inferenceErrorData", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$11", "render"));
            }
            String string = Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$11", "render"));
            }
            return string;
        }
    };
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER = new Renderer<InferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData inferenceErrorData) {
            if (inferenceErrorData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inferenceErrorData", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$12", "render"));
            }
            String string = Renderers.renderTypeConstructorMismatchError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$12", "render"));
            }
            return string;
        }
    };
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER = new Renderer<InferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData inferenceErrorData) {
            if (inferenceErrorData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inferenceErrorData", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$13", "render"));
            }
            String string = Renderers.renderNoInformationForParameterError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$13", "render"));
            }
            return string;
        }
    };
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER = new Renderer<InferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData inferenceErrorData) {
            if (inferenceErrorData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inferenceErrorData", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$14", "render"));
            }
            String string = Renderers.renderUpperBoundViolatedInferenceError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$14", "render"));
            }
            return string;
        }
    };
    public static final Renderer<Collection<ClassDescriptor>> CLASSES_OR_SEPARATED = new Renderer<Collection<ClassDescriptor>>(){

        @Override
        @NotNull
        public String render(@NotNull Collection<ClassDescriptor> descriptors) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$17", "render"));
            }
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (ClassDescriptor descriptor : descriptors) {
                sb.append(DescriptorUtils.getFqName(descriptor).asString());
                if (++index <= descriptors.size() - 2) {
                    sb.append(", ");
                    continue;
                }
                if (index != descriptors.size() - 1) continue;
                sb.append(" or ");
            }
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$17", "render"));
            }
            return string;
        }
    };
    public static final Renderer<Collection<JetType>> RENDER_COLLECTION_OF_TYPES = new Renderer<Collection<JetType>>(){

        @Override
        @NotNull
        public String render(@NotNull Collection<JetType> types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$18", "render"));
            }
            String string = StringUtil.join(types, new Function<JetType, String>(){

                @Override
                public String fun(JetType type) {
                    return RENDER_TYPE.render(type);
                }
            }, ", ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$18", "render"));
            }
            return string;
        }
    };
    public static final Renderer<ConstraintSystem> RENDER_CONSTRAINT_SYSTEM = new Renderer<ConstraintSystem>(){

        @Override
        @NotNull
        public String render(@NotNull ConstraintSystem constraintSystem) {
            if (constraintSystem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$19", "render"));
            }
            Set<TypeParameterDescriptor> typeVariables = constraintSystem.getTypeVariables();
            LinkedHashSet<TypeBounds> typeBounds = Sets.newLinkedHashSet();
            for (TypeParameterDescriptor variable : typeVariables) {
                typeBounds.add(constraintSystem.getTypeBounds(variable));
            }
            Function<TypeBounds, String> renderTypeBounds = Renderers.rendererToFunction(RENDER_TYPE_BOUNDS);
            String string = "type parameter bounds:\n" + StringUtil.join(typeBounds, renderTypeBounds, "\n") + "\n" + "status:\n" + ConstraintsUtil.getDebugMessageForStatus(constraintSystem.getStatus());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$19", "render"));
            }
            return string;
        }
    };
    public static final Renderer<TypeBounds> RENDER_TYPE_BOUNDS = new Renderer<TypeBounds>(){

        @Override
        @NotNull
        public String render(@NotNull TypeBounds typeBounds) {
            if (typeBounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeBounds", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$20", "render"));
            }
            Function<TypeBounds.Bound, String> renderBound = new Function<TypeBounds.Bound, String>(){

                @Override
                public String fun(TypeBounds.Bound bound) {
                    String arrow = bound.kind == TypeBounds.BoundKind.LOWER_BOUND ? ">: " : (bound.kind == TypeBounds.BoundKind.UPPER_BOUND ? "<: " : ":= ");
                    return arrow + RENDER_TYPE.render(bound.type) + '(' + bound.position + ')';
                }
            };
            Name typeVariableName = typeBounds.getTypeVariable().getName();
            if (typeBounds.isEmpty()) {
                String string = typeVariableName.asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$20", "render"));
                }
                return string;
            }
            String string = typeVariableName + " " + StringUtil.join(typeBounds.getBounds(), renderBound, ", ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$20", "render"));
            }
            return string;
        }
    };

    public static <T> Renderer<Collection<? extends T>> commaSeparated(final Renderer<T> itemRenderer) {
        return new Renderer<Collection<? extends T>>(){

            @Override
            @NotNull
            public String render(@NotNull Collection<? extends T> object2) {
                if (object2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$10", "render"));
                }
                StringBuilder result2 = new StringBuilder();
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Object next = iterator2.next();
                    result2.append(itemRenderer.render(next));
                    if (!iterator2.hasNext()) continue;
                    result2.append(", ");
                }
                String string = result2.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$10", "render"));
                }
                return string;
            }
        };
    }

    public static TabledDescriptorRenderer renderConflictingSubstitutionsInferenceError(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer result2) {
        LOG.assertTrue(inferenceErrorData.constraintSystem.getStatus().hasConflictingConstraints(), Renderers.renderDebugMessage("Conflicting substitutions inference error renderer is applied for incorrect status", inferenceErrorData));
        ArrayList<CallableDescriptor> substitutedDescriptors = Lists.newArrayList();
        Collection<TypeSubstitutor> substitutors = ConstraintsUtil.getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem);
        for (TypeSubstitutor substitutor : substitutors) {
            CallableDescriptor substitutedDescriptor = inferenceErrorData.descriptor.substitute(substitutor);
            substitutedDescriptors.add(substitutedDescriptor);
        }
        TypeParameterDescriptor firstConflictingParameter = ConstraintsUtil.getFirstConflictingParameter(inferenceErrorData.constraintSystem);
        if (firstConflictingParameter == null) {
            LOG.error(Renderers.renderDebugMessage("There is no conflicting parameter for 'conflicting constraints' error.", inferenceErrorData));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Cannot infer type parameter ").strong(firstConflictingParameter.getName()).normal(" in "));
        TabledDescriptorRenderer.TableRenderer table = TabledDescriptorRenderer.newTable();
        result2.table(table);
        table.descriptor(inferenceErrorData.descriptor).text("None of the following substitutions");
        for (CallableDescriptor substitutedDescriptor : substitutedDescriptors) {
            JetType receiverType = DescriptorUtils.getReceiverParameterType(substitutedDescriptor.getExtensionReceiverParameter());
            final HashSet<ConstraintPosition> errorPositions = Sets.newHashSet();
            ArrayList<JetType> parameterTypes = Lists.newArrayList();
            for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
                JetType actualType;
                parameterTypes.add(valueParameterDescriptor.getType());
                if (valueParameterDescriptor.getIndex() >= inferenceErrorData.valueArgumentsTypes.size() || JetTypeChecker.DEFAULT.isSubtypeOf(actualType = inferenceErrorData.valueArgumentsTypes.get(valueParameterDescriptor.getIndex()), valueParameterDescriptor.getType())) continue;
                errorPositions.add(ConstraintPosition.getValueParameterPosition(valueParameterDescriptor.getIndex()));
            }
            if (receiverType != null && inferenceErrorData.receiverArgumentType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(inferenceErrorData.receiverArgumentType, receiverType)) {
                errorPositions.add(ConstraintPosition.RECEIVER_POSITION);
            }
            Predicate<ConstraintPosition> isErrorPosition = new Predicate<ConstraintPosition>(){

                @Override
                public boolean apply(@Nullable ConstraintPosition constraintPosition) {
                    return errorPositions.contains(constraintPosition);
                }
            };
            table.functionArgumentTypeList(receiverType, parameterTypes, isErrorPosition);
        }
        table.text("can be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes);
        return result2;
    }

    public static TabledDescriptorRenderer renderTypeConstructorMismatchError(final InferenceErrorData inferenceErrorData, TabledDescriptorRenderer renderer) {
        Predicate<ConstraintPosition> isErrorPosition = new Predicate<ConstraintPosition>(){

            @Override
            public boolean apply(ConstraintPosition constraintPosition) {
                return inferenceErrorData.constraintSystem.getStatus().hasTypeConstructorMismatchAt(constraintPosition);
            }
        };
        return renderer.table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("cannot be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes, isErrorPosition));
    }

    public static TabledDescriptorRenderer renderNoInformationForParameterError(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer result2) {
        Named firstUnknownParameter = null;
        for (TypeParameterDescriptor typeParameter : inferenceErrorData.constraintSystem.getTypeVariables()) {
            if (!inferenceErrorData.constraintSystem.getTypeBounds(typeParameter).isEmpty()) continue;
            firstUnknownParameter = typeParameter;
            break;
        }
        if (firstUnknownParameter == null) {
            LOG.error(Renderers.renderDebugMessage("There is no unknown parameter for 'no information for parameter error'.", inferenceErrorData));
            return result2;
        }
        return result2.text(TabledDescriptorRenderer.newText().normal("Not enough information to infer parameter ").strong(firstUnknownParameter.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("Please specify it explicitly."));
    }

    @NotNull
    public static TabledDescriptorRenderer renderUpperBoundViolatedInferenceError(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer result2) {
        TypeParameterDescriptor typeParameterDescriptor = null;
        ConstraintSystemImpl constraintSystem = (ConstraintSystemImpl)inferenceErrorData.constraintSystem;
        ConstraintSystemStatus status = constraintSystem.getStatus();
        LOG.assertTrue(status.hasViolatedUpperBound(), Renderers.renderDebugMessage("Upper bound violated renderer is applied for incorrect status", inferenceErrorData));
        ConstraintSystem systemWithoutWeakConstraints = constraintSystem.getSystemWithoutWeakConstraints();
        for (TypeParameterDescriptor typeParameter : inferenceErrorData.descriptor.getTypeParameters()) {
            if (ConstraintsUtil.checkUpperBoundIsSatisfied(systemWithoutWeakConstraints, typeParameter, true)) continue;
            typeParameterDescriptor = typeParameter;
        }
        if (typeParameterDescriptor == null && status.hasConflictingConstraints()) {
            TabledDescriptorRenderer tabledDescriptorRenderer = Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, result2);
            if (tabledDescriptorRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers", "renderUpperBoundViolatedInferenceError"));
            }
            return tabledDescriptorRenderer;
        }
        if (typeParameterDescriptor == null) {
            LOG.error(Renderers.renderDebugMessage("There is no type parameter with violated upper bound for 'upper bound violated' error", inferenceErrorData));
            TabledDescriptorRenderer tabledDescriptorRenderer = result2;
            if (tabledDescriptorRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers", "renderUpperBoundViolatedInferenceError"));
            }
            return tabledDescriptorRenderer;
        }
        JetType inferredValueForTypeParameter = systemWithoutWeakConstraints.getTypeBounds(typeParameterDescriptor).getValue();
        if (inferredValueForTypeParameter == null) {
            LOG.error(Renderers.renderDebugMessage("System without weak constraints is not successful, there is no value for type parameter " + typeParameterDescriptor.getName() + "\n: " + systemWithoutWeakConstraints, inferenceErrorData));
            TabledDescriptorRenderer tabledDescriptorRenderer = result2;
            if (tabledDescriptorRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers", "renderUpperBoundViolatedInferenceError"));
            }
            return tabledDescriptorRenderer;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
        JetType violatedUpperBound = null;
        for (JetType upperBound : typeParameterDescriptor.getUpperBounds()) {
            JetType upperBoundWithSubstitutedInferredTypes = systemWithoutWeakConstraints.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            if (upperBoundWithSubstitutedInferredTypes == null || JetTypeChecker.DEFAULT.isSubtypeOf(inferredValueForTypeParameter, upperBoundWithSubstitutedInferredTypes)) continue;
            violatedUpperBound = upperBoundWithSubstitutedInferredTypes;
            break;
        }
        if (violatedUpperBound == null) {
            LOG.error(Renderers.renderDebugMessage("Type parameter (chosen as violating its upper bound)" + typeParameterDescriptor.getName() + " violates no bounds after substitution", inferenceErrorData));
            TabledDescriptorRenderer tabledDescriptorRenderer = result2;
            if (tabledDescriptorRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers", "renderUpperBoundViolatedInferenceError"));
            }
            return tabledDescriptorRenderer;
        }
        Renderer<JetType> typeRenderer = result2.getTypeRenderer();
        result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render(inferredValueForTypeParameter)).normal(" is not a subtype of ").strong(typeRenderer.render(violatedUpperBound)));
        TabledDescriptorRenderer tabledDescriptorRenderer = result2;
        if (tabledDescriptorRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers", "renderUpperBoundViolatedInferenceError"));
        }
        return tabledDescriptorRenderer;
    }

    @NotNull
    public static <T> Function<T, String> rendererToFunction(final @NotNull Renderer<T> renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers", "rendererToFunction"));
        }
        Function function = new Function<T, String>(){

            @Override
            public String fun(T t) {
                return renderer.render(t);
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers", "rendererToFunction"));
        }
        return function;
    }

    @NotNull
    private static String renderDebugMessage(String message, InferenceErrorData inferenceErrorData) {
        StringBuilder result2 = new StringBuilder();
        result2.append(message);
        result2.append("\nConstraint system: \n");
        result2.append(RENDER_CONSTRAINT_SYSTEM.render(inferenceErrorData.constraintSystem));
        result2.append("\nDescriptor:\n");
        result2.append(inferenceErrorData.descriptor);
        result2.append("\nExpected type:\n");
        if (TypeUtils.noExpectedType(inferenceErrorData.expectedType)) {
            result2.append(inferenceErrorData.expectedType);
        } else {
            result2.append(RENDER_TYPE.render(inferenceErrorData.expectedType));
        }
        result2.append("\nArgument types:\n");
        if (inferenceErrorData.receiverArgumentType != null) {
            result2.append(RENDER_TYPE.render(inferenceErrorData.receiverArgumentType)).append(".");
        }
        result2.append("(").append(StringUtil.join(inferenceErrorData.valueArgumentsTypes, new Function<JetType, String>(){

            @Override
            public String fun(JetType type) {
                return RENDER_TYPE.render(type);
            }
        }, ", ")).append(")");
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers", "renderDebugMessage"));
        }
        return string;
    }

    private Renderers() {
    }
}

