/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetContainerNode;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;

public class JetExpressionWithLabel
extends JetExpressionImpl {
    public JetExpressionWithLabel(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetExpressionWithLabel", "<init>"));
        }
        super(node);
    }

    @Nullable
    public JetSimpleNameExpression getTargetLabel() {
        JetContainerNode qualifier = (JetContainerNode)this.findChildByType(JetNodeTypes.LABEL_QUALIFIER);
        if (qualifier == null) {
            return null;
        }
        return (JetSimpleNameExpression)qualifier.findChildByType(JetNodeTypes.LABEL);
    }

    @Nullable
    public String getLabelName() {
        JetSimpleNameExpression labelElement = this.getTargetLabel();
        assert (labelElement == null || labelElement.getText().startsWith("@"));
        return labelElement == null ? null : labelElement.getText().substring(1);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetExpressionWithLabel", "accept"));
        }
        return visitor.visitExpressionWithLabel(this, data2);
    }
}

