/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.SubpackagesScope;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class JetModuleUtil {
    public static JetScope getSubpackagesOfRootScope(@NotNull ModuleDescriptor module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/JetModuleUtil", "getSubpackagesOfRootScope"));
        }
        return JetModuleUtil.getRootPackageScope(module, false);
    }

    public static JetScope getImportsResolutionScope(ModuleDescriptor module, boolean inRootPackage) {
        return JetModuleUtil.getRootPackageScope(module, inRootPackage);
    }

    private static JetScope getRootPackageScope(ModuleDescriptor module, boolean scopeIncludingMembers) {
        PackageViewDescriptor rootPackage = module.getPackage(FqName.ROOT);
        assert (rootPackage != null) : "Couldn't find root package for " + module;
        return scopeIncludingMembers ? rootPackage.getMemberScope() : new SubpackagesScope(rootPackage);
    }
}

