/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Comparator;
import java.util.List;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.renderer.DescriptorRendererBuilder;

public class MemberComparator
implements Comparator<DeclarationDescriptor> {
    public static final MemberComparator INSTANCE = new MemberComparator();
    private static final DescriptorRenderer RENDERER = new DescriptorRendererBuilder().setWithDefinedIn(false).setVerbose(true).build();

    private MemberComparator() {
    }

    private static int getDeclarationPriority(DeclarationDescriptor descriptor) {
        if (descriptor instanceof ConstructorDescriptor) {
            return 6;
        }
        if (descriptor instanceof PropertyDescriptor) {
            if (((PropertyDescriptor)descriptor).getExtensionReceiverParameter() == null) {
                return 5;
            }
            return 4;
        }
        if (descriptor instanceof FunctionDescriptor) {
            if (((FunctionDescriptor)descriptor).getExtensionReceiverParameter() == null) {
                return 3;
            }
            return 2;
        }
        if (descriptor instanceof ClassDescriptor) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(DeclarationDescriptor o1, DeclarationDescriptor o2) {
        int renderDiff;
        int prioritiesCompareTo = MemberComparator.getDeclarationPriority(o2) - MemberComparator.getDeclarationPriority(o1);
        if (prioritiesCompareTo != 0) {
            return prioritiesCompareTo;
        }
        int namesCompareTo = o1.getName().compareTo(o2.getName());
        if (namesCompareTo != 0) {
            return namesCompareTo;
        }
        if (o1 instanceof CallableDescriptor && o2 instanceof CallableDescriptor) {
            String r2;
            String r1;
            int receiversCompareTo;
            CallableDescriptor c1 = (CallableDescriptor)o1;
            CallableDescriptor c2 = (CallableDescriptor)o2;
            ReceiverParameterDescriptor c1ReceiverParameter = c1.getExtensionReceiverParameter();
            ReceiverParameterDescriptor c2ReceiverParameter = c2.getExtensionReceiverParameter();
            assert (c1ReceiverParameter != null == (c2ReceiverParameter != null));
            if (c1ReceiverParameter != null && (receiversCompareTo = (r1 = RENDERER.renderType(c1ReceiverParameter.getType())).compareTo(r2 = RENDERER.renderType(c2ReceiverParameter.getType()))) != 0) {
                return receiversCompareTo;
            }
            List<ValueParameterDescriptor> c1ValueParameters = c1.getValueParameters();
            List<ValueParameterDescriptor> c2ValueParameters = c2.getValueParameters();
            for (int i = 0; i < Math.min(c1ValueParameters.size(), c2ValueParameters.size()); ++i) {
                String p2;
                String p1 = RENDERER.renderType(c1ValueParameters.get(i).getType());
                int parametersCompareTo = p1.compareTo(p2 = RENDERER.renderType(c2ValueParameters.get(i).getType()));
                if (parametersCompareTo == 0) continue;
                return parametersCompareTo;
            }
            int valueParametersNumberCompareTo = c1ValueParameters.size() - c2ValueParameters.size();
            if (valueParametersNumberCompareTo != 0) {
                return valueParametersNumberCompareTo;
            }
            List<TypeParameterDescriptor> c1TypeParameters = c1.getTypeParameters();
            List<TypeParameterDescriptor> c2TypeParameters = c2.getTypeParameters();
            for (int i = 0; i < Math.min(c1TypeParameters.size(), c2TypeParameters.size()); ++i) {
                String p2;
                String p1 = RENDERER.renderType(c1TypeParameters.get(i).getUpperBoundsAsType());
                int parametersCompareTo = p1.compareTo(p2 = RENDERER.renderType(c2TypeParameters.get(i).getUpperBoundsAsType()));
                if (parametersCompareTo == 0) continue;
                return parametersCompareTo;
            }
            int typeParametersCompareTo = c1TypeParameters.size() - c2TypeParameters.size();
            if (typeParametersCompareTo != 0) {
                return typeParametersCompareTo;
            }
            if (c1 instanceof CallableMemberDescriptor && c2 instanceof CallableMemberDescriptor) {
                CallableMemberDescriptor.Kind c1Kind = ((CallableMemberDescriptor)c1).getKind();
                CallableMemberDescriptor.Kind c2Kind = ((CallableMemberDescriptor)c2).getKind();
                int kindsCompareTo = c1Kind.ordinal() - c2Kind.ordinal();
                if (kindsCompareTo != 0) {
                    return kindsCompareTo;
                }
            }
        } else if (o1 instanceof ClassDescriptor && o2 instanceof ClassDescriptor) {
            ClassDescriptor class1 = (ClassDescriptor)o1;
            ClassDescriptor class2 = (ClassDescriptor)o2;
            if (class1.getKind().ordinal() != class2.getKind().ordinal()) {
                return class1.getKind().ordinal() - class2.getKind().ordinal();
            }
        } else {
            throw new AssertionError((Object)String.format("Unsupported pair of descriptors:\n'%s' Class: %s\n%s' Class: %s", o1, o1.getClass(), o2, o2.getClass()));
        }
        if ((renderDiff = RENDERER.render(o1).compareTo(RENDERER.render(o2))) != 0) {
            return renderDiff;
        }
        Name firstModuleName = DescriptorUtils.getContainingModule(o1).getName();
        Name secondModuleName = DescriptorUtils.getContainingModule(o2).getName();
        return firstModuleName.compareTo(secondModuleName);
    }
}

