/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$1;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$2;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$3;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$4;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeConstraintSystem$1;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeConstraintSystem$2;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeConstraintSystem$3;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$updateRecordedTypeForArgument$1;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.CandidateResolver;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage$callUtil$2020e762;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMapping;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMatch;
import org.jetbrains.jet.lang.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;

@KotlinClass(abiVersion=19, data={"\u001c\u0010)i1)\u00197m\u0007>l\u0007\u000f\\3uKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7OC\u0002kKRTA\u0001\\1oO*9!/Z:pYZ,'\"B2bY2\u001c(bA!os*11n\u001c;mS:Ta\u0001P5oSRt$\u0002F1sOVlWM\u001c;UsB,'+Z:pYZ,'O\u0003\u000bBe\u001e,X.\u001a8u)f\u0004XMU3t_24XM\u001d\u0006\u0012G\u0006tG-\u001b3bi\u0016\u0014Vm]8mm\u0016\u0014(\"E\"b]\u0012LG-\u0019;f%\u0016\u001cx\u000e\u001c<fe*9r-\u001a;Be\u001e,X.\u001a8u)f\u0004XMU3t_24XM\u001d\u0006\u0015O\u0016$8)\u00198eS\u0012\fG/\u001a*fg>dg/\u001a:\u000b\u0003\u0011S!cQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u0015U\u0019w.\u001c9mKR,\u0017\t\u001c7DC:$\u0017\u000eZ1uKNTqaY8oi\u0016DHO\u0003\u000eCCNL7mQ1mYJ+7o\u001c7vi&|gnQ8oi\u0016DHOC\u0004sKN,H\u000e^:\u000b;=3XM\u001d7pC\u0012\u0014Vm]8mkRLwN\u001c*fgVdGo]%na2TA!\u00168ji*\t2m\\7qY\u0016$X-\u0011:hk6,g\u000e^:\u000b\u0019\r|W\u000e\u001d7fi\u0016\u001c\u0015\r\u001c7\u000b\u000fQ\u0014\u0018mY5oO*yAK]1dS:<7\u000b\u001e:bi\u0016<\u0017PC\u0003uCN\\7OC\fd_6\u0004H.\u001a;f\u0007\u0006dGNR8s\u0003J<W/\\3oi*QQ\r\u001f9sKN\u001c\u0018n\u001c8\u000b\u001b)+G/\u0012=qe\u0016\u001c8/[8o\u0015\r\u00018/\u001b\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016T1#T;uC\ndWMU3t_24X\rZ\"bY2TQ!\\8eK2T\u0001dY8na2,G/Z\"p]N$(/Y5oiNK8\u000f^3n\u00151)\u0007\u0010]3di\u0016$G+\u001f9f\u0015\u001dQU\r\u001e+za\u0016TQ\u0001^=qKNTQ\u0001\u001e:bG\u0016TABQ5oI&tw\r\u0016:bG\u0016T1cY8na2,G/Z(oK\u0006\u0013x-^7f]RTQB^1mk\u0016\f%oZ;nK:$(\"\u0004,bYV,\u0017I]4v[\u0016tGO\u0003\u0011d_6\u0004H.\u001a;f%\u0016\u001cx\u000e\u001c<fI\u000e\u000bG\u000e\\!oI\u0006\u0013x-^7f]R\u001c(\u0002\u0004:fg>dg/\u001a3DC2d'BE4fi\u000e\u000bG\u000e\u001c$pe\u0006\u0013x-^7f]RT\u0001\"\u0019:hk6,g\u000e\u001e\u0006\u000fE&tG-\u001b8h\u0007>tG/\u001a=u\u00159\u0011\u0015N\u001c3j]\u001e\u001cuN\u001c;fqRTAaQ1mY*!\u0002.Y:OK\u000e,7o]1ssN\u000bg-Z\"bY2TqAQ8pY\u0016\fgNC\u000fva\u0012\fG/\u001a*fG>\u0014H-\u001a3UsB,gi\u001c:Be\u001e,X.\u001a8u\u0015-)\b\u000fZ1uK\u0012$\u0016\u0010]3\u000b\u0019I,7m\u001c:eK\u0012$\u0016\u0010]3\u000b%\u0005\u0014x-^7f]R,\u0005\u0010\u001d:fgNLwN\u001c\u0006+kB$\u0017\r^3SKN|G.\u001e;j_:\u001cF/\u0019;vg\u001a\u0013x.\\\"p]N$(/Y5oiNK8\u000f^3nA\u000bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0005\u000b\r!9\u0001c\u0002\r\u0001\u0015\u0019AQ\u0001E\u0006\u0019\u0001)1\u0001\"\u0002\t\u000e1\u0001QA\u0001C\u0003\u0011\u0017)!\u0001\"\u0002\t\u000e\u0015\u0011A1\u0001\u0005\n\u000b\r!i\u0001#\u0005\r\u0001\u0015\u0011AQ\u0001\u0005\u000b\u000b\r!y\u0001#\u0006\r\u0001\u0015\u0011AQ\u0001\u0005\f\u000b\r!\t\u0002c\u0006\r\u0001\u0015\u0019Aq\u0001\u0005\r\u0019\u0001)!\u0001b\u0004\t\u0016\u0015\u0011A\u0011\u0003E\f\u000b\t!)\u0001#\b\u0006\u0007\u0011Y\u0001B\u0004\u0007\u0001\u000b\t!1\u0002\u0003\b\u0006\u0005\u0011\r\u0001\u0012E\u0003\u0004\t3A\u0001\u0003\u0004\u0001\u0006\u0005\u0011e\u0001\u0002E\u0003\u0003\t\u000bA!#B\u0002\u0005\u001d!\rB\u0002A\u0003\u0003\t\u0007AA#B\u0002\u0005\u001f!\u001dB\u0002A\u0003\u0004\t\tAQ\u0003\u0004\u0001\u0006\u0005\u0011q\u00012E\u0003\u0003\t=A9#\u0002\u0002\u0005\u0005!)Ra\u0001C\r\u0011[a\u0001!\u0002\u0002\u0005\u001a!5Ra\u0001\u0003\u0003\u0011ga\u0001!B\u0002\u0005\u001a!QB\u0002A\u0003\u0003\t3A!$\u0002\u0002\u0005\u0005!MRa\u0001C\u0004\u0011ma\u0001\u0001B\u0002\r\u0007e\u0011Q!\u0001\u0005\u0005[=!\u0001\r\u0002\r\u0006C\t)\u0011\u0001#\u0003V\u0007!)1\u0001B\u0003\n\u0003!-Qb\u0001\u0003\b\u0013\u0005AY!L\b\u0005A\u0012Ab!\t\u0002\u0006\u0003!)Qk\u0001\u0005\u0006\u0007\u00111\u0011\"\u0001\u0005\u0007\u001b\r!y!C\u0001\t\r5>C!A\t\u0006\t\u0001A\u0001\"\u0006\u0002\u0006\u0003!9\u00014CO\u0007\t\u0001A!\"\u0004\u0002\u0006\u0003!A\u0001k\u0001\u0001\u001e\u0018\u0011\u0001\u0001bC\u0007\b\u000b\u0005A\u0011\"\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0005\u0011EA\u0003\u0002\u0011'\t6a\u0002C\n\u0013\u0005!\u0001!D\u0001\t\u00155\t\u0001RCW(\t\u0005\tR\u0001\u0002\u0001\t\u0011U\u0011Q!\u0001\u0005\b13ij\u0001\u0002\u0001\t\u00155\u0011Q!\u0001\u0005\t!\u000e\u0001Qt\u0003\u0003\u0001\u0011-iq!B\u0001\t\u0013%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001UB\u0001C\t)\u0011\u0001c\u0005R\u0007\u001d!I\"C\u0001\u0005\u00015\t\u0001BC\u0007\u0002\u0011+ic\u0007\u0002\u0001\u0012\u000b\u0011\u0001\u0001\u0002C\u000b\u0003\u000b\u0005Aq\u0001G\u0007\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A\u0001\u0002U\u0002\u0001;/!\u0001\u0001C\u0006\u000e\u000f\u0015\t\u0001\"C\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b\t!(\u0004\u0005\u0001!mQBA\u0003\u0002\u0011/\u00016!A\u0011\b\u000b\u0005A\u0011\"\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001#\u000eIA!D\u0005\u0002\u0011+i\u0011\u0001\u0003\u0006\u000e\u0003!UQ\"\u0001\u0005\r[\u001f\"\u0011\u0001G\b\u001e\u000e\u0011\u0001\u0001rD\u0007\u0003\u000b\u0005AQ\u0002U\u0002\u0001;\u001b!\u0001\u0001\u0003\u0006\u000e\u0005\u0015\t\u0001\u0002\u0003)\u0004\u0002\u0005jQ!\u0001\u0005\n\u0013%!\t!C\u0004\u0006\u0003!9\u0001#E\u000b\u0004\u000b\u0005Aq\u0001$\u0001\r\u0002E\u001bq\u0001B\b\n\u0003!UQ\"\u0001E\u000e\u001b\u0005A!\",\u0017\u0005\u0003E)A\u0001\u0001\u0005\t+\t)\u0011\u0001C\u0004\u0016\u000f\u0015\t\u0001RD\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001a\u0015RT\u0002\u0003\u0001\u0011Mi!!B\u0001\t A\u001b\t!(\u0004\u0005\u0001!%RBA\u0003\u0002\u0011A\u00016!A\u0011\u0003\u000b\u0005A\u0019\"U\u0002\n\tKI\u0011\u0001\u0002\u0001\u000e\u0003!\u0005R\"\u0001\u0005\u0012\u001b\u0005A\u0019#,\u000f\u0005\u0003a-RT\u0002\u0003\u0001\u0011Yi!!B\u0001\t%A\u001b\u0001!(\u0004\u0005\u0001!QQBA\u0003\u0002\u0011!\u00016\u0011A\u0011\u0003\u000b\u0005A\u0019\"U\u0002\b\tWI\u0011\u0001\u0002\u0001\u000e\u0003!\u0015R\"\u0001\u0005\u000b[\u0003\u0007A!A\t\u0006\t\u0001A\u0001\"\u0006\u0002\u0006\u0003!9\u0001dFO\r\t\u0001Ay#\u0004\u0005\u0006\u0003!u\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001\r\u0002A\u001b\u0001!h\u0006\u0005\u0001!YQbB\u0003\u0002\u0011%IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001)\u0004\u0002u5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001\u0003\u0005Q\u0007\u0005ij\u0001\u0002\u0001\t\u001c5\u0011Q!\u0001E\f!\u000e\r\u0011EA\u0003\u0002\u0011'\t6a\u0003\u0003\u0018\u0013\u0005!\u0001!D\u0001\t\"5\t\u0001RC\u0007\u0002\u0011)i\u0011\u0001\u0003\u0007.>\u0011\t\u0001\u0004GO\b\t\u0001A\t$D\u0002\u0006\u0003!iA\u0012\u0001)\u0004\u0001u5A\u0001\u0001\u0005\u001a\u001b\t)\u0011\u0001C\nQ\u0007\u0003\t3!B\u0001\t(1\u0005\u0011kA\u0004\u00051%\t\u0001\u0002F\u0007\u0002\u00117i\u0011\u0001#\u000b.:\u0011\t\u0001TGO\u0007\t\u0001Ay\"\u0004\u0002\u0006\u0003!i\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0012F\u0007\u0003\u000b\u0005A\u0001\u0003UB\u0001C\t)\u0011\u0001C\u000bR\u0007\u001d!)$C\u0001\u0005\u00025\t\u00012D\u0007\u0002\u0011Gi+\u0007B\u0001\u00198u=A\u0001\u0001\u0005\u001d\u001b\r)\u0011\u0001c\b\r\u0002A\u001b\u0001!h\u0004\u0005\u0001!eRbA\u0003\u0002\u0011?a\t\u0001UB\u0001;\u001b!\u0001\u0001C\u000f\u000e\u0005\u0015\t\u0001\"\u0004)\u0004\u0003u5A\u0001\u0001E\u0015\u001b\t)\u0011\u0001\u0003\tQ\u0007\u0007\t3!B\u0001\t 1\u0005\u0011kA\u0006\u00058%\t\u0001\"E\u0007\u0002\u0011Ei\u0011\u0001C\t\u000e\u0003!mQ\"\u0001E\u0012[3\"\u0011!E\u0003\u0005\u0001!AQCA\u0003\u0002\u0011\u001d)r!B\u0001\t\u001e%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001g\u000f\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A\u0001\u0002UB\u0001;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0003\u0005\u0012Q!\u0001E\n#\u000eIA1H\u0005\u0002\t\u0001i\u0011\u0001#\t\u000e\u0003!QQ\"\u0001\u0005\rky)Q\u0004Br\u00011\u0013ij\u0001\u0002\u0001\t\u000b5\u0011Q!\u0001E\u0005!\u000e\u0001QT\u0002\u0003\u0001\u0011\u0019i!!B\u0001\t\u000bA\u001b\t!\t\u0002\u0006\u0003!\u0019\u0011kA\u0004\u0005\n%\tA\u0001A\u0007\u0002\u0011\u0017i\u0011\u0001\u0003\u0004"})
public final class CallCompleter
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final CandidateResolver candidateResolver;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(CallCompleter.class);
    }

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2, @JetValueParameter(name="results") @NotNull OverloadResolutionResultsImpl<D> results, @JetValueParameter(name="tracing") @NotNull TracingStrategy tracing) {
        Unit unit;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(results, "results");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        ResolvedCall resolvedCall = results.isSingleResult() ? results.getResultingCall() : (MutableResolvedCall)null;
        if (!CallResolverUtil.isInvokeCallOnVariable(((CallResolutionContext)context2).call)) {
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(((ResolutionContext)context2).trace, "Trace to complete a resulting call");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)context2.replaceBindingTrace(temporaryTrace);
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "context.replaceBindingTrace(temporaryTrace)");
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall, results, basicCallResolutionContext, tracing);
            this.completeAllCandidates(context2, results);
            temporaryTrace.commit();
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        if (resolvedCall2 != null) {
            ResolvedCall resolvedCall3 = resolvedCall2;
            MutableResolvedCall it = (MutableResolvedCall)resolvedCall3;
            ((ResolutionContext)context2).callResolverExtension.run(it, context2);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        if (results.isSingleResult() ? results.getResultingCall().getStatus().isSuccess() : false) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results.changeStatusToSuccess();
            Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResultsImpl, "results.changeStatusToSuccess()");
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        return overloadResolutionResultsImpl;
    }

    private final <D extends CallableDescriptor> void completeAllCandidates(@JetValueParameter(name="context") BasicCallResolutionContext context2, @JetValueParameter(name="results") OverloadResolutionResultsImpl<D> results) {
        Collection<ResolvedCall<D>> collection;
        if (((ResolutionContext)context2).collectAllCandidates) {
            collection = results.getAllCandidates();
            if (collection == null) {
                Intrinsics.throwNpe();
            }
        } else {
            collection = results.getResultingCalls();
        }
        if (collection == null) {
            throw new TypeCastException("(kotlin.MutableCollection<out org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall<D!>!>..kotlin.Collection<org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall<D!>!>?) cannot be cast to kotlin.Collection<org.jetbrains.jet.lang.resolve.calls.model.MutableResolvedCall<D>>");
        }
        Collection<ResolvedCall<D>> candidates = collection;
        Iterable iterable = candidates;
        Iterable iterable2 = iterable;
        Collection collection22 = new ArrayList();
        Iterator iterator2 = iterable2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            MutableResolvedCall resolvedCall = (MutableResolvedCall)t;
            if (!(!resolvedCall.isCompleted())) continue;
            collection22.add(t);
        }
        iterable = (ArrayList)collection22;
        for (Collection collection22 : iterable) {
            MutableResolvedCall resolvedCall = (MutableResolvedCall)((Object)collection22);
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(((ResolutionContext)context2).trace, "Trace to complete a candidate that is not a resulting call");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)context2.replaceBindingTrace(temporaryBindingTrace);
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "context.replaceBindingTrace(temporaryBindingTrace)");
            TracingStrategy tracingStrategy = TracingStrategy.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull(tracingStrategy, "TracingStrategy.EMPTY");
            CallCompleter.completeResolvedCallAndArguments$b$0(this, resolvedCall, results, basicCallResolutionContext, tracingStrategy);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(@JetValueParameter(name="resolvedCall", type="?") MutableResolvedCall<D> resolvedCall, @JetValueParameter(name="results") OverloadResolutionResultsImpl<D> results, @JetValueParameter(name="context") BasicCallResolutionContext context2, @JetValueParameter(name="tracing") TracingStrategy tracing) {
        boolean bl = !(!(resolvedCall == null) ? resolvedCall.isCompleted() : true) ? resolvedCall.getConstraintSystem() == null : true;
        if (bl) {
            Unit unit;
            this.completeArguments(context2, results);
            MutableResolvedCall<D> mutableResolvedCall = resolvedCall;
            if (mutableResolvedCall != null) {
                mutableResolvedCall.markCallAsCompleted();
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
            return;
        }
        JetType jetType = ((ResolutionContext)context2).expectedType;
        Intrinsics.checkExpressionValueIsNotNull(jetType, "context.expectedType");
        BindingTrace bindingTrace = ((ResolutionContext)context2).trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        this.completeConstraintSystem(resolvedCall, jetType, bindingTrace);
        this.completeArguments(context2, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall, context2, tracing);
        resolvedCall.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(@JetValueParameter(name="$receiver") MutableResolvedCall<D> $receiver, @JetValueParameter(name="expectedType") JetType expectedType, @JetValueParameter(name="trace") BindingTrace trace) {
        ConstraintSystemCompleter constraintSystemCompleter;
        CallCompleter$completeConstraintSystem$1 callCompleter$completeConstraintSystem$1 = new CallCompleter$completeConstraintSystem$1($receiver);
        JetType returnType = $receiver.getCandidateDescriptor().getReturnType();
        if (returnType != null) {
            ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
            if (constraintSystem == null) {
                Intrinsics.throwNpe();
            }
            constraintSystem.addSupertypeConstraint(expectedType, returnType, ConstraintPosition.EXPECTED_TYPE_POSITION);
            if (expectedType == TypeUtils.UNIT_EXPECTED_TYPE) {
                callCompleter$completeConstraintSystem$1.invoke(new CallCompleter$completeConstraintSystem$2(returnType));
            }
        }
        if ((constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, $receiver.getCall().getCalleeExpression())) != null) {
            callCompleter$completeConstraintSystem$1.invoke(new CallCompleter$completeConstraintSystem$3($receiver, constraintSystemCompleter));
        }
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem! cannot be cast to org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl");
        }
        ((ConstraintSystemImpl)constraintSystem).processDeclaredBoundConstraints();
        ConstraintSystem constraintSystem2 = $receiver.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        $receiver.setResultingSubstitutor(constraintSystem2.getResultingSubstitutor());
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(@JetValueParameter(name="$receiver") MutableResolvedCall<D> $receiver, @JetValueParameter(name="context") BasicCallResolutionContext context2, @JetValueParameter(name="tracing") TracingStrategy tracing) {
        CallCandidateResolutionContext<D> contextWithResolvedCall = CallCandidateResolutionContext.createForCallBeingAnalyzed($receiver, context2, tracing);
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(contextWithResolvedCall, ((ResolutionContext)context2).trace, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        ResolutionStatus status = $receiver.getStatus();
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        if (constraintSystem.getStatus().isSuccessful()) {
            if (!Intrinsics.areEqual((Object)status, (Object)ResolutionStatus.UNKNOWN_STATUS) ? Intrinsics.areEqual((Object)status, (Object)ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) : true) {
                $receiver.setStatusToSuccess();
            }
            return;
        }
        JetType receiverType = $receiver.getExtensionReceiver().exists() ? $receiver.getExtensionReceiver().getType() : (JetType)null;
        Object d = $receiver.getCandidateDescriptor();
        ConstraintSystem constraintSystem2 = $receiver.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        InferenceErrorData errorData = InferenceErrorData.create(d, constraintSystem2, valueArgumentsCheckingResult.argumentTypes, receiverType, ((ResolutionContext)context2).expectedType);
        tracing.typeInferenceFailed(((ResolutionContext)context2).trace, errorData);
        $receiver.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    private final <D extends CallableDescriptor> void completeArguments(@JetValueParameter(name="context") BasicCallResolutionContext context2, @JetValueParameter(name="results") OverloadResolutionResultsImpl<D> results) {
        Function1 getDataFlowInfoForArgument;
        Function1 getArgumentMapping;
        if (Intrinsics.areEqual((Object)((CallResolutionContext)context2).checkArguments, (Object)CheckValueArgumentsMode.DISABLED)) {
            return;
        }
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall = results.getResultingCall();
            getArgumentMapping = new CallCompleter$completeArguments$1((MutableResolvedCall)resolvedCall);
            getDataFlowInfoForArgument = new CallCompleter$completeArguments$2((MutableResolvedCall)resolvedCall);
        } else {
            getArgumentMapping = CallCompleter$completeArguments$3.INSTANCE$;
            getDataFlowInfoForArgument = new CallCompleter$completeArguments$4(context2);
        }
        Iterator<? extends ValueArgument> iterator2 = ((CallResolutionContext)context2).call.getValueArguments().iterator();
        while (iterator2.hasNext()) {
            BasicCallResolutionContext newContext;
            ArgumentMapping argumentMapping;
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            if (valueArgument2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(valueArgument2, "valueArgument!!");
            ArgumentMapping argumentMapping2 = argumentMapping = (ArgumentMapping)getArgumentMapping.invoke(valueArgument2);
            JetType expectedType = argumentMapping2 instanceof ArgumentMatch ? CandidateResolver.getEffectiveExpectedType(((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument) : TypeUtils.NO_EXPECTED_TYPE;
            BasicCallResolutionContext basicCallResolutionContext = newContext = (BasicCallResolutionContext)((BasicCallResolutionContext)context2.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke(valueArgument))).replaceExpectedType(expectedType);
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "newContext");
            this.completeOneArgument(valueArgument, basicCallResolutionContext);
        }
    }

    private final void completeOneArgument(@JetValueParameter(name="valueArgument") ValueArgument valueArgument, @JetValueParameter(name="context") BasicCallResolutionContext context2) {
        JetType recordedType;
        if (valueArgument.isExternal()) {
            return;
        }
        JetExpression expression = valueArgument.getArgumentExpression();
        if (expression == null) {
            return;
        }
        JetType updatedType = recordedType = (JetType)((ResolutionContext)context2).trace.get(BindingContext.EXPRESSION_TYPE, expression);
        OverloadResolutionResultsImpl<? extends CallableDescriptor> results = this.completeCallForArgument(expression, context2);
        if (results != null ? results.isSingleResult() : false) {
            JetType jetType;
            ResolvedCall resolvedCall = results.getResultingCall();
            if (resolvedCall.hasInferredReturnType()) {
                Object d = resolvedCall.getResultingDescriptor();
                jetType = d != null ? d.getReturnType() : null;
            } else {
                jetType = updatedType = (JetType)null;
            }
        }
        boolean bl = recordedType != null ? !recordedType.getConstructor().isDenotable() : false;
        if (bl) {
            BasicCallResolutionContext basicCallResolutionContext = context2;
            if (basicCallResolutionContext == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext cannot be cast to org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<out org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<Context!>!>");
            }
            updatedType = ArgumentTypeResolver.updateResultArgumentTypeIfNotDenotable(basicCallResolutionContext, expression);
        }
        BindingTrace bindingTrace = ((ResolutionContext)context2).trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        updatedType = this.updateRecordedTypeForArgument(updatedType, recordedType, expression, bindingTrace);
        if (ArgumentTypeResolver.isFunctionLiteralArgument(expression)) {
            BasicCallResolutionContext basicCallResolutionContext = context2;
            if (basicCallResolutionContext == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext cannot be cast to org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext<out org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext<Context!>!>");
            }
            this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression, ArgumentTypeResolver.getFunctionLiteralArgument(expression), basicCallResolutionContext, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        BasicCallResolutionContext basicCallResolutionContext = context2;
        if (basicCallResolutionContext == null) {
            throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext cannot be cast to org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<out org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<Context!>!>");
        }
        DataFlowUtils.checkType(updatedType, expression, (ResolutionContext)basicCallResolutionContext);
    }

    private final OverloadResolutionResultsImpl<? extends CallableDescriptor> completeCallForArgument(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="context") BasicCallResolutionContext context2) {
        BasicCallResolutionContext contextForArgument;
        BindingContext bindingContext = ((ResolutionContext)context2).trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.getBindingContext()");
        Call argumentCall = this.getCallForArgument(expression, bindingContext);
        if (argumentCall == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedDataForCall = ((ResolutionContext)context2).resolutionResultsCache.get(argumentCall);
        if (cachedDataForCall == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData = cachedDataForCall;
        OverloadResolutionResultsImpl<? extends CallableDescriptor> cachedResolutionResults = cachedData.component1();
        BasicCallResolutionContext cachedContext = cachedData.component2();
        TracingStrategy tracing = cachedData.component3();
        OverloadResolutionResultsImpl<? extends CallableDescriptor> cachedResults = null;
        OverloadResolutionResultsImpl<? extends CallableDescriptor> overloadResolutionResultsImpl = cachedResolutionResults;
        if (overloadResolutionResultsImpl == null) {
            throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl<out org.jetbrains.jet.lang.descriptors.CallableDescriptor!> cannot be cast to org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl<org.jetbrains.jet.lang.descriptors.CallableDescriptor>");
        }
        cachedResults = overloadResolutionResultsImpl;
        BasicCallResolutionContext basicCallResolutionContext = contextForArgument = (BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(((ResolutionContext)context2).trace)).replaceExpectedType(((ResolutionContext)context2).expectedType)).replaceCollectAllCandidates(false);
        Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "contextForArgument");
        return this.completeCall(basicCallResolutionContext, cachedResults, tracing);
    }

    private final Call getCallForArgument(@JetValueParameter(name="argument", type="?") JetExpression argument, @JetValueParameter(name="bindingContext") BindingContext bindingContext) {
        if (!ExpressionTypingUtils.dependsOnExpectedType(argument)) {
            return null;
        }
        if (argument instanceof JetBlockExpression) {
            JetElement lastStatement = JetPsiUtil.getLastStatementInABlock((JetBlockExpression)argument);
            JetElement jetElement = lastStatement;
            if (!(jetElement instanceof JetExpression)) {
                jetElement = null;
            }
            return this.getCallForArgument((JetExpression)jetElement, bindingContext);
        }
        JetExpression jetExpression = argument;
        return jetExpression != null ? CallUtilPackage$callUtil$2020e762.getCall(jetExpression, bindingContext) : null;
    }

    private final JetType updateRecordedTypeForArgument(@JetValueParameter(name="updatedType", type="?") JetType updatedType, @JetValueParameter(name="recordedType", type="?") JetType recordedType, @JetValueParameter(name="argumentExpression") JetExpression argumentExpression, @JetValueParameter(name="trace") BindingTrace trace) {
        boolean bl = !Intrinsics.areEqual(recordedType, updatedType) ? updatedType == null : true;
        if (bl) {
            return updatedType;
        }
        CallCompleter$updateRecordedTypeForArgument$1 callCompleter$updateRecordedTypeForArgument$1 = CallCompleter$updateRecordedTypeForArgument$1.INSTANCE$;
        ArrayList<JetExpression> expressions = new ArrayList<JetExpression>();
        JetExpression expression = argumentExpression;
        while (expression != null) {
            JetExpression jetExpression = expression;
            if (jetExpression == null) {
                Intrinsics.throwNpe();
            }
            expressions.add(jetExpression);
            expression = callCompleter$updateRecordedTypeForArgument$1.invoke(expression);
        }
        Iterable iterable = expressions;
        for (Object t : iterable) {
            JetExpression expression2;
            JetExpression jetExpression = expression2 = (JetExpression)t;
            Intrinsics.checkExpressionValueIsNotNull(jetExpression, "expression");
            BindingContextUtils.updateRecordedType(updatedType, expression2, trace, CallCompleter.hasNecessarySafeCall$b$1(this, jetExpression, trace));
        }
        return (JetType)trace.get(BindingContext.EXPRESSION_TYPE, argumentExpression);
    }

    private final boolean hasNecessarySafeCall(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="trace") BindingTrace trace) {
        if (!(expression instanceof JetSafeQualifiedExpression)) {
            return false;
        }
        JetType expressionType = (JetType)trace.get(BindingContext.EXPRESSION_TYPE, ((JetSafeQualifiedExpression)expression).getReceiverExpression());
        return expressionType != null ? TypeUtils.isNullableType(expressionType) : false;
    }

    @NotNull
    public final ArgumentTypeResolver getArgumentTypeResolver() {
        ArgumentTypeResolver argumentTypeResolver = this.argumentTypeResolver;
        if (argumentTypeResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "getArgumentTypeResolver"));
        }
        return argumentTypeResolver;
    }

    @NotNull
    public final CandidateResolver getCandidateResolver() {
        CandidateResolver candidateResolver = this.candidateResolver;
        if (candidateResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "getCandidateResolver"));
        }
        return candidateResolver;
    }

    public CallCompleter(@JetValueParameter(name="argumentTypeResolver") @NotNull ArgumentTypeResolver argumentTypeResolver, @JetValueParameter(name="candidateResolver") @NotNull CandidateResolver candidateResolver) {
        if (argumentTypeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypeResolver", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "<init>"));
        }
        if (candidateResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolver", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "<init>"));
        }
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(candidateResolver, "candidateResolver");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
    }

    public static final /* synthetic */ <D extends CallableDescriptor> void completeResolvedCallAndArguments$b$0(@JetValueParameter(name="$this", type="?") CallCompleter $this, @JetValueParameter(name="resolvedCall", type="?") @Nullable MutableResolvedCall<D> resolvedCall, @JetValueParameter(name="results") @NotNull OverloadResolutionResultsImpl<D> results, @JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2, @JetValueParameter(name="tracing") @NotNull TracingStrategy tracing) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeResolvedCallAndArguments$b$0"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeResolvedCallAndArguments$b$0"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeResolvedCallAndArguments$b$0"));
        }
        $this.completeResolvedCallAndArguments(resolvedCall, results, context2, tracing);
    }

    public static final /* synthetic */ boolean hasNecessarySafeCall$b$1(@JetValueParameter(name="$this", type="?") CallCompleter $this, @JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "hasNecessarySafeCall$b$1"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "hasNecessarySafeCall$b$1"));
        }
        return $this.hasNecessarySafeCall(expression, trace);
    }
}

