/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;

public class ResolutionTask<D extends CallableDescriptor, F extends D>
extends CallResolutionContext<ResolutionTask<D, F>> {
    private final Collection<ResolutionCandidate<D>> candidates;
    private final Collection<MutableResolvedCall<F>> resolvedCalls;
    private DescriptorCheckStrategy checkingStrategy;
    public final TracingStrategy tracing;

    private ResolutionTask(@NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull ContextDependency contextDependency, @NotNull CheckValueArgumentsMode checkArguments, @NotNull ResolutionResultsCache resolutionResultsCache, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments, @NotNull CallResolverExtension callResolverExtension, @NotNull Collection<MutableResolvedCall<F>> resolvedCalls, boolean isAnnotationContext, boolean collectAllCandidates) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (checkArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArguments", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (resolutionResultsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionResultsCache", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (callResolverExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolverExtension", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (resolvedCalls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCalls", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        super(trace, scope, call, expectedType, dataFlowInfo, contextDependency, checkArguments, resolutionResultsCache, dataFlowInfoForArguments, callResolverExtension, isAnnotationContext, collectAllCandidates);
        this.candidates = candidates;
        this.resolvedCalls = resolvedCalls;
        this.tracing = tracing;
    }

    public ResolutionTask(@NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull BasicCallResolutionContext context2, @NotNull TracingStrategy tracing) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        this(candidates, tracing, context2.trace, context2.scope, context2.call, context2.expectedType, context2.dataFlowInfo, context2.contextDependency, context2.checkArguments, context2.resolutionResultsCache, context2.dataFlowInfoForArguments, context2.callResolverExtension, Lists.newArrayList(), context2.isAnnotationContext, context2.collectAllCandidates);
    }

    public ResolutionTask(@NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull JetReferenceExpression reference, @NotNull BasicCallResolutionContext context2) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        this(candidates, context2, TracingStrategyImpl.create(reference, context2.call));
    }

    @NotNull
    public Collection<ResolutionCandidate<D>> getCandidates() {
        Collection<ResolutionCandidate<D>> collection = this.candidates;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "getCandidates"));
        }
        return collection;
    }

    public void addResolvedCall(@NotNull MutableResolvedCall<F> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "addResolvedCall"));
        }
        this.resolvedCalls.add(resolvedCall);
    }

    @NotNull
    public Collection<MutableResolvedCall<F>> getResolvedCalls() {
        Collection<MutableResolvedCall<F>> collection = this.resolvedCalls;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "getResolvedCalls"));
        }
        return collection;
    }

    public void setCheckingStrategy(DescriptorCheckStrategy strategy) {
        this.checkingStrategy = strategy;
    }

    public boolean performAdvancedChecks(D descriptor, BindingTrace trace, TracingStrategy tracing) {
        return this.checkingStrategy == null || this.checkingStrategy.performAdvancedChecks(descriptor, trace, tracing);
    }

    @Override
    protected ResolutionTask<D, F> create(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, @NotNull ContextDependency contextDependency, @NotNull ResolutionResultsCache resolutionResultsCache, boolean collectAllCandidates) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (resolutionResultsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionResultsCache", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "create"));
        }
        ResolutionTask<D, F> newTask = new ResolutionTask<D, F>(this.candidates, this.tracing, trace, scope, this.call, expectedType, dataFlowInfo, contextDependency, this.checkArguments, resolutionResultsCache, this.dataFlowInfoForArguments, this.callResolverExtension, this.resolvedCalls, this.isAnnotationContext, collectAllCandidates);
        newTask.setCheckingStrategy(this.checkingStrategy);
        return newTask;
    }

    public ResolutionTask<D, F> replaceCall(@NotNull Call newCall) {
        if (newCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newCall", "org/jetbrains/jet/lang/resolve/calls/tasks/ResolutionTask", "replaceCall"));
        }
        return new ResolutionTask<D, F>(this.candidates, this.tracing, this.trace, this.scope, newCall, this.expectedType, this.dataFlowInfo, this.contextDependency, this.checkArguments, this.resolutionResultsCache, this.dataFlowInfoForArguments, this.callResolverExtension, this.resolvedCalls, this.isAnnotationContext, this.collectAllCandidates);
    }

    public String toString() {
        return this.candidates.toString();
    }

    public static interface DescriptorCheckStrategy {
        public <D extends CallableDescriptor> boolean performAdvancedChecks(D var1, BindingTrace var2, TracingStrategy var3);
    }
}

