/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationOwner;
import org.jetbrains.jet.lang.resolve.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMember;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class SignaturesUtil {
    private SignaturesUtil() {
    }

    @Nullable
    public static String getKotlinSignature(@NotNull ExternalAnnotationResolver externalAnnotationResolver, @NotNull JavaMember member) {
        if (externalAnnotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalAnnotationResolver", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "getKotlinSignature"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "getKotlinSignature"));
        }
        JavaAnnotation newAnnotation = SignaturesUtil.findAnnotationWithExternal(externalAnnotationResolver, member, JvmAnnotationNames.KOTLIN_SIGNATURE);
        if (newAnnotation != null) {
            return SignaturesUtil.extractKotlinSignatureArgument(newAnnotation);
        }
        JavaAnnotation oldAnnotation = SignaturesUtil.findAnnotationWithExternal(externalAnnotationResolver, member, JvmAnnotationNames.OLD_KOTLIN_SIGNATURE);
        if (oldAnnotation != null) {
            return SignaturesUtil.extractKotlinSignatureArgument(oldAnnotation);
        }
        return null;
    }

    @Nullable
    private static String extractKotlinSignatureArgument(@NotNull JavaAnnotation annotation) {
        Object value;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "extractKotlinSignatureArgument"));
        }
        JavaAnnotationArgument argument = annotation.findArgument(JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME);
        if (argument instanceof JavaLiteralAnnotationArgument && (value = ((JavaLiteralAnnotationArgument)argument).getValue()) instanceof String) {
            return StringUtil.unescapeStringCharacters((String)value);
        }
        return null;
    }

    @Nullable
    public static JavaAnnotation findAnnotationWithExternal(@NotNull ExternalAnnotationResolver externalAnnotationResolver, @NotNull JavaAnnotationOwner owner, @NotNull FqName name) {
        if (externalAnnotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalAnnotationResolver", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "findAnnotationWithExternal"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "findAnnotationWithExternal"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "findAnnotationWithExternal"));
        }
        JavaAnnotation annotation = owner.findAnnotation(name);
        if (annotation != null) {
            return annotation;
        }
        return externalAnnotationResolver.findExternalAnnotation(owner, name);
    }
}

