/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.mapping;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public abstract class JavaToKotlinClassMapBuilder {
    protected void init() {
        KotlinBuiltIns kotlinBuiltIns = KotlinBuiltIns.getInstance();
        this.register(Object.class, KotlinBuiltIns.getInstance().getAny());
        this.register(String.class, kotlinBuiltIns.getString());
        this.register(CharSequence.class, kotlinBuiltIns.getCharSequence());
        this.register(Throwable.class, kotlinBuiltIns.getThrowable());
        this.register(Cloneable.class, kotlinBuiltIns.getCloneable());
        this.register(Number.class, kotlinBuiltIns.getNumber());
        this.register(Comparable.class, kotlinBuiltIns.getComparable());
        this.register(Enum.class, kotlinBuiltIns.getEnum());
        this.register(Annotation.class, kotlinBuiltIns.getAnnotation());
        this.register(Deprecated.class, kotlinBuiltIns.getDeprecatedAnnotation(), Direction.JAVA_TO_KOTLIN);
        this.register(Void.class, kotlinBuiltIns.getNothing(), Direction.KOTLIN_TO_JAVA);
        this.register(Iterable.class, kotlinBuiltIns.getIterable(), kotlinBuiltIns.getMutableIterable());
        this.register(Iterator.class, kotlinBuiltIns.getIterator(), kotlinBuiltIns.getMutableIterator());
        this.register(Collection.class, kotlinBuiltIns.getCollection(), kotlinBuiltIns.getMutableCollection());
        this.register(List.class, kotlinBuiltIns.getList(), kotlinBuiltIns.getMutableList());
        this.register(Set.class, kotlinBuiltIns.getSet(), kotlinBuiltIns.getMutableSet());
        this.register(Map.class, kotlinBuiltIns.getMap(), kotlinBuiltIns.getMutableMap());
        this.register(Map.Entry.class, kotlinBuiltIns.getMapEntry(), kotlinBuiltIns.getMutableMapEntry());
        this.register(ListIterator.class, kotlinBuiltIns.getListIterator(), kotlinBuiltIns.getMutableListIterator());
    }

    void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMapBuilder", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMapBuilder", "register"));
        }
        this.register(javaClass, kotlinDescriptor, Direction.BOTH);
    }

    protected abstract void register(@NotNull Class<?> var1, @NotNull ClassDescriptor var2, @NotNull Direction var3);

    void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMapBuilder", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMapBuilder", "register"));
        }
        if (kotlinMutableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinMutableDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMapBuilder", "register"));
        }
        this.register(javaClass, kotlinDescriptor, kotlinMutableDescriptor, Direction.BOTH);
    }

    protected abstract void register(@NotNull Class<?> var1, @NotNull ClassDescriptor var2, @NotNull ClassDescriptor var3, @NotNull Direction var4);

    public static enum Direction {
        JAVA_TO_KOTLIN,
        KOTLIN_TO_JAVA,
        BOTH;

    }
}

