/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.AbstractScopeAdapter;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class InnerClassesScopeWrapper
extends AbstractScopeAdapter {
    private final JetScope actualScope;

    public InnerClassesScopeWrapper(@NotNull JetScope actualScope) {
        if (actualScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualScope", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "<init>"));
        }
        this.actualScope = actualScope;
    }

    @Override
    @NotNull
    protected JetScope getWorkerScope() {
        JetScope jetScope = this.actualScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getWorkerScope"));
        }
        return jetScope;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getClassifier"));
        }
        ClassifierDescriptor classifier2 = this.actualScope.getClassifier(name);
        return classifier2 instanceof ClassDescriptor ? classifier2 : null;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull Name labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getDeclarationsByLabel"));
        }
        List<DeclarationDescriptor> list = KotlinPackage.filterIsInstance(this.actualScope.getDeclarationsByLabel(labelName), ClassDescriptor.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getDeclarationsByLabel"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        List<DeclarationDescriptor> list = KotlinPackage.filterIsInstance(this.actualScope.getAllDescriptors(), ClassDescriptor.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getAllDescriptors"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        List<ReceiverParameterDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getImplicitReceiversHierarchy"));
        }
        return list;
    }

    public String toString() {
        return "Classes from " + this.actualScope;
    }
}

