/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.DelegatingFlexibleType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.Flexibility;
import org.jetbrains.jet.lang.types.FlexibleTypeCapabilities;
import org.jetbrains.jet.lang.types.IntersectionTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.TypesPackage;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CommonSupertypes {
    @Nullable
    public static JetType commonSupertypeForNonDenotableTypes(@NotNull Collection<JetType> types) {
        JetType type;
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSupertypeForNonDenotableTypes"));
        }
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1 && (type = types.iterator().next()).getConstructor() instanceof IntersectionTypeConstructor) {
            return CommonSupertypes.commonSupertypeForNonDenotableTypes(type.getConstructor().getSupertypes());
        }
        return CommonSupertypes.commonSupertype(types);
    }

    @NotNull
    public static JetType commonSupertype(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSupertype"));
        }
        JetType jetType = CommonSupertypes.findCommonSupertype(types, 0, CommonSupertypes.maxDepth(types) + 3);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSupertype"));
        }
        return jetType;
    }

    private static int maxDepth(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/types/CommonSupertypes", "maxDepth"));
        }
        int max = 0;
        for (JetType type : types) {
            int depth = CommonSupertypes.depth(type);
            if (max >= depth) continue;
            max = depth;
        }
        return max;
    }

    private static int depth(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/CommonSupertypes", "depth"));
        }
        return 1 + CommonSupertypes.maxDepth(KotlinPackage.map(type.getArguments(), new Function1<TypeProjection, JetType>(){

            @Override
            public JetType invoke(TypeProjection projection) {
                return projection.getType();
            }
        }));
    }

    @NotNull
    private static JetType findCommonSupertype(@NotNull Collection<JetType> types, int recursionDepth, int maxDepth) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/types/CommonSupertypes", "findCommonSupertype"));
        }
        assert (recursionDepth <= maxDepth) : "Recursion depth exceeded: " + recursionDepth + " > " + maxDepth + " for types " + types;
        boolean hasFlexible = false;
        ArrayList<JetType> upper = new ArrayList<JetType>(types.size());
        ArrayList<JetType> lower = new ArrayList<JetType>(types.size());
        LinkedHashSet<FlexibleTypeCapabilities> capabilities = new LinkedHashSet<FlexibleTypeCapabilities>();
        for (JetType type : types) {
            if (TypesPackage.isFlexible(type)) {
                hasFlexible = true;
                Flexibility flexibility = TypesPackage.flexibility(type);
                upper.add(flexibility.getUpperBound());
                lower.add(flexibility.getLowerBound());
                capabilities.add(flexibility.getExtraCapabilities());
                continue;
            }
            upper.add(type);
            lower.add(type);
        }
        if (!hasFlexible) {
            JetType jetType = CommonSupertypes.commonSuperTypeForInflexible(types, recursionDepth, maxDepth);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "findCommonSupertype"));
            }
            return jetType;
        }
        JetType jetType = DelegatingFlexibleType.create(CommonSupertypes.commonSuperTypeForInflexible(lower, recursionDepth, maxDepth), CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth), (FlexibleTypeCapabilities)KotlinPackage.single(capabilities));
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "findCommonSupertype"));
        }
        return jetType;
    }

    @NotNull
    private static JetType commonSuperTypeForInflexible(@NotNull Collection<JetType> types, int recursionDepth, int maxDepth) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSuperTypeForInflexible"));
        }
        assert (!types.isEmpty());
        HashSet<JetType> typeSet = new HashSet<JetType>(types);
        JetType bestFit = TypesPackage.singleBestRepresentative(typeSet);
        if (bestFit != null) {
            JetType jetType = bestFit;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return jetType;
        }
        boolean nullable = false;
        Iterator iterator2 = typeSet.iterator();
        while (iterator2.hasNext()) {
            JetType type = (JetType)iterator2.next();
            assert (type != null);
            assert (!TypesPackage.isFlexible(type)) : "Flexible type " + type + " passed to commonSuperTypeForInflexible";
            if (KotlinBuiltIns.getInstance().isNothingOrNullableNothing(type)) {
                iterator2.remove();
            }
            if (type.isError()) {
                JetType jetType = ErrorUtils.createErrorType("Supertype of error type " + type);
                if (jetType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSuperTypeForInflexible"));
                }
                return jetType;
            }
            nullable |= type.isNullable();
        }
        if (typeSet.isEmpty()) {
            JetType jetType = nullable ? KotlinBuiltIns.getInstance().getNullableNothingType() : KotlinBuiltIns.getInstance().getNothingType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return jetType;
        }
        if (typeSet.size() == 1) {
            JetType jetType = TypeUtils.makeNullableIfNeeded((JetType)typeSet.iterator().next(), nullable);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return jetType;
        }
        Map<TypeConstructor, Set<JetType>> commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(typeSet);
        while (commonSupertypes.size() > 1) {
            HashSet<JetType> merge = new HashSet<JetType>();
            for (Set<JetType> supertypes : commonSupertypes.values()) {
                merge.addAll(supertypes);
            }
            commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(merge);
        }
        assert (!commonSupertypes.isEmpty()) : commonSupertypes + " <- " + types;
        Map.Entry<TypeConstructor, Set<JetType>> entry = commonSupertypes.entrySet().iterator().next();
        JetType result2 = CommonSupertypes.computeSupertypeProjections(entry.getKey(), entry.getValue(), recursionDepth, maxDepth);
        JetType jetType = TypeUtils.makeNullableIfNeeded(result2, nullable);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSuperTypeForInflexible"));
        }
        return jetType;
    }

    @NotNull
    private static Map<TypeConstructor, Set<JetType>> computeCommonRawSupertypes(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        assert (!types.isEmpty());
        HashMap<TypeConstructor, Set<JetType>> constructorToAllInstances = new HashMap<TypeConstructor, Set<JetType>>();
        HashSet<TypeConstructor> commonSuperclasses = null;
        List<TypeConstructor> order = null;
        for (JetType type : types) {
            HashSet<TypeConstructor> visited = new HashSet<TypeConstructor>();
            order = TypeUtils.topologicallySortSuperclassesAndRecordAllInstances(type, constructorToAllInstances, visited);
            if (commonSuperclasses == null) {
                commonSuperclasses = visited;
                continue;
            }
            commonSuperclasses.retainAll(visited);
        }
        assert (order != null);
        HashSet<TypeConstructor> notSource = new HashSet<TypeConstructor>();
        HashMap<TypeConstructor, Set<JetType>> result2 = new HashMap<TypeConstructor, Set<JetType>>();
        for (TypeConstructor superConstructor : order) {
            if (!commonSuperclasses.contains(superConstructor) || notSource.contains(superConstructor)) continue;
            result2.put(superConstructor, (Set<JetType>)constructorToAllInstances.get(superConstructor));
            CommonSupertypes.markAll(superConstructor, notSource);
        }
        HashMap<TypeConstructor, Set<JetType>> hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        return hashMap;
    }

    @NotNull
    private static JetType computeSupertypeProjections(@NotNull TypeConstructor constructor, @NotNull Set<JetType> types, int recursionDepth, int maxDepth) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        assert (!types.isEmpty());
        if (types.size() == 1) {
            JetType jetType = types.iterator().next();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjections"));
            }
            return jetType;
        }
        List<TypeParameterDescriptor> parameters = constructor.getParameters();
        ArrayList<TypeProjection> newProjections = new ArrayList<TypeProjection>();
        int parametersSize = parameters.size();
        for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters.get(i);
            HashSet<TypeProjection> typeProjections = new HashSet<TypeProjection>();
            for (JetType type : types) {
                typeProjections.add(type.getArguments().get(i));
            }
            newProjections.add(CommonSupertypes.computeSupertypeProjection(parameterDescriptor, typeProjections, recursionDepth, maxDepth));
        }
        boolean nullable = false;
        for (JetType type : types) {
            nullable |= type.isNullable();
        }
        JetScope newScope = JetScope.EMPTY;
        ClassifierDescriptor declarationDescriptor = constructor.getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            newScope = ((ClassDescriptor)declarationDescriptor).getMemberScope(newProjections);
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Annotations.EMPTY, constructor, nullable, newProjections, newScope);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        return jetTypeImpl;
    }

    @NotNull
    private static TypeProjection computeSupertypeProjection(@NotNull TypeParameterDescriptor parameterDescriptor, @NotNull Set<TypeProjection> typeProjections, int recursionDepth, int maxDepth) {
        Variance projectionKind;
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        if (typeProjections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjections", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        TypeProjection singleBestProjection = TypesPackage.singleBestRepresentative(typeProjections);
        if (singleBestProjection != null) {
            TypeProjection typeProjection = singleBestProjection;
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjection;
        }
        if (recursionDepth >= maxDepth) {
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(Variance.OUT_VARIANCE, KotlinBuiltIns.getInstance().getNullableAnyType());
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        HashSet<JetType> ins = new HashSet<JetType>();
        HashSet<JetType> outs = new HashSet<JetType>();
        Variance variance = parameterDescriptor.getVariance();
        switch (variance) {
            case INVARIANT: {
                break;
            }
            case IN_VARIANCE: {
                outs = null;
                break;
            }
            case OUT_VARIANCE: {
                ins = null;
            }
        }
        for (TypeProjection projection : typeProjections) {
            Variance projectionKind2 = projection.getProjectionKind();
            if (projectionKind2.allowsInPosition()) {
                if (ins != null) {
                    ins.add(projection.getType());
                }
            } else {
                ins = null;
            }
            if (projectionKind2.allowsOutPosition()) {
                if (outs == null) continue;
                outs.add(projection.getType());
                continue;
            }
            outs = null;
        }
        if (outs != null) {
            projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind, CommonSupertypes.findCommonSupertype(outs, recursionDepth + 1, maxDepth));
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        if (ins != null) {
            JetType intersection = TypeUtils.intersect(JetTypeChecker.DEFAULT, ins);
            if (intersection == null) {
                TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(Variance.OUT_VARIANCE, CommonSupertypes.findCommonSupertype(parameterDescriptor.getUpperBounds(), recursionDepth + 1, maxDepth));
                if (typeProjectionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
                }
                return typeProjectionImpl;
            }
            Variance projectionKind3 = variance == Variance.IN_VARIANCE ? Variance.INVARIANT : Variance.IN_VARIANCE;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind3, intersection);
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind, CommonSupertypes.findCommonSupertype(parameterDescriptor.getUpperBounds(), recursionDepth + 1, maxDepth));
        if (typeProjectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        return typeProjectionImpl;
    }

    private static void markAll(@NotNull TypeConstructor typeConstructor, @NotNull Set<TypeConstructor> markerSet) {
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/lang/types/CommonSupertypes", "markAll"));
        }
        if (markerSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerSet", "org/jetbrains/jet/lang/types/CommonSupertypes", "markAll"));
        }
        markerSet.add(typeConstructor);
        for (JetType type : typeConstructor.getSupertypes()) {
            CommonSupertypes.markAll(type.getConstructor(), markerSet);
        }
    }
}

