/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeCapability;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public abstract class DelegatingType
implements JetType {
    protected abstract JetType getDelegate();

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        TypeConstructor typeConstructor = this.getDelegate().getConstructor();
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DelegatingType", "getConstructor"));
        }
        return typeConstructor;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        List<TypeProjection> list = this.getDelegate().getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DelegatingType", "getArguments"));
        }
        return list;
    }

    @Override
    public boolean isNullable() {
        return this.getDelegate().isNullable();
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.getDelegate().getMemberScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DelegatingType", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    public boolean isError() {
        return this.getDelegate().isError();
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations = this.getDelegate().getAnnotations();
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DelegatingType", "getAnnotations"));
        }
        return annotations;
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        if (capabilityClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilityClass", "org/jetbrains/jet/lang/types/DelegatingType", "getCapability"));
        }
        if (capabilityClass.isInstance(this)) {
            return (T)((TypeCapability)((Object)this));
        }
        return this.getDelegate().getCapability(capabilityClass);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JetType)) {
            return false;
        }
        JetType type = (JetType)obj;
        return JetTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(this, type);
    }

    public String toString() {
        return this.getDelegate().toString();
    }
}

