/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class SubstitutionUtils {
    private SubstitutionUtils() {
    }

    @NotNull
    public static TypeSubstitutor buildDeepSubstitutor(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildDeepSubstitutor"));
        }
        HashMap<TypeConstructor, TypeProjection> substitution = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(substitution);
        SubstitutionUtils.fillInDeepSubstitutor(type, typeSubstitutor, substitution, null);
        TypeSubstitutor typeSubstitutor2 = typeSubstitutor;
        if (typeSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildDeepSubstitutor"));
        }
        return typeSubstitutor2;
    }

    @NotNull
    public static Multimap<TypeConstructor, TypeProjection> buildDeepSubstitutionMultimap(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildDeepSubstitutionMultimap"));
        }
        LinkedHashMultimap<TypeConstructor, TypeProjection> fullSubstitution = LinkedHashMultimap.create();
        HashMap<TypeConstructor, TypeProjection> substitution = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(substitution);
        SubstitutionUtils.fillInDeepSubstitutor(type, typeSubstitutor, substitution, fullSubstitution);
        LinkedHashMultimap<TypeConstructor, TypeProjection> linkedHashMultimap = fullSubstitution;
        if (linkedHashMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildDeepSubstitutionMultimap"));
        }
        return linkedHashMultimap;
    }

    private static void fillInDeepSubstitutor(@NotNull JetType context2, @NotNull TypeSubstitutor substitutor, @NotNull Map<TypeConstructor, TypeProjection> substitution, @Nullable Multimap<TypeConstructor, TypeProjection> fullSubstitution) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/SubstitutionUtils", "fillInDeepSubstitutor"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/types/SubstitutionUtils", "fillInDeepSubstitutor"));
        }
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "org/jetbrains/jet/lang/types/SubstitutionUtils", "fillInDeepSubstitutor"));
        }
        List<TypeParameterDescriptor> parameters = context2.getConstructor().getParameters();
        List<TypeProjection> arguments = context2.getArguments();
        if (parameters.size() != arguments.size()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < arguments.size(); ++i) {
            TypeProjection argument = arguments.get(i);
            TypeParameterDescriptor parameter = parameters.get(i);
            TypeProjection substitute = substitutor.substitute(argument);
            assert (substitute != null);
            substitution.put(parameter.getTypeConstructor(), substitute);
            if (fullSubstitution == null) continue;
            fullSubstitution.put(parameter.getTypeConstructor(), substitute);
        }
        if (KotlinBuiltIns.getInstance().isNothingOrNullableNothing(context2)) {
            return;
        }
        for (JetType supertype : context2.getConstructor().getSupertypes()) {
            SubstitutionUtils.fillInDeepSubstitutor(supertype, substitutor, substitution, fullSubstitution);
        }
    }
}

